package sharin.unlinq.iterable;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;

import sharin.unlinq.QueuedIterator;

public class ExceptIterable<T> implements Iterable<T> {

    private final Iterable<T> first;

    private final Iterable<T> second;

    public ExceptIterable(Iterable<T> first, Iterable<T> second) {
        this.first = first;
        this.second = second;
    }

    public Iterator<T> iterator() {
        return new QueuedIterator<T, T, T>(first.iterator()) {

            private final Set<T> firstSet = new HashSet<T>();

            private final Set<T> secondSet = new HashSet<T>();

            {
                for (T t : second) {
                    secondSet.add(t);
                }
            }

            @Override
            protected void addElement(Queue<T> queue, T t) {

                if (!secondSet.contains(t) && !firstSet.contains(t)) {
                    queue.add(t);
                    firstSet.add(t);
                }
            }

            @Override
            protected T toResult(T e) {
                return e;
            }
        };
    }
}
