package sharin.unlinq.iterable;

import java.util.Iterator;
import java.util.Queue;

import sharin.unlinq.ConcatenatedIterator;
import sharin.unlinq.QueuedIterator;

public class ConcatIterable<T> implements Iterable<T> {

    private final Iterable<T> first;

    private final Iterable<T> second;

    public ConcatIterable(Iterable<T> first, Iterable<T> second) {
        this.first = first;
        this.second = second;
    }

    public Iterator<T> iterator() {
        return new QueuedIterator<T, T, T>(new ConcatenatedIterator<T>(first
                .iterator(), second)) {

            @Override
            protected void addElement(Queue<T> queue, T t) {
                queue.add(t);
            }

            @Override
            protected T toResult(T e) {
                return e;
            }
        };
    }
}
