/*
 * Decompiled with CFR 0.152.
 */
package sharin.unlinq.iterable;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import sharin.unlinq.QueuedIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntersectIterable<T>
implements Iterable<T> {
    private final Iterable<T> iterable;
    private final Iterable<T> second;

    public IntersectIterable(Iterable<T> iterable, Iterable<T> second) {
        this.iterable = iterable;
        this.second = second;
    }

    @Override
    public Iterator<T> iterator() {
        return new QueuedIterator<T, T, T>(this.iterable.iterator()){
            private final Set<T> firstSet;
            private final Set<T> secondSet;
            {
                this.firstSet = new HashSet();
                this.secondSet = new HashSet();
                for (Object t : IntersectIterable.this.second) {
                    this.secondSet.add(t);
                }
            }

            @Override
            protected void addElement(Queue<T> queue, T t) {
                if (this.secondSet.contains(t) && !this.firstSet.contains(t)) {
                    queue.add(t);
                    this.firstSet.add(t);
                }
            }

            @Override
            protected T toResult(T e) {
                return e;
            }
        };
    }
}

