/*
 * Decompiled with CFR 0.152.
 */
package sharin.sql.runner;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import sharin.sql.Sql;
import sharin.sql.runner.ResultSetProcessor;
import sharin.sql.runner.SqlRunner;
import sharin.util.SqlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSqlRunner
implements SqlRunner {
    private final DataSource dataSource;
    private final ResultSetProcessor objectProcessor;
    private final ResultSetProcessor idProcessor;

    public BasicSqlRunner(DataSource dataSource) {
        this(dataSource, null);
    }

    public BasicSqlRunner(DataSource dataSource, ResultSetProcessor objectProcessor) {
        this(dataSource, objectProcessor, null);
    }

    public BasicSqlRunner(DataSource dataSource, ResultSetProcessor objectProcessor, ResultSetProcessor idProcessor) {
        this.dataSource = dataSource;
        this.objectProcessor = objectProcessor;
        this.idProcessor = idProcessor;
    }

    @Override
    public <R> R selectForObject(Sql sql) {
        return this.selectForObject(sql, this.objectProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R selectForObject(Sql sql, ResultSetProcessor processor) {
        Object result = null;
        Connection conn = SqlUtils.getConnection(this.dataSource);
        try {
            PreparedStatement stmt = SqlUtils.prepareStatement(conn, sql.getText());
            try {
                Object[] params = sql.getParams();
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        SqlUtils.setObject(stmt, i + 1, params[i]);
                    }
                }
                ResultSet rs = SqlUtils.executeQuery(stmt);
                try {
                    Object context = processor.prepare(rs);
                    if (SqlUtils.next(rs)) {
                        result = processor.process(rs, context);
                    }
                }
                finally {
                    SqlUtils.close(rs);
                }
            }
            finally {
                SqlUtils.close(stmt);
            }
        }
        finally {
            SqlUtils.close(conn);
        }
        return (R)result;
    }

    @Override
    public <R> List<R> selectForList(Sql sql) {
        return this.selectForList(sql, this.objectProcessor);
    }

    @Override
    public <R> List<R> selectForList(Sql sql, ResultSetProcessor processor) {
        return this.selectForList(sql, Integer.MAX_VALUE, 0, processor);
    }

    @Override
    public <R> List<R> selectForList(Sql sql, int limit, int offset) {
        return this.selectForList(sql, limit, offset, this.objectProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> List<R> selectForList(Sql sql, int limit, int offset, ResultSetProcessor processor) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        Connection conn = SqlUtils.getConnection(this.dataSource);
        try {
            PreparedStatement stmt = SqlUtils.prepareStatement(conn, sql.getText());
            try {
                Object[] params = sql.getParams();
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        SqlUtils.setObject(stmt, i + 1, params[i]);
                    }
                }
                ResultSet rs = SqlUtils.executeQuery(stmt);
                try {
                    int i;
                    Object context = processor.prepare(rs);
                    for (i = 0; i < offset; ++i) {
                        if (SqlUtils.next(rs)) continue;
                        ArrayList<Object> arrayList = resultList;
                        return arrayList;
                    }
                    for (i = 0; i < limit; ++i) {
                        if (!SqlUtils.next(rs)) {
                            break;
                        }
                        resultList.add(processor.process(rs, context));
                    }
                }
                finally {
                    SqlUtils.close(rs);
                }
            }
            finally {
                SqlUtils.close(stmt);
            }
        }
        finally {
            SqlUtils.close(conn);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insert(Sql sql) {
        int count = 0;
        Connection conn = SqlUtils.getConnection(this.dataSource);
        try {
            PreparedStatement stmt = SqlUtils.prepareStatement(conn, sql.getText());
            try {
                Object[] params = sql.getParams();
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        SqlUtils.setObject(stmt, i + 1, params[i]);
                    }
                }
                count = SqlUtils.executeUpdate(stmt);
            }
            finally {
                SqlUtils.close(stmt);
            }
        }
        finally {
            SqlUtils.close(conn);
        }
        return count;
    }

    @Override
    public <I> I insertForId(Sql sql) {
        return this.insertForId(sql, this.idProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <I> I insertForId(Sql sql, ResultSetProcessor processor) {
        Object id;
        block12: {
            id = null;
            Connection conn = SqlUtils.getConnection(this.dataSource);
            try {
                PreparedStatement stmt = SqlUtils.prepareStatement(conn, sql.getText());
                try {
                    int count;
                    Object[] params = sql.getParams();
                    if (params != null) {
                        for (int i = 0; i < params.length; ++i) {
                            SqlUtils.setObject(stmt, i + 1, params[i]);
                        }
                    }
                    if ((count = SqlUtils.executeUpdate(stmt)) != 1) break block12;
                    ResultSet rs = SqlUtils.getGeneratedKeys(stmt);
                    try {
                        Object context = processor.prepare(rs);
                        if (SqlUtils.next(rs)) {
                            id = processor.process(rs, context);
                        }
                    }
                    finally {
                        SqlUtils.close(rs);
                    }
                }
                finally {
                    SqlUtils.close(stmt);
                }
            }
            finally {
                SqlUtils.close(conn);
            }
        }
        return (I)id;
    }

    @Override
    public int update(Sql sql) {
        assert (sql.getText().substring(0, 6).equalsIgnoreCase("UPDATE"));
        return this.execute(sql);
    }

    @Override
    public int delete(Sql sql) {
        assert (sql.getText().substring(0, 6).equalsIgnoreCase("DELETE"));
        return this.execute(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(Sql sql) {
        int count = 0;
        Connection conn = SqlUtils.getConnection(this.dataSource);
        try {
            PreparedStatement stmt = SqlUtils.prepareStatement(conn, sql.getText());
            try {
                Object[] params = sql.getParams();
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        SqlUtils.setObject(stmt, i + 1, params[i]);
                    }
                }
                count = SqlUtils.executeUpdate(stmt);
            }
            finally {
                SqlUtils.close(stmt);
            }
        }
        finally {
            SqlUtils.close(conn);
        }
        return count;
    }
}

