package sharin.unlinq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicLookup<TKey, TValue> implements Lookup<TKey, TValue> {

    private final Map<TKey, List<TValue>> map;

    public BasicLookup() {
        this(null);
    }

    public BasicLookup(Map<TKey, List<TValue>> map) {

        if (map == null) {
            map = new LinkedHashMap<TKey, List<TValue>>();
        }

        this.map = map;
    }

    private Enumerable<Grouping<TKey, TValue>> getEnumerable() {
        List<Grouping<TKey, TValue>> list = new ArrayList<Grouping<TKey, TValue>>();

        for (Entry<TKey, List<TValue>> entry : map.entrySet()) {
            list.add(new BasicGrouping<TKey, TValue>(entry.getKey(), entry
                    .getValue()));
        }

        return new BasicEnumerable<Grouping<TKey, TValue>>(list);
    }

    @Override
    public String toString() {
        return map.toString();
    }

    public void clear() {
        map.clear();
    }

    public boolean containsKey(Object key) {
        return map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return map.containsValue(value);
    }

    public Set<Entry<TKey, List<TValue>>> entrySet() {
        return map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return map.equals(o);
    }

    public List<TValue> get(Object key) {
        return map.get(key);
    }

    @Override
    public int hashCode() {
        return map.hashCode();
    }

    public boolean isEmpty() {
        return map.isEmpty();
    }

    public Set<TKey> keySet() {
        return map.keySet();
    }

    public List<TValue> put(TKey key, List<TValue> value) {
        return map.put(key, value);
    }

    public void putAll(Map<? extends TKey, ? extends List<TValue>> t) {
        map.putAll(t);
    }

    public List<TValue> remove(Object key) {
        return map.remove(key);
    }

    public int size() {
        return map.size();
    }

    public Collection<List<TValue>> values() {
        return map.values();
    }

    public <A, R> R aggregate(A seed, Func2<A, Grouping<TKey, TValue>, A> func,
            Func<A, R> resultSelector) {
        return getEnumerable().aggregate(seed, func, resultSelector);
    }

    public <A> A aggregate(A seed, Func2<A, Grouping<TKey, TValue>, A> func) {
        return getEnumerable().aggregate(seed, func);
    }

    public Grouping<TKey, TValue> aggregate(
            Func2<Grouping<TKey, TValue>, Grouping<TKey, TValue>, Grouping<TKey, TValue>> func) {
        return getEnumerable().aggregate(func);
    }

    public Boolean all(Func<Grouping<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().all(predicate);
    }

    public Boolean any() {
        return getEnumerable().any();
    }

    public Boolean any(Func<Grouping<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().any(predicate);
    }

    public double average() {
        return getEnumerable().average();
    }

    public double average(Func<Grouping<TKey, TValue>, Integer> selector) {
        return getEnumerable().average(selector);
    }

    public double averageDouble() {
        return getEnumerable().averageDouble();
    }

    public double averageDouble(Func<Grouping<TKey, TValue>, Double> selector) {
        return getEnumerable().averageDouble(selector);
    }

    public float averageFloat() {
        return getEnumerable().averageFloat();
    }

    public float averageFloat(Func<Grouping<TKey, TValue>, Float> selector) {
        return getEnumerable().averageFloat(selector);
    }

    public double averageLong() {
        return getEnumerable().averageLong();
    }

    public double averageLong(Func<Grouping<TKey, TValue>, Long> selector) {
        return getEnumerable().averageLong(selector);
    }

    public <R> Enumerable<R> cast(Class<R> resultClass) {
        return getEnumerable().cast(resultClass);
    }

    public Enumerable<Grouping<TKey, TValue>> concat(
            Enumerable<Grouping<TKey, TValue>> second) {
        return getEnumerable().concat(second);
    }

    public boolean contains(Object o) {
        return getEnumerable().contains(o);
    }

    public int count() {
        return getEnumerable().count();
    }

    public int count(Func<Grouping<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().count(predicate);
    }

    public Enumerable<Grouping<TKey, TValue>> defaultIfEmpty() {
        return getEnumerable().defaultIfEmpty();
    }

    public Enumerable<Grouping<TKey, TValue>> defaultIfEmpty(
            Grouping<TKey, TValue> defaultValue) {
        return getEnumerable().defaultIfEmpty(defaultValue);
    }

    public Enumerable<Grouping<TKey, TValue>> distinct() {
        return getEnumerable().distinct();
    }

    public Grouping<TKey, TValue> elementAt(int index) {
        return getEnumerable().elementAt(index);
    }

    public Grouping<TKey, TValue> elementAtOrDefault(int index,
            Grouping<TKey, TValue> defaultValue) {
        return getEnumerable().elementAtOrDefault(index, defaultValue);
    }

    public Grouping<TKey, TValue> elementAtOrDefault(int index) {
        return getEnumerable().elementAtOrDefault(index);
    }

    public Enumerable<Grouping<TKey, TValue>> except(
            Enumerable<Grouping<TKey, TValue>> second) {
        return getEnumerable().except(second);
    }

    public Grouping<TKey, TValue> first() {
        return getEnumerable().first();
    }

    public Grouping<TKey, TValue> first(
            Func<Grouping<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().first(predicate);
    }

    public Grouping<TKey, TValue> firstOrDefault() {
        return getEnumerable().firstOrDefault();
    }

    public Grouping<TKey, TValue> firstOrDefault(
            Func<Grouping<TKey, TValue>, Boolean> predicate,
            Grouping<TKey, TValue> defaultValue) {
        return getEnumerable().firstOrDefault(predicate, defaultValue);
    }

    public Grouping<TKey, TValue> firstOrDefault(
            Func<Grouping<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().firstOrDefault(predicate);
    }

    public Grouping<TKey, TValue> firstOrDefault(
            Grouping<TKey, TValue> defaultValue) {
        return getEnumerable().firstOrDefault(defaultValue);
    }

    public <K, E, R> Enumerable<R> groupBy(
            Func<Grouping<TKey, TValue>, K> keySelector,
            Func<Grouping<TKey, TValue>, E> elementSelector,
            Func2<K, Enumerable<E>, R> resultSelector) {
        return getEnumerable().groupBy(keySelector, elementSelector,
                resultSelector);
    }

    public <K, E> Enumerable<Grouping<K, E>> groupBy(
            Func<Grouping<TKey, TValue>, K> keySelector,
            Func<Grouping<TKey, TValue>, E> elementSelector) {
        return getEnumerable().groupBy(keySelector, elementSelector);
    }

    public <K, R> Enumerable<R> groupBy(
            Func<Grouping<TKey, TValue>, K> keySelector,
            Func2<K, Enumerable<Grouping<TKey, TValue>>, R> resultSelector) {
        return getEnumerable().groupBy(keySelector, resultSelector);
    }

    public <K> Enumerable<Grouping<K, Grouping<TKey, TValue>>> groupBy(
            Func<Grouping<TKey, TValue>, K> keySelector) {
        return getEnumerable().groupBy(keySelector);
    }

    public <I, K, R> Enumerable<R> groupJoin(Enumerable<I> inner,
            Func<Grouping<TKey, TValue>, K> outerKeySelector,
            Func<I, K> innerKeySelector,
            Func2<Grouping<TKey, TValue>, Enumerable<I>, R> resultSelector) {
        return getEnumerable().groupJoin(inner, outerKeySelector,
                innerKeySelector, resultSelector);
    }

    public Enumerable<Grouping<TKey, TValue>> intersect(
            Enumerable<Grouping<TKey, TValue>> second) {
        return getEnumerable().intersect(second);
    }

    public Iterator<Grouping<TKey, TValue>> iterator() {
        return getEnumerable().iterator();
    }

    public <I, K, R> Enumerable<R> join(Enumerable<I> inner,
            Func<Grouping<TKey, TValue>, K> outerKeySelector,
            Func<I, K> innerKeySelector,
            Func2<Grouping<TKey, TValue>, I, R> resultSelector) {
        return getEnumerable().join(inner, outerKeySelector, innerKeySelector,
                resultSelector);
    }

    public Grouping<TKey, TValue> last() {
        return getEnumerable().last();
    }

    public Grouping<TKey, TValue> last(
            Func<Grouping<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().last(predicate);
    }

    public Grouping<TKey, TValue> lastOrDefault() {
        return getEnumerable().lastOrDefault();
    }

    public Grouping<TKey, TValue> lastOrDefault(
            Func<Grouping<TKey, TValue>, Boolean> predicate,
            Grouping<TKey, TValue> defaultValue) {
        return getEnumerable().lastOrDefault(predicate, defaultValue);
    }

    public Grouping<TKey, TValue> lastOrDefault(
            Func<Grouping<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().lastOrDefault(predicate);
    }

    public Grouping<TKey, TValue> lastOrDefault(
            Grouping<TKey, TValue> defaultValue) {
        return getEnumerable().lastOrDefault(defaultValue);
    }

    public long longCount() {
        return getEnumerable().longCount();
    }

    public long longCount(Func<Grouping<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().longCount(predicate);
    }

    public Grouping<TKey, TValue> max() {
        return getEnumerable().max();
    }

    public <R extends Comparable<R>> R max(
            Func<Grouping<TKey, TValue>, R> selector) {
        return getEnumerable().max(selector);
    }

    public Grouping<TKey, TValue> min() {
        return getEnumerable().min();
    }

    public <R extends Comparable<R>> R min(
            Func<Grouping<TKey, TValue>, R> selector) {
        return getEnumerable().min(selector);
    }

    public <R> Enumerable<R> ofType(Class<R> resultClass) {
        return getEnumerable().ofType(resultClass);
    }

    public <K> OrderedEnumerable<Grouping<TKey, TValue>> orderBy(
            Func<Grouping<TKey, TValue>, K> keySelector,
            Comparator<K> comparator) {
        return getEnumerable().orderBy(keySelector, comparator);
    }

    public <K> OrderedEnumerable<Grouping<TKey, TValue>> orderBy(
            Func<Grouping<TKey, TValue>, K> keySelector) {
        return getEnumerable().orderBy(keySelector);
    }

    public <K> OrderedEnumerable<Grouping<TKey, TValue>> orderByDescending(
            Func<Grouping<TKey, TValue>, K> keySelector,
            Comparator<K> comparator) {
        return getEnumerable().orderByDescending(keySelector, comparator);
    }

    public <K> OrderedEnumerable<Grouping<TKey, TValue>> orderByDescending(
            Func<Grouping<TKey, TValue>, K> keySelector) {
        return getEnumerable().orderByDescending(keySelector);
    }

    public Enumerable<Grouping<TKey, TValue>> reverse() {
        return getEnumerable().reverse();
    }

    public <R> Enumerable<R> select(Func<Grouping<TKey, TValue>, R> selector) {
        return getEnumerable().select(selector);
    }

    public <R> Enumerable<R> select(
            Func2<Grouping<TKey, TValue>, Integer, R> selector) {
        return getEnumerable().select(selector);
    }

    public <C, R> Enumerable<R> selectMany(
            Func<Grouping<TKey, TValue>, Enumerable<C>> collectionSelector,
            Func2<Grouping<TKey, TValue>, C, R> resultSelector) {
        return getEnumerable().selectMany(collectionSelector, resultSelector);
    }

    public <R> Enumerable<R> selectMany(
            Func<Grouping<TKey, TValue>, Enumerable<R>> selector) {
        return getEnumerable().selectMany(selector);
    }

    public <C, R> Enumerable<R> selectMany(
            Func2<Grouping<TKey, TValue>, Integer, Enumerable<C>> collectionSelector,
            Func2<Grouping<TKey, TValue>, C, R> resultSelector) {
        return getEnumerable().selectMany(collectionSelector, resultSelector);
    }

    public <R> Enumerable<R> selectMany(
            Func2<Grouping<TKey, TValue>, Integer, Enumerable<R>> selector) {
        return getEnumerable().selectMany(selector);
    }

    public Boolean sequenceEqual(Enumerable<Grouping<TKey, TValue>> second) {
        return getEnumerable().sequenceEqual(second);
    }

    public Grouping<TKey, TValue> single() {
        return getEnumerable().single();
    }

    public Grouping<TKey, TValue> single(
            Func<Grouping<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().single(predicate);
    }

    public Grouping<TKey, TValue> singleOrDefault() {
        return getEnumerable().singleOrDefault();
    }

    public Grouping<TKey, TValue> singleOrDefault(
            Func<Grouping<TKey, TValue>, Boolean> predicate,
            Grouping<TKey, TValue> defaultValue) {
        return getEnumerable().singleOrDefault(predicate, defaultValue);
    }

    public Grouping<TKey, TValue> singleOrDefault(
            Func<Grouping<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().singleOrDefault(predicate);
    }

    public Grouping<TKey, TValue> singleOrDefault(
            Grouping<TKey, TValue> defaultValue) {
        return getEnumerable().singleOrDefault(defaultValue);
    }

    public Enumerable<Grouping<TKey, TValue>> skip(int count) {
        return getEnumerable().skip(count);
    }

    public Enumerable<Grouping<TKey, TValue>> skipWhile(
            Func<Grouping<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().skipWhile(predicate);
    }

    public Enumerable<Grouping<TKey, TValue>> skipWhile(
            Func2<Grouping<TKey, TValue>, Integer, Boolean> predicate) {
        return getEnumerable().skipWhile(predicate);
    }

    public int sum() {
        return getEnumerable().sum();
    }

    public int sum(Func<Grouping<TKey, TValue>, Integer> selector) {
        return getEnumerable().sum(selector);
    }

    public double sumDouble() {
        return getEnumerable().sumDouble();
    }

    public double sumDouble(Func<Grouping<TKey, TValue>, Double> selector) {
        return getEnumerable().sumDouble(selector);
    }

    public float sumFloat() {
        return getEnumerable().sumFloat();
    }

    public float sumFloat(Func<Grouping<TKey, TValue>, Float> selector) {
        return getEnumerable().sumFloat(selector);
    }

    public long sumLong() {
        return getEnumerable().sumLong();
    }

    public long sumLong(Func<Grouping<TKey, TValue>, Long> selector) {
        return getEnumerable().sumLong(selector);
    }

    public Enumerable<Grouping<TKey, TValue>> take(int count) {
        return getEnumerable().take(count);
    }

    public Enumerable<Grouping<TKey, TValue>> takeWhile(
            Func<Grouping<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().takeWhile(predicate);
    }

    public Enumerable<Grouping<TKey, TValue>> takeWhile(
            Func2<Grouping<TKey, TValue>, Integer, Boolean> predicate) {
        return getEnumerable().takeWhile(predicate);
    }

    public Object[] toArray() {
        return getEnumerable().toArray();
    }

    public <R> R[] toArray(Class<R> resultClass) {
        return getEnumerable().toArray(resultClass);
    }

    public <K, E> Dictionary<K, E> toDictionary(
            Func<Grouping<TKey, TValue>, K> keySelector,
            Func<Grouping<TKey, TValue>, E> elementSelector) {
        return getEnumerable().toDictionary(keySelector, elementSelector);
    }

    public <K> Dictionary<K, Grouping<TKey, TValue>> toDictionary(
            Func<Grouping<TKey, TValue>, K> keySelector) {
        return getEnumerable().toDictionary(keySelector);
    }

    public EnumerableList<Grouping<TKey, TValue>> toEnumerableList() {
        return getEnumerable().toEnumerableList();
    }

    public List<Grouping<TKey, TValue>> toList() {
        return getEnumerable().toList();
    }

    public <K, E> Map<K, List<E>> toListMap(
            Func<Grouping<TKey, TValue>, K> keySelector,
            Func<Grouping<TKey, TValue>, E> elementSelector) {
        return getEnumerable().toListMap(keySelector, elementSelector);
    }

    public <K> Map<K, List<Grouping<TKey, TValue>>> toListMap(
            Func<Grouping<TKey, TValue>, K> keySelector) {
        return getEnumerable().toListMap(keySelector);
    }

    public <K, E> Lookup<K, E> toLookup(
            Func<Grouping<TKey, TValue>, K> keySelector,
            Func<Grouping<TKey, TValue>, E> elementSelector) {
        return getEnumerable().toLookup(keySelector, elementSelector);
    }

    public <K> Lookup<K, Grouping<TKey, TValue>> toLookup(
            Func<Grouping<TKey, TValue>, K> keySelector) {
        return getEnumerable().toLookup(keySelector);
    }

    public <K, E> Map<K, E> toMap(Func<Grouping<TKey, TValue>, K> keySelector,
            Func<Grouping<TKey, TValue>, E> elementSelector) {
        return getEnumerable().toMap(keySelector, elementSelector);
    }

    public <K> Map<K, Grouping<TKey, TValue>> toMap(
            Func<Grouping<TKey, TValue>, K> keySelector) {
        return getEnumerable().toMap(keySelector);
    }

    public Enumerable<Grouping<TKey, TValue>> union(
            Enumerable<Grouping<TKey, TValue>> second) {
        return getEnumerable().union(second);
    }

    public Enumerable<Grouping<TKey, TValue>> where(
            Func<Grouping<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().where(predicate);
    }

    public Enumerable<Grouping<TKey, TValue>> where(
            Func2<Grouping<TKey, TValue>, Integer, Boolean> predicate) {
        return getEnumerable().where(predicate);
    }
}
