package sharin.unlinq;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicDictionary<TKey, TValue> implements Dictionary<TKey, TValue> {

    private Map<TKey, TValue> map;

    public BasicDictionary() {
        this(null);
    }

    public BasicDictionary(Map<TKey, TValue> map) {

        if (map == null) {
            map = new LinkedHashMap<TKey, TValue>();
        }

        this.map = map;
    }

    private Enumerable<Entry<TKey, TValue>> getEnumerable() {
        return new BasicEnumerable<Entry<TKey, TValue>>(map.entrySet());
    }

    @Override
    public String toString() {
        return map.toString();
    }

    public void clear() {
        map.clear();
    }

    public boolean containsKey(Object key) {
        return map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return map.containsValue(value);
    }

    public Set<Entry<TKey, TValue>> entrySet() {
        return map.entrySet();
    }

    public TValue get(Object key) {
        return map.get(key);
    }

    public boolean isEmpty() {
        return map.isEmpty();
    }

    public Set<TKey> keySet() {
        return map.keySet();
    }

    public TValue put(TKey key, TValue value) {
        return map.put(key, value);
    }

    public void putAll(Map<? extends TKey, ? extends TValue> t) {
        map.putAll(t);
    }

    public TValue remove(Object key) {
        return map.remove(key);
    }

    public int size() {
        return map.size();
    }

    public Collection<TValue> values() {
        return map.values();
    }

    public <A, R> R aggregate(A seed, Func2<A, Entry<TKey, TValue>, A> func,
            Func<A, R> resultSelector) {
        return getEnumerable().aggregate(seed, func, resultSelector);
    }

    public <A> A aggregate(A seed, Func2<A, Entry<TKey, TValue>, A> func) {
        return getEnumerable().aggregate(seed, func);
    }

    public Entry<TKey, TValue> aggregate(
            Func2<Entry<TKey, TValue>, Entry<TKey, TValue>, Entry<TKey, TValue>> func) {
        return getEnumerable().aggregate(func);
    }

    public Boolean all(Func<Entry<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().all(predicate);
    }

    public Boolean any() {
        return getEnumerable().any();
    }

    public Boolean any(Func<Entry<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().any(predicate);
    }

    public double average() {
        return getEnumerable().average();
    }

    public double average(Func<Entry<TKey, TValue>, Integer> selector) {
        return getEnumerable().average(selector);
    }

    public double averageDouble() {
        return getEnumerable().averageDouble();
    }

    public double averageDouble(Func<Entry<TKey, TValue>, Double> selector) {
        return getEnumerable().averageDouble(selector);
    }

    public float averageFloat() {
        return getEnumerable().averageFloat();
    }

    public float averageFloat(Func<Entry<TKey, TValue>, Float> selector) {
        return getEnumerable().averageFloat(selector);
    }

    public double averageLong() {
        return getEnumerable().averageLong();
    }

    public double averageLong(Func<Entry<TKey, TValue>, Long> selector) {
        return getEnumerable().averageLong(selector);
    }

    public <R> Enumerable<R> cast(Class<R> resultClass) {
        return getEnumerable().cast(resultClass);
    }

    public Enumerable<Entry<TKey, TValue>> concat(
            Enumerable<Entry<TKey, TValue>> second) {
        return getEnumerable().concat(second);
    }

    public boolean contains(Object o) {
        return getEnumerable().contains(o);
    }

    public int count() {
        return getEnumerable().count();
    }

    public int count(Func<Entry<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().count(predicate);
    }

    public Enumerable<Entry<TKey, TValue>> defaultIfEmpty() {
        return getEnumerable().defaultIfEmpty();
    }

    public Enumerable<Entry<TKey, TValue>> defaultIfEmpty(
            Entry<TKey, TValue> defaultValue) {
        return getEnumerable().defaultIfEmpty(defaultValue);
    }

    public Enumerable<Entry<TKey, TValue>> distinct() {
        return getEnumerable().distinct();
    }

    public Entry<TKey, TValue> elementAt(int index) {
        return getEnumerable().elementAt(index);
    }

    public Entry<TKey, TValue> elementAtOrDefault(int index,
            Entry<TKey, TValue> defaultValue) {
        return getEnumerable().elementAtOrDefault(index, defaultValue);
    }

    public Entry<TKey, TValue> elementAtOrDefault(int index) {
        return getEnumerable().elementAtOrDefault(index);
    }

    public Enumerable<Entry<TKey, TValue>> except(
            Enumerable<Entry<TKey, TValue>> second) {
        return getEnumerable().except(second);
    }

    public Entry<TKey, TValue> first() {
        return getEnumerable().first();
    }

    public Entry<TKey, TValue> first(
            Func<Entry<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().first(predicate);
    }

    public Entry<TKey, TValue> firstOrDefault() {
        return getEnumerable().firstOrDefault();
    }

    public Entry<TKey, TValue> firstOrDefault(Entry<TKey, TValue> defaultValue) {
        return getEnumerable().firstOrDefault(defaultValue);
    }

    public Entry<TKey, TValue> firstOrDefault(
            Func<Entry<TKey, TValue>, Boolean> predicate,
            Entry<TKey, TValue> defaultValue) {
        return getEnumerable().firstOrDefault(predicate, defaultValue);
    }

    public Entry<TKey, TValue> firstOrDefault(
            Func<Entry<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().firstOrDefault(predicate);
    }

    public <K, E, R> Enumerable<R> groupBy(
            Func<Entry<TKey, TValue>, K> keySelector,
            Func<Entry<TKey, TValue>, E> elementSelector,
            Func2<K, Enumerable<E>, R> resultSelector) {
        return getEnumerable().groupBy(keySelector, elementSelector,
                resultSelector);
    }

    public <K, E> Enumerable<Grouping<K, E>> groupBy(
            Func<Entry<TKey, TValue>, K> keySelector,
            Func<Entry<TKey, TValue>, E> elementSelector) {
        return getEnumerable().groupBy(keySelector, elementSelector);
    }

    public <K, R> Enumerable<R> groupBy(
            Func<Entry<TKey, TValue>, K> keySelector,
            Func2<K, Enumerable<Entry<TKey, TValue>>, R> resultSelector) {
        return getEnumerable().groupBy(keySelector, resultSelector);
    }

    public <K> Enumerable<Grouping<K, Entry<TKey, TValue>>> groupBy(
            Func<Entry<TKey, TValue>, K> keySelector) {
        return getEnumerable().groupBy(keySelector);
    }

    public <I, K, R> Enumerable<R> groupJoin(Enumerable<I> inner,
            Func<Entry<TKey, TValue>, K> outerKeySelector,
            Func<I, K> innerKeySelector,
            Func2<Entry<TKey, TValue>, Enumerable<I>, R> resultSelector) {
        return getEnumerable().groupJoin(inner, outerKeySelector,
                innerKeySelector, resultSelector);
    }

    public Enumerable<Entry<TKey, TValue>> intersect(
            Enumerable<Entry<TKey, TValue>> second) {
        return getEnumerable().intersect(second);
    }

    public Iterator<Entry<TKey, TValue>> iterator() {
        return getEnumerable().iterator();
    }

    public <I, K, R> Enumerable<R> join(Enumerable<I> inner,
            Func<Entry<TKey, TValue>, K> outerKeySelector,
            Func<I, K> innerKeySelector,
            Func2<Entry<TKey, TValue>, I, R> resultSelector) {
        return getEnumerable().join(inner, outerKeySelector, innerKeySelector,
                resultSelector);
    }

    public Entry<TKey, TValue> last() {
        return getEnumerable().last();
    }

    public Entry<TKey, TValue> last(Func<Entry<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().last(predicate);
    }

    public Entry<TKey, TValue> lastOrDefault() {
        return getEnumerable().lastOrDefault();
    }

    public Entry<TKey, TValue> lastOrDefault(Entry<TKey, TValue> defaultValue) {
        return getEnumerable().lastOrDefault(defaultValue);
    }

    public Entry<TKey, TValue> lastOrDefault(
            Func<Entry<TKey, TValue>, Boolean> predicate,
            Entry<TKey, TValue> defaultValue) {
        return getEnumerable().lastOrDefault(predicate, defaultValue);
    }

    public Entry<TKey, TValue> lastOrDefault(
            Func<Entry<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().lastOrDefault(predicate);
    }

    public long longCount() {
        return getEnumerable().longCount();
    }

    public long longCount(Func<Entry<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().longCount(predicate);
    }

    public Entry<TKey, TValue> max() {
        return getEnumerable().max();
    }

    public <R extends Comparable<R>> R max(Func<Entry<TKey, TValue>, R> selector) {
        return getEnumerable().max(selector);
    }

    public Entry<TKey, TValue> min() {
        return getEnumerable().min();
    }

    public <R extends Comparable<R>> R min(Func<Entry<TKey, TValue>, R> selector) {
        return getEnumerable().min(selector);
    }

    public <R> Enumerable<R> ofType(Class<R> resultClass) {
        return getEnumerable().ofType(resultClass);
    }

    public <K> OrderedEnumerable<Entry<TKey, TValue>> orderBy(
            Func<Entry<TKey, TValue>, K> keySelector, Comparator<K> comparator) {
        return getEnumerable().orderBy(keySelector, comparator);
    }

    public <K> OrderedEnumerable<Entry<TKey, TValue>> orderBy(
            Func<Entry<TKey, TValue>, K> keySelector) {
        return getEnumerable().orderBy(keySelector);
    }

    public <K> OrderedEnumerable<Entry<TKey, TValue>> orderByDescending(
            Func<Entry<TKey, TValue>, K> keySelector, Comparator<K> comparator) {
        return getEnumerable().orderByDescending(keySelector, comparator);
    }

    public <K> OrderedEnumerable<Entry<TKey, TValue>> orderByDescending(
            Func<Entry<TKey, TValue>, K> keySelector) {
        return getEnumerable().orderByDescending(keySelector);
    }

    public Enumerable<Entry<TKey, TValue>> reverse() {
        return getEnumerable().reverse();
    }

    public <R> Enumerable<R> select(Func<Entry<TKey, TValue>, R> selector) {
        return getEnumerable().select(selector);
    }

    public <R> Enumerable<R> select(
            Func2<Entry<TKey, TValue>, Integer, R> selector) {
        return getEnumerable().select(selector);
    }

    public <C, R> Enumerable<R> selectMany(
            Func<Entry<TKey, TValue>, Enumerable<C>> collectionSelector,
            Func2<Entry<TKey, TValue>, C, R> resultSelector) {
        return getEnumerable().selectMany(collectionSelector, resultSelector);
    }

    public <R> Enumerable<R> selectMany(
            Func<Entry<TKey, TValue>, Enumerable<R>> selector) {
        return getEnumerable().selectMany(selector);
    }

    public <C, R> Enumerable<R> selectMany(
            Func2<Entry<TKey, TValue>, Integer, Enumerable<C>> collectionSelector,
            Func2<Entry<TKey, TValue>, C, R> resultSelector) {
        return getEnumerable().selectMany(collectionSelector, resultSelector);
    }

    public <R> Enumerable<R> selectMany(
            Func2<Entry<TKey, TValue>, Integer, Enumerable<R>> selector) {
        return getEnumerable().selectMany(selector);
    }

    public Boolean sequenceEqual(Enumerable<Entry<TKey, TValue>> second) {
        return getEnumerable().sequenceEqual(second);
    }

    public Entry<TKey, TValue> single() {
        return getEnumerable().single();
    }

    public Entry<TKey, TValue> single(
            Func<Entry<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().single(predicate);
    }

    public Entry<TKey, TValue> singleOrDefault() {
        return getEnumerable().singleOrDefault();
    }

    public Entry<TKey, TValue> singleOrDefault(Entry<TKey, TValue> defaultValue) {
        return getEnumerable().singleOrDefault(defaultValue);
    }

    public Entry<TKey, TValue> singleOrDefault(
            Func<Entry<TKey, TValue>, Boolean> predicate,
            Entry<TKey, TValue> defaultValue) {
        return getEnumerable().singleOrDefault(predicate, defaultValue);
    }

    public Entry<TKey, TValue> singleOrDefault(
            Func<Entry<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().singleOrDefault(predicate);
    }

    public Enumerable<Entry<TKey, TValue>> skip(int count) {
        return getEnumerable().skip(count);
    }

    public Enumerable<Entry<TKey, TValue>> skipWhile(
            Func<Entry<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().skipWhile(predicate);
    }

    public Enumerable<Entry<TKey, TValue>> skipWhile(
            Func2<Entry<TKey, TValue>, Integer, Boolean> predicate) {
        return getEnumerable().skipWhile(predicate);
    }

    public int sum() {
        return getEnumerable().sum();
    }

    public int sum(Func<Entry<TKey, TValue>, Integer> selector) {
        return getEnumerable().sum(selector);
    }

    public double sumDouble() {
        return getEnumerable().sumDouble();
    }

    public double sumDouble(Func<Entry<TKey, TValue>, Double> selector) {
        return getEnumerable().sumDouble(selector);
    }

    public float sumFloat() {
        return getEnumerable().sumFloat();
    }

    public float sumFloat(Func<Entry<TKey, TValue>, Float> selector) {
        return getEnumerable().sumFloat(selector);
    }

    public long sumLong() {
        return getEnumerable().sumLong();
    }

    public long sumLong(Func<Entry<TKey, TValue>, Long> selector) {
        return getEnumerable().sumLong(selector);
    }

    public Enumerable<Entry<TKey, TValue>> take(int count) {
        return getEnumerable().take(count);
    }

    public Enumerable<Entry<TKey, TValue>> takeWhile(
            Func<Entry<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().takeWhile(predicate);
    }

    public Enumerable<Entry<TKey, TValue>> takeWhile(
            Func2<Entry<TKey, TValue>, Integer, Boolean> predicate) {
        return getEnumerable().takeWhile(predicate);
    }

    public Object[] toArray() {
        return getEnumerable().toArray();
    }

    public <R> R[] toArray(Class<R> resultClass) {
        return getEnumerable().toArray(resultClass);
    }

    public <K, E> Dictionary<K, E> toDictionary(
            Func<Entry<TKey, TValue>, K> keySelector,
            Func<Entry<TKey, TValue>, E> elementSelector) {
        return getEnumerable().toDictionary(keySelector, elementSelector);
    }

    public <K> Dictionary<K, Entry<TKey, TValue>> toDictionary(
            Func<Entry<TKey, TValue>, K> keySelector) {
        return getEnumerable().toDictionary(keySelector);
    }

    public EnumerableList<Entry<TKey, TValue>> toEnumerableList() {
        return getEnumerable().toEnumerableList();
    }

    public List<Entry<TKey, TValue>> toList() {
        return getEnumerable().toList();
    }

    public <K, E> Map<K, List<E>> toListMap(
            Func<Entry<TKey, TValue>, K> keySelector,
            Func<Entry<TKey, TValue>, E> elementSelector) {
        return getEnumerable().toListMap(keySelector, elementSelector);
    }

    public <K> Map<K, List<Entry<TKey, TValue>>> toListMap(
            Func<Entry<TKey, TValue>, K> keySelector) {
        return getEnumerable().toListMap(keySelector);
    }

    public <K, E> Lookup<K, E> toLookup(
            Func<Entry<TKey, TValue>, K> keySelector,
            Func<Entry<TKey, TValue>, E> elementSelector) {
        return getEnumerable().toLookup(keySelector, elementSelector);
    }

    public <K> Lookup<K, Entry<TKey, TValue>> toLookup(
            Func<Entry<TKey, TValue>, K> keySelector) {
        return getEnumerable().toLookup(keySelector);
    }

    public <K, E> Map<K, E> toMap(Func<Entry<TKey, TValue>, K> keySelector,
            Func<Entry<TKey, TValue>, E> elementSelector) {
        return getEnumerable().toMap(keySelector, elementSelector);
    }

    public <K> Map<K, Entry<TKey, TValue>> toMap(
            Func<Entry<TKey, TValue>, K> keySelector) {
        return getEnumerable().toMap(keySelector);
    }

    public Enumerable<Entry<TKey, TValue>> union(
            Enumerable<Entry<TKey, TValue>> second) {
        return getEnumerable().union(second);
    }

    public Enumerable<Entry<TKey, TValue>> where(
            Func<Entry<TKey, TValue>, Boolean> predicate) {
        return getEnumerable().where(predicate);
    }

    public Enumerable<Entry<TKey, TValue>> where(
            Func2<Entry<TKey, TValue>, Integer, Boolean> predicate) {
        return getEnumerable().where(predicate);
    }
}
