package sharin.sql.runner.converter;

import java.sql.ResultSet;

import sharin.sql.runner.ColumnConverter;
import sharin.util.SqlUtils;

public class LongColumnConverter implements ColumnConverter {

    public Object convert(ResultSet rs, int columnIndex) {
        long value = SqlUtils.getLong(rs, columnIndex);

        if (value == 0 && SqlUtils.wasNull(rs)) {
            return null;
        }

        return value;
    }
}
