/*
 * Decompiled with CFR 0.152.
 */
package sharin.unlinq;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import sharin.unlinq.BasicDictionary;
import sharin.unlinq.BasicEnumerableList;
import sharin.unlinq.BasicGrouping;
import sharin.unlinq.BasicLookup;
import sharin.unlinq.BasicOrderedEnumerable;
import sharin.unlinq.ConcatenatedIterator;
import sharin.unlinq.Dictionary;
import sharin.unlinq.Enumerable;
import sharin.unlinq.EnumerableList;
import sharin.unlinq.Func;
import sharin.unlinq.Func2;
import sharin.unlinq.Grouping;
import sharin.unlinq.Lookup;
import sharin.unlinq.OrderedEnumerable;
import sharin.unlinq.Pair;
import sharin.unlinq.QueuedIterator;
import sharin.util.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicEnumerable<T>
implements Enumerable<T> {
    private final Iterable<T> iterable;

    public BasicEnumerable(Iterable<T> iterable) {
        if (iterable == null) {
            iterable = Collections.emptyList();
        }
        this.iterable = iterable;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterable.iterator();
    }

    public static <E> Enumerable<E> from(Iterable<E> iterable) {
        return new BasicEnumerable<E>(iterable);
    }

    public static <E> Enumerable<E> from(E ... objects) {
        if (objects == null) {
            return new BasicEnumerable(null);
        }
        return new BasicEnumerable<E>(Arrays.asList(objects));
    }

    public static Enumerable<Boolean> fromBoolean(boolean ... values) {
        return new BasicEnumerable<Boolean>(Arrays.asList(ArrayUtils.toWrappers(values)));
    }

    public static Enumerable<Byte> fromByte(byte ... values) {
        return new BasicEnumerable<Byte>(Arrays.asList(ArrayUtils.toWrappers(values)));
    }

    public static Enumerable<Character> fromChar(char ... values) {
        return new BasicEnumerable<Character>(Arrays.asList(ArrayUtils.toWrappers(values)));
    }

    public static Enumerable<Short> fromShort(short ... values) {
        return new BasicEnumerable<Short>(Arrays.asList(ArrayUtils.toWrappers(values)));
    }

    public static Enumerable<Integer> from(int ... values) {
        return new BasicEnumerable<Integer>(Arrays.asList(ArrayUtils.toWrappers(values)));
    }

    public static Enumerable<Long> fromLong(long ... values) {
        return new BasicEnumerable<Long>(Arrays.asList(ArrayUtils.toWrappers(values)));
    }

    public static Enumerable<Float> fromFloat(float ... values) {
        return new BasicEnumerable<Float>(Arrays.asList(ArrayUtils.toWrappers(values)));
    }

    public static Enumerable<Double> fromDouble(double ... values) {
        return new BasicEnumerable<Double>(Arrays.asList(ArrayUtils.toWrappers(values)));
    }

    @Override
    public T aggregate(Func2<T, T, T> func) {
        Iterator<T> iterator = this.iterable.iterator();
        T seed = iterator.next();
        return this.doAggregate(seed, func, iterator);
    }

    @Override
    public <A> A aggregate(A seed, Func2<A, T, A> func) {
        return this.doAggregate(seed, func, this.iterable.iterator());
    }

    @Override
    public <A, R> R aggregate(A seed, Func2<A, T, A> func, Func<A, R> resultSelector) {
        A a = this.doAggregate(seed, func, this.iterable.iterator());
        return resultSelector.call(a);
    }

    private <A> A doAggregate(A seed, Func2<A, T, A> func, Iterator<T> iterator) {
        A a = seed;
        while (iterator.hasNext()) {
            a = func.call(a, iterator.next());
        }
        return a;
    }

    @Override
    public Boolean all(Func<T, Boolean> predicate) {
        for (T t : this.iterable) {
            if (predicate.call(t).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean any() {
        return this.iterable.iterator().hasNext();
    }

    @Override
    public Boolean any(Func<T, Boolean> predicate) {
        for (T t : this.iterable) {
            if (!predicate.call(t).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public double average() {
        Iterator<T> iterator = this.iterable.iterator();
        double sum = ((Integer)iterator.next()).intValue();
        int count = 1;
        while (iterator.hasNext()) {
            sum += (double)((Integer)iterator.next()).intValue();
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public double averageLong() {
        Iterator<T> iterator = this.iterable.iterator();
        double sum = ((Long)iterator.next()).longValue();
        int count = 1;
        while (iterator.hasNext()) {
            sum += (double)((Long)iterator.next()).longValue();
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public float averageFloat() {
        Iterator<T> iterator = this.iterable.iterator();
        float sum = ((Float)iterator.next()).floatValue();
        int count = 1;
        while (iterator.hasNext()) {
            sum += ((Float)iterator.next()).floatValue();
            ++count;
        }
        return sum / (float)count;
    }

    @Override
    public double averageDouble() {
        Iterator<T> iterator = this.iterable.iterator();
        double sum = (Double)iterator.next();
        int count = 1;
        while (iterator.hasNext()) {
            sum += ((Double)iterator.next()).doubleValue();
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public double average(Func<T, Integer> selector) {
        Iterator<T> iterator = this.iterable.iterator();
        double sum = selector.call(iterator.next()).intValue();
        int count = 1;
        while (iterator.hasNext()) {
            sum += (double)selector.call(iterator.next()).intValue();
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public double averageLong(Func<T, Long> selector) {
        Iterator<T> iterator = this.iterable.iterator();
        double sum = selector.call(iterator.next()).longValue();
        int count = 1;
        while (iterator.hasNext()) {
            sum += (double)selector.call(iterator.next()).longValue();
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public float averageFloat(Func<T, Float> selector) {
        Iterator<T> iterator = this.iterable.iterator();
        float sum = selector.call(iterator.next()).floatValue();
        int count = 1;
        while (iterator.hasNext()) {
            sum += selector.call(iterator.next()).floatValue();
            ++count;
        }
        return sum / (float)count;
    }

    @Override
    public double averageDouble(Func<T, Double> selector) {
        Iterator<T> iterator = this.iterable.iterator();
        double sum = selector.call(iterator.next());
        int count = 1;
        while (iterator.hasNext()) {
            sum += selector.call(iterator.next()).doubleValue();
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public <R> Enumerable<R> cast(final Class<R> resultClass) {
        return new BasicEnumerable<T>(new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return new Iterator<R>(){
                    private final Iterator<T> iterator;
                    {
                        this.iterator = BasicEnumerable.this.iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public R next() {
                        return resultClass.cast(this.iterator.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    @Override
    public Enumerable<T> concat(final Enumerable<T> second) {
        return new BasicEnumerable<T>(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new QueuedIterator<T, T, T>(new ConcatenatedIterator(BasicEnumerable.this.iterable.iterator(), second.iterator())){

                    @Override
                    protected void addElement(Queue<T> queue, T t) {
                        queue.add(t);
                    }

                    @Override
                    protected T toResult(T e) {
                        return e;
                    }
                };
            }
        });
    }

    @Override
    public boolean contains(Object o) {
        for (T t : this.iterable) {
            if (!this.equals(o, t)) continue;
            return true;
        }
        return false;
    }

    private boolean equals(Object o1, Object o2) {
        return o2 == null ? o1 == null : o2.equals(o1);
    }

    @Override
    public int count() {
        int c = 0;
        Iterator<T> it = this.iterable.iterator();
        while (it.hasNext()) {
            ++c;
            it.next();
        }
        return c;
    }

    @Override
    public int count(Func<T, Boolean> predicate) {
        int c = 0;
        for (T t : this.iterable) {
            if (!predicate.call(t).booleanValue()) continue;
            ++c;
        }
        return c;
    }

    @Override
    public Enumerable<T> defaultIfEmpty() {
        return this.defaultIfEmpty(null);
    }

    @Override
    public Enumerable<T> defaultIfEmpty(T defaultValue) {
        if (this.iterable.iterator().hasNext()) {
            return new BasicEnumerable<T>(this.iterable);
        }
        ArrayList<T> list = new ArrayList<T>();
        list.add(defaultValue);
        return new BasicEnumerable(list);
    }

    @Override
    public Enumerable<T> distinct() {
        return new BasicEnumerable<T>(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new QueuedIterator<T, T, T>(BasicEnumerable.this.iterable.iterator()){
                    private final Set<T> set;
                    {
                        this.set = new HashSet();
                    }

                    @Override
                    protected void addElement(Queue<T> queue, T t) {
                        if (!this.set.contains(t)) {
                            queue.add(t);
                            this.set.add(t);
                        }
                    }

                    @Override
                    protected T toResult(T e) {
                        return e;
                    }
                };
            }
        });
    }

    @Override
    public T elementAt(int index) {
        Iterator<T> iterator = this.iterable.iterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    @Override
    public T elementAtOrDefault(int index) {
        return this.elementAtOrDefault(index, null);
    }

    @Override
    public T elementAtOrDefault(int index, T defaultValue) {
        Iterator<T> iterator = this.iterable.iterator();
        for (int i = 0; i < index; ++i) {
            if (!iterator.hasNext()) {
                return defaultValue;
            }
            iterator.next();
        }
        if (!iterator.hasNext()) {
            return defaultValue;
        }
        return iterator.next();
    }

    public static <R> Enumerable<R> empty() {
        return new BasicEnumerable(null);
    }

    @Override
    public Enumerable<T> except(final Enumerable<T> second) {
        return new BasicEnumerable<T>(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new QueuedIterator<T, T, T>(BasicEnumerable.this.iterable.iterator()){
                    private final Set<T> firstSet;
                    private final Set<T> secondSet;
                    {
                        this.firstSet = new HashSet();
                        this.secondSet = new HashSet(second.toList());
                    }

                    @Override
                    protected void addElement(Queue<T> queue, T t) {
                        if (!this.secondSet.contains(t) && !this.firstSet.contains(t)) {
                            queue.add(t);
                            this.firstSet.add(t);
                        }
                    }

                    @Override
                    protected T toResult(T e) {
                        return e;
                    }
                };
            }
        });
    }

    @Override
    public T first() {
        return this.iterable.iterator().next();
    }

    @Override
    public T first(Func<T, Boolean> predicate) {
        for (T t : this.iterable) {
            if (!predicate.call(t).booleanValue()) continue;
            return t;
        }
        throw new NoSuchElementException();
    }

    @Override
    public T firstOrDefault() {
        return (T)this.firstOrDefault((Object)null);
    }

    @Override
    public T firstOrDefault(T defaultValue) {
        Iterator<T> iterator = this.iterable.iterator();
        if (!iterator.hasNext()) {
            return defaultValue;
        }
        return iterator.next();
    }

    @Override
    public T firstOrDefault(Func<T, Boolean> predicate) {
        return this.firstOrDefault(predicate, null);
    }

    @Override
    public T firstOrDefault(Func<T, Boolean> predicate, T defaultValue) {
        for (T t : this.iterable) {
            if (!predicate.call(t).booleanValue()) continue;
            return t;
        }
        return defaultValue;
    }

    @Override
    public <K> Enumerable<Grouping<K, T>> groupBy(Func<T, K> keySelector) {
        return this.groupBy(keySelector, this.getPassThroughFunc());
    }

    @Override
    public <K, R> Enumerable<R> groupBy(Func<T, K> keySelector, Func2<K, Enumerable<T>, R> resultSelector) {
        return this.groupBy(keySelector, this.getPassThroughFunc(), resultSelector);
    }

    @Override
    public <K, E> Enumerable<Grouping<K, E>> groupBy(Func<T, K> keySelector, Func<T, E> elementSelector) {
        LinkedHashMap<K, List<E>> map = this.doGroupBy(keySelector, elementSelector);
        ArrayList<BasicGrouping<K, T>> groupList = new ArrayList<BasicGrouping<K, T>>();
        for (Map.Entry<K, List<E>> entry : map.entrySet()) {
            groupList.add(new BasicGrouping<K, T>(entry.getKey(), new BasicEnumerable<T>((Iterable)entry.getValue())));
        }
        return new BasicEnumerable<Grouping<K, E>>(groupList);
    }

    @Override
    public <K, E, R> Enumerable<R> groupBy(Func<T, K> keySelector, Func<T, E> elementSelector, Func2<K, Enumerable<E>, R> resultSelector) {
        LinkedHashMap<K, List<E>> map = this.doGroupBy(keySelector, elementSelector);
        ArrayList<R> resultList = new ArrayList<R>();
        for (Map.Entry<K, List<E>> entry : map.entrySet()) {
            resultList.add(resultSelector.call(entry.getKey(), new BasicEnumerable<T>((Iterable)entry.getValue())));
        }
        return new BasicEnumerable(resultList);
    }

    private <E, K> LinkedHashMap<K, List<E>> doGroupBy(Func<T, K> keySelector, Func<T, E> elementSelector) {
        LinkedHashMap<K, ArrayList<E>> map = new LinkedHashMap<K, ArrayList<E>>();
        for (T entity : this.iterable) {
            K key = keySelector.call(entity);
            ArrayList<E> list = (ArrayList<E>)map.get(key);
            if (list == null) {
                list = new ArrayList<E>();
                map.put(key, list);
            }
            list.add(elementSelector.call(entity));
        }
        return map;
    }

    @Override
    public <I, K, R> Enumerable<R> groupJoin(final Enumerable<I> inner, final Func<T, K> outerKeySelector, final Func<I, K> innerKeySelector, final Func2<T, Enumerable<I>, R> resultSelector) {
        return new BasicEnumerable<T>(new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return new Iterator<R>(){
                    private final Iterator<T> iterator;
                    private final Map<K, List<I>> innerListMap;
                    {
                        this.iterator = BasicEnumerable.this.iterable.iterator();
                        this.innerListMap = new HashMap();
                        for (Object innerEntity : inner) {
                            Object innerKey = innerKeySelector.call(innerEntity);
                            List innerList = this.innerListMap.get(innerKey);
                            if (innerList == null) {
                                innerList = new ArrayList();
                                this.innerListMap.put(innerKey, innerList);
                            }
                            innerList.add(innerEntity);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public R next() {
                        Object outerEntity = this.iterator.next();
                        Object outerKey = outerKeySelector.call(outerEntity);
                        List innerList = this.innerListMap.get(outerKey);
                        return resultSelector.call(outerEntity, new BasicEnumerable(innerList));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    @Override
    public Enumerable<T> intersect(final Enumerable<T> second) {
        return new BasicEnumerable<T>(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new QueuedIterator<T, T, T>(BasicEnumerable.this.iterable.iterator()){
                    private final Set<T> firstSet;
                    private final Set<T> secondSet;
                    {
                        this.firstSet = new HashSet();
                        this.secondSet = new HashSet(second.toList());
                    }

                    @Override
                    protected void addElement(Queue<T> queue, T t) {
                        if (this.secondSet.contains(t) && !this.firstSet.contains(t)) {
                            queue.add(t);
                            this.firstSet.add(t);
                        }
                    }

                    @Override
                    protected T toResult(T e) {
                        return e;
                    }
                };
            }
        });
    }

    @Override
    public <I, K, R> Enumerable<R> join(final Enumerable<I> inner, final Func<T, K> outerKeySelector, final Func<I, K> innerKeySelector, final Func2<T, I, R> resultSelector) {
        return new BasicEnumerable<T>(new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return new QueuedIterator<T, Pair<T, I>, R>(BasicEnumerable.this.iterable.iterator()){
                    private final Map<K, I> innerMap;
                    {
                        this.innerMap = new HashMap();
                        for (Object innerEntity : inner) {
                            Object innerKey = innerKeySelector.call(innerEntity);
                            this.innerMap.put(innerKey, innerEntity);
                        }
                    }

                    @Override
                    protected void addElement(Queue<Pair<T, I>> queue, T t) {
                        Object outerKey = outerKeySelector.call(t);
                        Object innerEntity = this.innerMap.get(outerKey);
                        if (innerEntity != null) {
                            queue.add(new Pair(t, innerEntity));
                        }
                    }

                    @Override
                    protected R toResult(Pair<T, I> e) {
                        return resultSelector.call(e.a, e.b);
                    }
                };
            }
        });
    }

    @Override
    public T last() {
        Iterator<T> iterator = this.iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        T last = null;
        while (iterator.hasNext()) {
            last = iterator.next();
        }
        return last;
    }

    @Override
    public T last(Func<T, Boolean> predicate) {
        T last = null;
        boolean found = false;
        for (T t : this.iterable) {
            if (!predicate.call(t).booleanValue()) continue;
            last = t;
            if (found) continue;
            found = true;
        }
        if (!found) {
            throw new NoSuchElementException();
        }
        return last;
    }

    @Override
    public T lastOrDefault() {
        return (T)this.lastOrDefault((Object)null);
    }

    @Override
    public T lastOrDefault(T defaultValue) {
        Iterator<T> iterator = this.iterable.iterator();
        if (!iterator.hasNext()) {
            return defaultValue;
        }
        T last = null;
        while (iterator.hasNext()) {
            last = iterator.next();
        }
        return last;
    }

    @Override
    public T lastOrDefault(Func<T, Boolean> predicate) {
        return this.lastOrDefault(predicate, null);
    }

    @Override
    public T lastOrDefault(Func<T, Boolean> predicate, T defaultValue) {
        T last = null;
        boolean found = false;
        for (T t : this.iterable) {
            if (!predicate.call(t).booleanValue()) continue;
            last = t;
            if (found) continue;
            found = true;
        }
        if (!found) {
            return defaultValue;
        }
        return last;
    }

    @Override
    public long longCount() {
        long c = 0L;
        Iterator<T> it = this.iterable.iterator();
        while (it.hasNext()) {
            ++c;
            it.next();
        }
        return c;
    }

    @Override
    public long longCount(Func<T, Boolean> predicate) {
        long c = 0L;
        for (T t : this.iterable) {
            if (!predicate.call(t).booleanValue()) continue;
            ++c;
        }
        return c;
    }

    @Override
    public T max() {
        Iterator<T> iterator = this.iterable.iterator();
        T max = iterator.next();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (((Comparable)t).compareTo(max) <= 0) continue;
            max = t;
        }
        return max;
    }

    @Override
    public <R extends Comparable<R>> R max(Func<T, R> selector) {
        Iterator<T> iterator = this.iterable.iterator();
        Comparable max = (Comparable)selector.call(iterator.next());
        while (iterator.hasNext()) {
            Comparable r = (Comparable)selector.call(iterator.next());
            if (r.compareTo(max) <= 0) continue;
            max = r;
        }
        return (R)max;
    }

    @Override
    public T min() {
        Iterator<T> iterator = this.iterable.iterator();
        T min = iterator.next();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (((Comparable)t).compareTo(min) >= 0) continue;
            min = t;
        }
        return min;
    }

    @Override
    public <R extends Comparable<R>> R min(Func<T, R> selector) {
        Iterator<T> iterator = this.iterable.iterator();
        Comparable min = (Comparable)selector.call(iterator.next());
        while (iterator.hasNext()) {
            Comparable r = (Comparable)selector.call(iterator.next());
            if (r.compareTo(min) >= 0) continue;
            min = r;
        }
        return (R)min;
    }

    @Override
    public <R> Enumerable<R> ofType(final Class<R> resultClass) {
        return new BasicEnumerable<T>(new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return new QueuedIterator<T, T, R>(BasicEnumerable.this.iterable.iterator()){

                    @Override
                    protected void addElement(Queue<T> queue, T t) {
                        if (resultClass.isInstance(t)) {
                            queue.add(t);
                        }
                    }

                    @Override
                    protected R toResult(T e) {
                        return resultClass.cast(e);
                    }
                };
            }
        });
    }

    @Override
    public <K> OrderedEnumerable<T> orderBy(Func<T, K> keySelector) {
        return new BasicOrderedEnumerable<T>(this, keySelector, false);
    }

    @Override
    public <K> OrderedEnumerable<T> orderBy(Func<T, K> keySelector, Comparator<K> comparator) {
        return new BasicOrderedEnumerable<T>(this, keySelector, false, comparator);
    }

    @Override
    public <K> OrderedEnumerable<T> orderByDescending(Func<T, K> keySelector) {
        return new BasicOrderedEnumerable<T>(this, keySelector, true);
    }

    @Override
    public <K> OrderedEnumerable<T> orderByDescending(Func<T, K> keySelector, Comparator<K> comparator) {
        return new BasicOrderedEnumerable<T>(this, keySelector, true, comparator);
    }

    public static Enumerable<Integer> range(final int start, final int count) {
        return new BasicEnumerable<Integer>(new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    private int index;
                    private int value;
                    {
                        this.value = start;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < count;
                    }

                    @Override
                    public Integer next() {
                        if (this.index >= count) {
                            throw new NoSuchElementException();
                        }
                        ++this.index;
                        return this.value++;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    public static <R> Enumerable<R> repeat(final R element, final int count) {
        return new BasicEnumerable(new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return new Iterator<R>(){
                    private int index;

                    @Override
                    public boolean hasNext() {
                        return this.index < count;
                    }

                    @Override
                    public R next() {
                        if (this.index >= count) {
                            throw new NoSuchElementException();
                        }
                        ++this.index;
                        return element;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    @Override
    public Enumerable<T> reverse() {
        List<T> list = this.toList();
        Collections.reverse(list);
        return new BasicEnumerable<T>(list);
    }

    @Override
    public <R> Enumerable<R> select(final Func<T, R> selector) {
        return new BasicEnumerable<T>(new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return new Iterator<R>(){
                    private final Iterator<T> iterator;
                    {
                        this.iterator = BasicEnumerable.this.iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public R next() {
                        return selector.call(this.iterator.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    @Override
    public <R> Enumerable<R> select(final Func2<T, Integer, R> selector) {
        return this.select(new Func<T, R>(){
            private int index;

            @Override
            public R call(T arg1) {
                return selector.call(arg1, this.index++);
            }
        });
    }

    @Override
    public <R> Enumerable<R> selectMany(Func<T, Enumerable<R>> selector) {
        return this.selectMany(selector, new Func2<T, R, R>(){

            @Override
            public R call(T arg1, R arg2) {
                return arg2;
            }
        });
    }

    @Override
    public <C, R> Enumerable<R> selectMany(final Func<T, Enumerable<C>> collectionSelector, final Func2<T, C, R> resultSelector) {
        return new BasicEnumerable<T>(new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return new QueuedIterator<T, Pair<T, C>, R>(BasicEnumerable.this.iterable.iterator()){

                    @Override
                    protected void addElement(Queue<Pair<T, C>> queue, T t) {
                        for (Object c : (Enumerable)collectionSelector.call(t)) {
                            queue.add(new Pair(t, c));
                        }
                    }

                    @Override
                    protected R toResult(Pair<T, C> e) {
                        return resultSelector.call(e.a, e.b);
                    }
                };
            }
        });
    }

    @Override
    public <R> Enumerable<R> selectMany(Func2<T, Integer, Enumerable<R>> selector) {
        return this.selectMany(selector, new Func2<T, R, R>(){

            @Override
            public R call(T arg1, R arg2) {
                return arg2;
            }
        });
    }

    @Override
    public <C, R> Enumerable<R> selectMany(final Func2<T, Integer, Enumerable<C>> collectionSelector, Func2<T, C, R> resultSelector) {
        return this.selectMany(new Func<T, Enumerable<C>>(){
            private int index;

            @Override
            public Enumerable<C> call(T arg1) {
                return (Enumerable)collectionSelector.call(arg1, this.index++);
            }
        }, resultSelector);
    }

    @Override
    public Boolean sequenceEqual(Enumerable<T> second) {
        Iterator iterator = second.iterator();
        for (T f : this.iterable) {
            if (!iterator.hasNext()) {
                return false;
            }
            if (this.equals(f, iterator.next())) continue;
            return false;
        }
        if (iterator.hasNext()) {
            return false;
        }
        return true;
    }

    @Override
    public T single() {
        Iterator<T> iterator = this.iterable.iterator();
        T t = iterator.next();
        if (iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        return t;
    }

    @Override
    public T single(Func<T, Boolean> predicate) {
        T single = null;
        boolean found = false;
        for (T t : this.iterable) {
            if (!predicate.call(t).booleanValue()) continue;
            if (found) {
                found = false;
                break;
            }
            single = t;
            found = true;
        }
        if (!found) {
            throw new NoSuchElementException();
        }
        return single;
    }

    @Override
    public T singleOrDefault() {
        return (T)this.singleOrDefault((Object)null);
    }

    @Override
    public T singleOrDefault(T defaultValue) {
        Iterator<T> iterator = this.iterable.iterator();
        if (!iterator.hasNext()) {
            return defaultValue;
        }
        T t = iterator.next();
        if (iterator.hasNext()) {
            return defaultValue;
        }
        return t;
    }

    @Override
    public T singleOrDefault(Func<T, Boolean> predicate) {
        return (T)this.singleOrDefault(predicate, null);
    }

    @Override
    public T singleOrDefault(Func<T, Boolean> predicate, T defaultValue) {
        T single = null;
        boolean found = false;
        for (T t : this.iterable) {
            if (!predicate.call(t).booleanValue()) continue;
            if (found) {
                found = false;
                break;
            }
            single = t;
            found = true;
        }
        if (!found) {
            return defaultValue;
        }
        return single;
    }

    @Override
    public Enumerable<T> skip(final int count) {
        return new BasicEnumerable<T>(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private final Iterator<T> iterator;
                    private boolean skipped;
                    {
                        this.iterator = BasicEnumerable.this.iterable.iterator();
                    }

                    private boolean skip() {
                        if (this.skipped) {
                            return true;
                        }
                        this.skipped = true;
                        for (int i = 0; i < count; ++i) {
                            if (!this.iterator.hasNext()) {
                                return false;
                            }
                            this.iterator.next();
                        }
                        return true;
                    }

                    @Override
                    public boolean hasNext() {
                        if (!this.skip()) {
                            return false;
                        }
                        return this.iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        if (!this.skip()) {
                            throw new NoSuchElementException();
                        }
                        return this.iterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    @Override
    public Enumerable<T> skipWhile(final Func<T, Boolean> predicate) {
        return new BasicEnumerable<T>(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new QueuedIterator<T, T, T>(BasicEnumerable.this.iterable.iterator()){
                    private boolean skipped;

                    @Override
                    protected void addElement(Queue<T> queue, T t) {
                        if (!this.skipped) {
                            if (((Boolean)predicate.call(t)).booleanValue()) {
                                return;
                            }
                            this.skipped = true;
                        }
                        queue.add(t);
                    }

                    @Override
                    protected T toResult(T e) {
                        return e;
                    }
                };
            }
        });
    }

    @Override
    public Enumerable<T> skipWhile(final Func2<T, Integer, Boolean> predicate) {
        return this.skipWhile(new Func<T, Boolean>(){
            private int index;

            @Override
            public Boolean call(T arg1) {
                return (Boolean)predicate.call(arg1, this.index++);
            }
        });
    }

    @Override
    public int sum() {
        int sum = 0;
        for (T t : this.iterable) {
            sum += ((Integer)t).intValue();
        }
        return sum;
    }

    @Override
    public long sumLong() {
        long sum = 0L;
        for (T t : this.iterable) {
            sum += ((Long)t).longValue();
        }
        return sum;
    }

    @Override
    public float sumFloat() {
        float sum = 0.0f;
        for (T t : this.iterable) {
            sum += ((Float)t).floatValue();
        }
        return sum;
    }

    @Override
    public double sumDouble() {
        double sum = 0.0;
        for (T t : this.iterable) {
            sum += ((Double)t).doubleValue();
        }
        return sum;
    }

    @Override
    public int sum(Func<T, Integer> selector) {
        int sum = 0;
        for (T t : this.iterable) {
            sum += selector.call(t).intValue();
        }
        return sum;
    }

    @Override
    public long sumLong(Func<T, Long> selector) {
        long sum = 0L;
        for (T t : this.iterable) {
            sum += selector.call(t).longValue();
        }
        return sum;
    }

    @Override
    public float sumFloat(Func<T, Float> selector) {
        float sum = 0.0f;
        for (T t : this.iterable) {
            sum += selector.call(t).floatValue();
        }
        return sum;
    }

    @Override
    public double sumDouble(Func<T, Double> selector) {
        double sum = 0.0;
        for (T t : this.iterable) {
            sum += selector.call(t).doubleValue();
        }
        return sum;
    }

    @Override
    public Enumerable<T> take(final int count) {
        return new BasicEnumerable<T>(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private final Iterator<T> iterator;
                    private int index;
                    {
                        this.iterator = BasicEnumerable.this.iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.index >= count) {
                            return false;
                        }
                        return this.iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        if (this.index >= count) {
                            throw new NoSuchElementException();
                        }
                        ++this.index;
                        return this.iterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    @Override
    public Enumerable<T> takeWhile(final Func<T, Boolean> predicate) {
        return new BasicEnumerable<T>(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new QueuedIterator<T, T, T>(BasicEnumerable.this.iterable.iterator()){
                    private boolean done;

                    @Override
                    protected void addElement(Queue<T> queue, T t) {
                        if (this.done) {
                            return;
                        }
                        if (!((Boolean)predicate.call(t)).booleanValue()) {
                            this.done = true;
                            return;
                        }
                        queue.add(t);
                    }

                    @Override
                    protected T toResult(T e) {
                        return e;
                    }
                };
            }
        });
    }

    @Override
    public Enumerable<T> takeWhile(final Func2<T, Integer, Boolean> predicate) {
        return this.takeWhile(new Func<T, Boolean>(){
            private int index;

            @Override
            public Boolean call(T arg1) {
                return (Boolean)predicate.call(arg1, this.index++);
            }
        });
    }

    @Override
    public Object[] toArray() {
        return this.toList().toArray();
    }

    @Override
    public <R> R[] toArray(Class<R> resultClass) {
        List<Object> list = this.toList();
        Object[] array = (Object[])Array.newInstance(resultClass, list.size());
        return list.toArray(array);
    }

    @Override
    public List<T> toList() {
        ArrayList<T> list = new ArrayList<T>();
        for (T e : this.iterable) {
            list.add(e);
        }
        return list;
    }

    @Override
    public EnumerableList<T> toEnumerableList() {
        return new BasicEnumerableList<T>(this.toList());
    }

    @Override
    public <K> Map<K, List<T>> toListMap(Func<T, K> keySelector) {
        return this.toListMap(keySelector, this.getPassThroughFunc());
    }

    @Override
    public <K, E> Map<K, List<E>> toListMap(Func<T, K> keySelector, Func<T, E> elementSelector) {
        LinkedHashMap<K, ArrayList<E>> map = new LinkedHashMap<K, ArrayList<E>>();
        for (T t : this.iterable) {
            K k = keySelector.call(t);
            ArrayList<E> list = (ArrayList<E>)map.get(k);
            if (list == null) {
                list = new ArrayList<E>();
                map.put(k, list);
            }
            list.add(elementSelector.call(t));
        }
        return map;
    }

    @Override
    public <K> Lookup<K, T> toLookup(Func<T, K> keySelector) {
        return this.toLookup(keySelector, this.getPassThroughFunc());
    }

    @Override
    public <K, E> Lookup<K, E> toLookup(Func<T, K> keySelector, Func<T, E> elementSelector) {
        return new BasicLookup<K, E>(this.toListMap(keySelector, elementSelector));
    }

    @Override
    public <K> Map<K, T> toMap(Func<T, K> keySelector) {
        return this.toMap(keySelector, this.getPassThroughFunc());
    }

    @Override
    public <K, E> Map<K, E> toMap(Func<T, K> keySelector, Func<T, E> elementSelector) {
        LinkedHashMap<K, E> map = new LinkedHashMap<K, E>();
        for (T t : this.iterable) {
            K k = keySelector.call(t);
            if (map.containsKey(k)) {
                throw new IllegalArgumentException();
            }
            map.put(k, elementSelector.call(t));
        }
        return map;
    }

    @Override
    public <K> Dictionary<K, T> toDictionary(Func<T, K> keySelector) {
        return this.toDictionary(keySelector, this.getPassThroughFunc());
    }

    @Override
    public <K, E> Dictionary<K, E> toDictionary(Func<T, K> keySelector, Func<T, E> elementSelector) {
        return new BasicDictionary<K, E>(this.toMap(keySelector, elementSelector));
    }

    @Override
    public Enumerable<T> union(final Enumerable<T> second) {
        return new BasicEnumerable<T>(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new QueuedIterator<T, T, T>(new ConcatenatedIterator(BasicEnumerable.this.iterable.iterator(), second.iterator())){
                    private final Set<T> set;
                    {
                        this.set = new HashSet();
                    }

                    @Override
                    protected void addElement(Queue<T> queue, T t) {
                        if (!this.set.contains(t)) {
                            queue.add(t);
                            this.set.add(t);
                        }
                    }

                    @Override
                    protected T toResult(T e) {
                        return e;
                    }
                };
            }
        });
    }

    @Override
    public Enumerable<T> where(final Func<T, Boolean> predicate) {
        return new BasicEnumerable<T>(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new QueuedIterator<T, T, T>(BasicEnumerable.this.iterable.iterator()){

                    @Override
                    protected void addElement(Queue<T> queue, T t) {
                        if (((Boolean)predicate.call(t)).booleanValue()) {
                            queue.add(t);
                        }
                    }

                    @Override
                    protected T toResult(T e) {
                        return e;
                    }
                };
            }
        });
    }

    @Override
    public Enumerable<T> where(final Func2<T, Integer, Boolean> predicate) {
        return this.where(new Func<T, Boolean>(){
            private int index;

            @Override
            public Boolean call(T arg1) {
                return (Boolean)predicate.call(arg1, this.index++);
            }
        });
    }

    private Func<T, T> getPassThroughFunc() {
        return new Func<T, T>(){

            @Override
            public T call(T arg1) {
                return arg1;
            }
        };
    }
}

