/*
 * Decompiled with CFR 0.152.
 */
package sharin.sql.generator;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityInfo {
    private final Class<?> entityClass;
    private final String tableName;
    private final Map<String, String> columnNameMap;
    private final String idColumnName;
    private final String[] propertyNames;

    public EntityInfo(Class<?> entityClass) {
        this(entityClass, null, null, null);
    }

    public EntityInfo(Class<?> entityClass, String tableName, Map<String, String> columnNameMap, String idColumnName) {
        this.entityClass = entityClass;
        if (tableName == null || tableName.length() == 0) {
            Table table = entityClass.getAnnotation(Table.class);
            tableName = table != null ? table.name() : entityClass.getSimpleName();
        }
        this.tableName = tableName;
        columnNameMap = columnNameMap == null ? new HashMap<String, String>() : new HashMap<String, String>(columnNameMap);
        for (Class<?> clazz = entityClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                Id id;
                if ((field.getModifiers() & 0x88) != 0) continue;
                String fieldName = field.getName();
                Column column = field.getAnnotation(Column.class);
                if (!columnNameMap.containsKey(fieldName)) {
                    if (column != null) {
                        columnNameMap.put(fieldName, column.name());
                    } else {
                        columnNameMap.put(fieldName, fieldName);
                    }
                }
                if (idColumnName != null || (id = field.getAnnotation(Id.class)) == null) continue;
                idColumnName = column == null ? fieldName : column.name();
            }
        }
        this.columnNameMap = columnNameMap;
        if (idColumnName == null || idColumnName.length() == 0) {
            idColumnName = "id";
        }
        this.idColumnName = idColumnName;
        this.propertyNames = columnNameMap.keySet().toArray(new String[columnNameMap.size()]);
        Arrays.sort(this.propertyNames);
    }

    public boolean hasColumnName(String propertyName) {
        return this.columnNameMap.containsKey(propertyName);
    }

    public String getColumnName(String propertyName) {
        return this.columnNameMap.get(propertyName);
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getIdColumnName() {
        return this.idColumnName;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }
}

