/*
 * Decompiled with CFR 0.152.
 */
package sharin.sql.formatter;

import java.util.ArrayList;
import java.util.List;

class BasicResultBuffer {
    private final List<StringBuilder> builderList = new ArrayList<StringBuilder>();
    private final StringBuilder result = new StringBuilder();

    public BasicResultBuffer() {
        this.builderList.add(null);
    }

    public void append(String s) {
        StringBuilder builder = null;
        int size = this.builderList.size();
        if (size >= 1) {
            builder = this.builderList.get(size - 1);
        }
        if (builder == null) {
            builder = this.result;
        }
        this.append(builder, s);
    }

    private void append(StringBuilder builder, String s) {
        if (s == null || s.length() == 0) {
            return;
        }
        if (builder.length() > 0) {
            builder.append(' ');
        }
        builder.append(s);
    }

    public void flush() {
        for (int i = 0; i < this.builderList.size(); ++i) {
            StringBuilder builder = this.builderList.get(i);
            if (builder == null) continue;
            this.append(this.result, builder.toString());
            this.builderList.set(i, null);
        }
    }

    public void begin() {
        this.builderList.add(new StringBuilder());
    }

    public void prepend(String s) {
        int size = this.builderList.size();
        if (size >= 2 && this.builderList.get(size - 2) == null) {
            this.append(s);
        }
    }

    public void end() {
        int size = this.builderList.size();
        if (size >= 1) {
            this.builderList.remove(size - 1);
        }
    }

    public String getResult() {
        return this.result.toString();
    }
}

