/*
 * Decompiled with CFR 0.152.
 */
package sharin.csv.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sharin.csv.parser.BasicCsvAutomaton;
import sharin.csv.parser.CsvHandler;
import sharin.util.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BasicCsvIterator
implements Iterator<String[]>,
CsvHandler {
    private static final int START = 0;
    private static final int END_RECORD = 1;
    private static final int END_DOCUMENT = 2;
    private final Reader reader;
    private final BasicCsvAutomaton automaton;
    private List<String> valueList;
    private StringBuilder valueBuilder;
    private int state;
    private String[] record;

    public BasicCsvIterator(Reader reader, char separator) {
        this.reader = reader;
        this.automaton = new BasicCsvAutomaton(this, separator);
        this.state = 0;
    }

    @Override
    public boolean hasNext() {
        this.record = this.nextRecord();
        return this.record != null;
    }

    @Override
    public String[] next() {
        return this.record;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private String[] nextRecord() {
        if (this.state == 2) {
            return null;
        }
        this.valueList = null;
        this.valueBuilder = null;
        this.state = 0;
        do {
            this.automaton.put(IoUtils.read(this.reader));
        } while (this.state == 0);
        if (this.valueList == null) {
            return null;
        }
        return this.valueList.toArray(new String[this.valueList.size()]);
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startRecord() {
        this.valueList = new ArrayList<String>();
    }

    @Override
    public void startValue() {
        this.valueBuilder = new StringBuilder();
    }

    @Override
    public void character(char ch) {
        this.valueBuilder.append(ch);
    }

    @Override
    public void endValue() {
        this.valueList.add(this.valueBuilder.toString());
        this.valueBuilder = null;
    }

    @Override
    public void endRecord() {
        this.state = 1;
    }

    @Override
    public void endDocument() {
        this.state = 2;
    }
}

