.\" $Xorg: xprop.man,v 1.4 2001/02/09 02:05:56 xorgcvs Exp $
.\" Copyright 1988, 1998  The Open Group
.\" Copyright \(co 2000  The XFree86 Project, Inc.
.\" 
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\"
.\" $XFree86: xc/programs/xprop/xprop.man,v 1.8 2001/01/27 18:21:21 dawes Exp $
.\"
.TH XPROP 1 __vendorversion__
.SH NAME
xprop - property displayer for X
.SH SYNOPSIS
.B "xprop"
[-help] [-grammar] [-id \fIid\fP] [-root] [-name \fIname\fP]
[-frame]
[-font \fIfont\fP]
[-display \fIdisplay\fP]
[-len \fIn\fP] [-notype] [-fs \fIfile\fP]
[-remove \fIproperty-name\fP]
[-set \fIproperty-name\fP \fIvalue\fP]
[-spy]
[-f \fIatom\fP \fIformat\fP [\fIdformat\fP]]*
[\fIformat\fP [\fIdformat\fP] \fIatom\fP]*
.SH SUMMARY
.PP
The
.I xprop
utility is for displaying window and font properties in an X server.
One window or font is selected using the command
line arguments or possibly in the case of a window, by clicking on the desired
window.  A list of properties is then given, possibly with formatting
information.
.SH OPTIONS
.PP
.TP 8
.B "-help"
Print out a summary of command line options.
.PP
.TP 8
.B "-grammar"
Print out a detailed grammar for all command line options.
.PP
.TP 8
.B "-id \fIid\fP"
This argument allows the user to select window \fIid\fP on the
command line rather than using the pointer to select the target window.
This is very useful in debugging X applications where the target
window is not mapped to the screen or where the use of the pointer might
be impossible or interfere with the application.
.PP
.TP 8
.B "-name \fIname\fP"
This argument allows the user to specify that the window named \fIname\fP
is the target window on the command line rather than using the pointer to
select the target window.
.PP
.TP 8
.B "-font \fIfont\fP"
This argument allows the user to specify that the properties of font
\fIfont\fP should be displayed.
.PP
.TP 8
.B "-root"
This argument specifies that X's root window is the target window.
This is useful in situations where the root window is completely
obscured.
.PP
.TP 8
.B "-display \fIdisplay\fP"
This argument allows you to specify the server to connect to;
see \fIX(__miscmansuffix__)\fP.
.PP
.TP 8
.B "-len \fIn\fP"
Specifies that at most \fIn\fP bytes of any property should be read or
displayed.
.PP
.TP 8
.B "-notype"
Specifies that the type of each property should not be displayed.
.PP
.TP 8
.B "-fs \fIfile\fP"
Specifies that file \fIfile\fP should be used as a source of more formats
for properties.
.PP
.TP 8
.B "-frame"
Specifies that when selecting a window by hand (i.e. if none of \fB-name\fP,
\fB-root\fP, or \fB-id\fP are given), look at the window manager frame (if
any) instead of looking for the client window.
.PP
.TP 8
.B "-remove \fIproperty-name\fP"
Specifies the name of a property to be removed from the indicated window.
.PP
.TP 8
.B "-set \fIproperty-name\fP \fIvalue\fP"
Specifies the name of a property and a property value, to be set on the
indicated window.
.PP
.TP 8
.B "-spy"
Examine window properties forever, looking for property change events.
.PP
.TP 8
.B "-f \fIname\fP \fIformat\fP [\fIdformat\fP]"
Specifies that the \fIformat\fP for \fIname\fP should be \fIformat\fP and that
the \fIdformat\fP for \fIname\fP should be \fIdformat\fP.  If \fIdformat\fP
is missing, " = $0+\\n" is assumed.
.SH DESCRIPTION
.PP
For each of these properties, its value on the selected window
or font is printed using the supplied formatting information if any.  If no
formatting information is supplied, internal defaults are used.  If a property
is not defined on the selected window or font, "not defined" is printed as the
value for that property.  If no property list is given, all the properties
possessed by the selected window or font are printed.
.PP
A window may be selected in one of four ways.  First, if the desired window
is the root window, the -root argument may be used.
If the desired window is not the root window, it may be selected
in two ways on the command line, either by id number such as might be obtained
from \fIxwininfo\fP, or by name if the window possesses a name.  The -id
argument selects a window by id number in either decimal or hex (must start
with 0x) while the -name argument selects a window by name.
.PP
The last way to select a window does not involve the command line at all.
If none of -font, -id, -name, and -root are specified, a crosshairs cursor
is displayed and the user is allowed to choose any visible window by pressing
any pointer button in the desired window.  If it is desired to display properties
of a font as opposed to a window, the -font argument must be used.
.PP
Other than the above four arguments and the -help argument for obtaining help,
and the -grammar argument for listing the full grammar for the command line,
all the other command line arguments are used in specifying both the format
of the properties to be displayed and how to display them.  The -len \fIn\fP 
argument specifies that at most \fIn\fP bytes of any given property will be
read and displayed.  This is useful for example when displaying the cut buffer
on the root window which could run to several pages if displayed in full.
.PP
Normally each property name is displayed by printing first the property
name then its type (if it has one) in parentheses followed by its value.
The -notype argument specifies that property types should not be
displayed.  The -fs argument is used to specify a file containing a list of
formats for properties while the -f argument is used to specify the format
for one property.
.PP
The formatting information for a property actually consists of two parts,
a \fIformat\fP and a \fIdformat\fP.  The \fIformat\fP specifies the actual
formatting of the property (i.e., is it made up of words, bytes, or longs?,
etc.) while the \fIdformat\fP specifies how the property should be displayed.
.PP
The following paragraphs describe how to construct \fIformat\fPs and
\fIdformat\fPs.  However, for the vast majority of users and uses, this should
not be necessary as the built in defaults contain the \fIformat\fPs and
\fIdformat\fPs necessary to display all the standard properties.  It should
only be necessary to specify \fIformat\fPs and \fIdformat\fPs
if a new property is being dealt with or the user dislikes the standard display
format.  New users especially are encouraged to skip this part.
.PP
A \fIformat\fP consists of one of 0, 8, 16, or 32 followed by a sequence of one
or more format characters.  The 0, 8, 16, or 32 specifies how many bits per
field there are in the property.  Zero is a special case meaning use the
field size information associated with the property itself.  (This is only
needed for special cases like type INTEGER which is actually three different
types depending on the size of the fields of the property.)
.PP
A value of 8 means
that the property is a sequence of bytes while a value of 16 would mean that
the property is a sequence of words.  The difference between these two lies in
the fact that the sequence of words will be byte swapped while the sequence of
bytes will not be when read by a machine of the opposite byte order of the
machine that originally wrote the property.  For more information on how
properties are formatted and stored, consult the Xlib manual.
.PP
Once the size of the fields has been specified, it is necessary to specify
the type of each field (i.e., is it an integer, a string, an atom, or what?)
This is done using one format character per field.  If there are more fields
in the property than format characters supplied, the last character will be
repeated as many times as necessary for the extra fields.  The format
characters and their meaning are as follows:
.TP
a
The field holds an atom number.  A field of this type should be of size 32.
.TP
b
The field is an boolean.  A 0 means false while anything else means true.
.TP
c
The field is an unsigned number, a cardinal.
.TP
i
The field is a signed integer.
.TP
m
The field is a set of bit flags, 1 meaning on.
.TP
s
This field and the next ones until either a 0 or the end of the property
represent a sequence of bytes.  This format character is only usable with
a field size of 8 and is most often used to represent a string.
.TP
t
This field and the next ones until either a 0 or the end of the property
represent an internationalized text string. This format character is only
usable with a field size of 8. The string is assumed to be in an ICCCM
compliant encoding and is converted to the current locale encoding before
being output.
.TP
x
The field is a hex number (like 'c' but displayed in hex - most useful
for displaying window ids and the like)
.PP
An example \fIformat\fP is 32ica which is the format for a property of three
fields of 32 bits each, the first holding a signed integer, the second an
unsigned integer, and the third an atom.
.PP
The format of a \fIdformat\fP unlike that of a \fIformat\fP is not so rigid.
The only limitations on a \fIdformat\fP is that one may not start with a letter
or a dash.  This is so that it can be distinguished from a property name or
an argument.  A \fIdformat\fP is a text string containing special characters
instructing that various fields be printed at various points in a manner similar
to the formatting string used by printf.  For example, the \fIdformat\fP
" is ( $0, $1 \\)\\n" would render the POINT 3, -4 which has a \fIformat\fP of
32ii as " is ( 3, -4 )\\n".
.PP
Any character other than a $, ?, \\, or a ( in a \fIdformat\fP prints as
itself.  To print out one of $, ?, \\, or ( precede it by a \\.  For example,
to print out a $, use \\$.  Several special backslash sequences are provided
as shortcuts.  \\n will cause a newline to be displayed while \\t will
cause a tab to be displayed.  \\\fIo\fP where \fIo\fP is an octal number
will display character number \fIo\fP.
.PP
A $ followed by a number \fIn\fP causes field number \fIn\fP to be
displayed.  The format of the displayed field depends on the formatting
character used to describe it in the corresponding \fIformat\fP.  I.e., if
a cardinal is described by 'c' it will print in decimal while if it is
described by a 'x' it is displayed in hex.
.PP
If the field is not present in
the property (this is possible with some properties), <field not available>
is displayed instead.  $\fIn\fP+ will display field number \fIn\fP then a
comma then field number \fIn\fP+1 then another comma then ... until the last
field defined.  If field \fIn\fP is not defined, nothing is displayed.
This is useful for a property that is a list of values.
.PP
A ? is used to start a conditional expression, a kind of if-then statement.
?\fIexp\fP(\fItext\fP) will display \fItext\fP if and only if \fIexp\fP evaluates to
non-zero.  This is useful for two things.  First, it allows fields to be
displayed if and only if a flag is set.  
And second, it allows a value such as a state
number to be displayed as a name rather than as just a number.  The syntax of
\fIexp\fP is as follows:
.TP
\fIexp\fP
::= \fIterm\fP | \fIterm\fP=\fIexp\fP | !\fIexp\fP
.TP
\fIterm\fP
::= \fIn\fP | $\fIn\fP | m\fIn\fP
.PP
The ! operator is a logical ``not'', changing 0 to 1 and any non-zero value to 0.
= is an equality operator.  Note that internally all expressions are evaluated
as 32 bit numbers so -1 is not equal to 65535.  = returns 1 if the two values
are equal and 0 if not.
\fIn\fP represents the constant value \fIn\fP while $\fIn\fP represents the
value of field number \fIn\fP.
m\fIn\fP is 1 if flag number \fIn\fP in the first field having format
character 'm' in the corresponding \fIformat\fP is 1, 0 otherwise.
.PP
Examples: ?m3(count: $3\\n) displays field 3 with a label of count if and only if flag
number 3 (count starts at 0!) is on.  ?$2=0(True)?!$2=0(False) displays the
inverted value of field 2 as a boolean.
.PP
In order to display a property, \fIxprop\fP needs both a \fIformat\fP and a
\fIdformat\fP.  Before \fIxprop\fP uses its default values of a \fIformat\fP
of 32x and a \fIdformat\fP of " = { $0+ }\\n", it searches several places
in an attempt to find more specific formats.
First, a search is made using the name of the property.  If this
fails, a search is made using the type of the property.  This allows type
STRING to be defined with one set of formats while allowing property WM_NAME
which is of type STRING to be defined with a different format.  In this way,
the display formats for a given type can be overridden for specific properties.
.PP
The locations searched are in order: the format if any specified with the
property name (as in 8x WM_NAME), the formats defined by -f options in last to
first order, the contents of the file specified by the -fs option if any,
the contents of the file specified by the environmental variable XPROPFORMATS
if any, and finally \fIxprop\fP's built in file of formats.
.PP
The format of the files referred to by the -fs argument and the XPROPFORMATS
variable is one or more lines of the following form:
.PP
\fIname\fP \fIformat\fP [\fIdformat\fP]
.PP
Where \fIname\fP is either the name of a property or the name of a type,
\fIformat\fP is the \fIformat\fP to be used with \fIname\fP and \fIdformat\fP
is the \fIdformat\fP to be used with \fIname\fP.  If \fIdformat\fP is not
present, " = $0+\\n" is assumed.
.SH EXAMPLES
.PP
To display the name of the root window: \fIxprop\fP -root WM_NAME
.PP
To display the window manager hints for the clock: \fIxprop\fP -name xclock
WM_HINTS
.PP
To display the start of the cut buffer: \fIxprop\fP -root -len 100 CUT_BUFFER0
.PP
To display the point size of the fixed font: \fIxprop\fP -font fixed POINT_SIZE
.PP
To display all the properties of window # 0x200007: \fIxprop\fP -id 0x200007
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
To get default display.
.TP 8
.B XPROPFORMATS
Specifies the name of a file from which additional formats are to be obtained.
.PP
.SH SEE ALSO
X(__miscmansuffix__), xwininfo(1)
.SH AUTHOR
Mark Lillibridge, MIT Project Athena
