/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JButton;
import xdman.ui.res.ColorResource;

public class CustomButton
extends JButton {
    private static final long serialVersionUID = 6378409011977437191L;
    private Color rolloverBackground;
    private Color rolloverForeground;
    private Color pressedBackground;
    private Color pressedForeground;

    public CustomButton() {
        this.init();
    }

    public CustomButton(Icon icon) {
        super(icon);
        this.init();
    }

    public CustomButton(String text) {
        super(text);
        this.init();
    }

    private void init() {
        this.rolloverBackground = ColorResource.getSelectionColor();
        this.rolloverForeground = Color.WHITE;
        this.pressedBackground = ColorResource.getDarkBgColor();
        this.pressedForeground = Color.WHITE;
    }

    @Override
    public Color getForeground() {
        if (this.model.isRollover()) {
            return this.rolloverForeground;
        }
        if (this.model.isPressed()) {
            return this.pressedForeground;
        }
        return super.getForeground();
    }

    @Override
    public Color getBackground() {
        if (this.model.isPressed()) {
            return this.pressedBackground;
        }
        if (this.model.isRollover()) {
            return this.rolloverBackground;
        }
        return super.getBackground();
    }

    public static final long getSerialversionuid() {
        return 6378409011977437191L;
    }

    public final Color getRolloverBackground() {
        return this.rolloverBackground;
    }

    public final void setRolloverBackground(Color rolloverBackground) {
        this.rolloverBackground = rolloverBackground;
    }

    public final Color getRolloverForeground() {
        return this.rolloverForeground;
    }

    public final void setRolloverForeground(Color rolloverForeground) {
        this.rolloverForeground = rolloverForeground;
    }

    public final Color getPressedBackground() {
        return this.pressedBackground;
    }

    public final void setPressedBackground(Color pressedBackground) {
        this.pressedBackground = pressedBackground;
    }

    public final Color getPressedForeground() {
        return this.pressedForeground;
    }

    public final void setPressedForeground(Color pressedForeground) {
        this.pressedForeground = pressedForeground;
    }
}

