/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import xdman.mediaconversion.ConversionItem;
import xdman.mediaconversion.FFmpeg;
import xdman.mediaconversion.MediaConversionListener;
import xdman.mediaconversion.MediaFormat;
import xdman.mediaconversion.MediaFormats;
import xdman.mediaconversion.MediaInfoExtractor;
import xdman.ui.components.ConversionItemRender;
import xdman.ui.components.CustomButton;
import xdman.ui.components.DarkScrollBar;
import xdman.ui.components.MediaFormatWnd;
import xdman.ui.components.TitlePanel;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.Logger;
import xdman.util.XDMUtils;

public class ConversionWindow
extends JFrame
implements ActionListener,
Runnable,
MediaConversionListener {
    DefaultListModel<ConversionItem> model;
    JList<ConversionItem> list;
    float scaleFactor = 1.0f;
    JButton btnOutFormat;
    JTextField txtOutFolder;
    JProgressBar prgConvert;
    JLabel lblConvertFormat;
    JLabel lblOutputFolder;
    JLabel lblPrg;
    JButton browse;
    JButton convert;
    JButton stop;
    JLabel lineLbl2;
    int mode = 0;
    ArrayList<String> filesToLoad;
    boolean stopflag;
    Thread t;
    MediaInfoExtractor extractor;
    FFmpeg ffmpeg;
    ConversionItemRender renderer;
    JPopupMenu pop;
    MediaFormatWnd fmtWnd;
    JCheckBox chkHwAccel;
    long lastTime = 0L;

    public ConversionWindow(ArrayList<String> files) {
        this.initUI();
        String str = String.format(StringResource.get("LBL_LOADING"), "");
        this.showProgressPanel();
        this.lblPrg.setText(str);
        this.filesToLoad = files;
        this.mode = 0;
    }

    public void load() {
        this.t = new Thread(this);
        this.t.start();
    }

    private int getScaledValue(int input) {
        return (int)((float)input * this.scaleFactor);
    }

    private void stop() {
        this.stopflag = true;
        if (this.mode == 0 && this.extractor != null) {
            this.extractor.stop();
        }
        if (this.mode == 1 && this.ffmpeg != null) {
            System.out.println("stopping ffmpeg");
            this.ffmpeg.stop();
        }
    }

    private void initUI() {
        this.model = new DefaultListModel();
        this.list = new JList<ConversionItem>(this.model);
        this.renderer = new ConversionItemRender();
        this.list.setCellRenderer(this.renderer);
        this.list.setBackground(ColorResource.getDarkestBgColor());
        this.list.setBorder(null);
        this.setUndecorated(true);
        try {
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
                this.setOpacity(0.85f);
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        this.setTitle(StringResource.get("MENU_MEDIA_CONVERTER"));
        this.setIconImage(ImageResource.get("icon.png").getImage());
        this.setSize(this.getScaledValue(600), this.getScaledValue(420));
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(ColorResource.getDarkestBgColor());
        TitlePanel titlePanel = new TitlePanel(null, this);
        titlePanel.setOpaque(false);
        titlePanel.setBounds(0, 0, this.getWidth(), this.getScaledValue(50));
        CustomButton closeBtn = new CustomButton();
        closeBtn.setBounds(this.getWidth() - this.getScaledValue(35), this.getScaledValue(5), this.getScaledValue(30), this.getScaledValue(30));
        closeBtn.setBackground(ColorResource.getDarkestBgColor());
        closeBtn.setBorderPainted(false);
        closeBtn.setFocusPainted(false);
        closeBtn.setName("CLOSE");
        closeBtn.setIcon(ImageResource.get("close_btn.png"));
        closeBtn.addActionListener(this);
        titlePanel.add(closeBtn);
        JLabel titleLbl = new JLabel(StringResource.get("MENU_MEDIA_CONVERTER"));
        titleLbl.setFont(FontResource.getBiggerFont());
        titleLbl.setForeground(ColorResource.getSelectionColor());
        titleLbl.setBounds(this.getScaledValue(25), this.getScaledValue(15), this.getScaledValue(200), this.getScaledValue(30));
        titlePanel.add(titleLbl);
        JLabel lineLbl = new JLabel();
        lineLbl.setBackground(ColorResource.getSelectionColor());
        lineLbl.setBounds(0, this.getScaledValue(55), this.getWidth(), 1);
        lineLbl.setOpaque(true);
        this.add(lineLbl);
        this.add(titlePanel);
        int y = this.getScaledValue(56);
        int h = this.getScaledValue(250);
        JScrollPane jsp = new JScrollPane(this.list);
        jsp.setBounds(0, y, this.getWidth(), h);
        jsp.setBorder(null);
        DarkScrollBar scrollBar2 = new DarkScrollBar(1);
        jsp.setVerticalScrollBar(scrollBar2);
        jsp.setHorizontalScrollBarPolicy(31);
        jsp.setAutoscrolls(true);
        this.lineLbl2 = new JLabel();
        this.lineLbl2.setBackground(ColorResource.getDarkBgColor());
        this.lineLbl2.setBounds(0, y += h, this.getWidth(), 1);
        this.lineLbl2.setOpaque(true);
        this.add(this.lineLbl2);
        int y2 = y += this.getScaledValue(15);
        h = this.getScaledValue(30);
        this.lblConvertFormat = new JLabel(StringResource.get("LBL_CONVERT_TO"));
        this.lblConvertFormat.setFont(FontResource.getNormalFont());
        this.lblConvertFormat.setHorizontalAlignment(4);
        this.lblConvertFormat.setBounds(0, y, this.getScaledValue(100), h);
        this.add(this.lblConvertFormat);
        MediaFormat[] fmts = MediaFormats.getSupportedFormats();
        MediaFormat[] formats = new MediaFormat[fmts.length - 1];
        int i = 1;
        int j = 0;
        while (i < fmts.length) {
            formats[j] = fmts[i];
            ++i;
            ++j;
        }
        this.fmtWnd = new MediaFormatWnd();
        this.btnOutFormat = new CustomButton(this.fmtWnd.getFormat().getDescription());
        this.btnOutFormat.setHorizontalAlignment(2);
        this.btnOutFormat.setBackground(ColorResource.getDarkBtnColor());
        this.btnOutFormat.setBorderPainted(false);
        this.btnOutFormat.setFocusPainted(false);
        this.btnOutFormat.setForeground(Color.WHITE);
        this.btnOutFormat.setFont(FontResource.getNormalFont());
        this.btnOutFormat.addActionListener(this);
        this.btnOutFormat.setName("FORMAT_SELECT");
        this.btnOutFormat.setMargin(new Insets(0, 0, 0, 0));
        this.btnOutFormat.setOpaque(true);
        this.btnOutFormat.setBounds(this.getScaledValue(110), y + this.getScaledValue(5), this.getScaledValue(335), this.getScaledValue(20));
        this.btnOutFormat.setName("FORMAT_SELECT");
        this.add(this.btnOutFormat);
        this.lblOutputFolder = new JLabel(StringResource.get("LBL_OUTPUT_FOLDER"));
        this.lblOutputFolder.setHorizontalAlignment(4);
        this.lblOutputFolder.setFont(FontResource.getNormalFont());
        this.lblOutputFolder.setBounds(0, y += h, this.getScaledValue(100), h);
        this.add(this.lblOutputFolder);
        this.txtOutFolder = new JTextField();
        this.txtOutFolder.setText(this.getVideoFolder());
        this.txtOutFolder.setBounds(this.getScaledValue(110), y + this.getScaledValue(5), this.getScaledValue(280), this.getScaledValue(20));
        this.add(this.txtOutFolder);
        this.browse = new CustomButton("...");
        this.browse.setBackground(ColorResource.getDarkBtnColor());
        this.browse.setBorderPainted(false);
        this.browse.setFocusPainted(false);
        this.browse.setForeground(Color.WHITE);
        this.browse.setFont(FontResource.getNormalFont());
        this.browse.addActionListener(this);
        this.browse.setName("BROWSE_FOLDER");
        this.browse.setMargin(new Insets(0, 0, 0, 0));
        this.browse.setBounds(this.getScaledValue(110) + this.getScaledValue(280) + this.getScaledValue(5), y + this.getScaledValue(5), this.getScaledValue(50), this.getScaledValue(20));
        this.add(this.browse);
        this.convert = new CustomButton(StringResource.get("OPT_CONVERT"));
        this.convert.setBackground(ColorResource.getDarkBtnColor());
        this.convert.setBorderPainted(false);
        this.convert.setFocusPainted(false);
        this.convert.setForeground(Color.WHITE);
        this.convert.setFont(FontResource.getNormalFont());
        this.convert.setName("CONVERT");
        this.convert.setMargin(new Insets(0, 0, 0, 0));
        this.convert.setBounds(this.getScaledValue(110) + this.getScaledValue(290) + this.getScaledValue(60), y2 + this.getScaledValue(10), this.getScaledValue(120), this.getScaledValue(40));
        this.convert.addActionListener(this);
        this.add(this.convert);
        this.add(jsp);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConversionWindow.this.onClosed();
            }
        });
        y = y2 - this.getScaledValue(5);
        h = this.getScaledValue(30);
        this.lblPrg = new JLabel(StringResource.get("TITLE_CONVERT"));
        this.lblPrg.setBounds(this.getScaledValue(10), y + this.getScaledValue(15), this.getScaledValue(400), h);
        this.add(this.lblPrg);
        this.prgConvert = new JProgressBar();
        this.prgConvert.setBounds(this.getScaledValue(10), (y += h) + this.getScaledValue(15), this.getScaledValue(580), 2);
        this.prgConvert.setBorder(null);
        this.prgConvert.setValue(30);
        this.add(this.prgConvert);
        y += 10;
        h = this.getScaledValue(25);
        this.stop = new CustomButton(StringResource.get("BTN_STOP_PROCESSING"));
        this.stop.setBackground(ColorResource.getDarkBtnColor());
        this.stop.setBorderPainted(false);
        this.stop.setFocusPainted(false);
        this.stop.setForeground(Color.WHITE);
        this.stop.setFont(FontResource.getNormalFont());
        this.stop.addActionListener(this);
        this.stop.setName("STOP");
        this.stop.setMargin(new Insets(0, 0, 0, 0));
        this.stop.setBounds(this.getScaledValue(490), y + this.getScaledValue(15), this.getScaledValue(100), h);
        this.stop.addActionListener(this);
        this.add(this.stop);
        this.chkHwAccel = new JCheckBox(StringResource.get("LBL_HW_ACCEL"));
        this.chkHwAccel.setBounds(this.getScaledValue(14), y += h, this.getWidth(), this.getScaledValue(30));
        this.chkHwAccel.setIcon(ImageResource.get("unchecked.png"));
        this.chkHwAccel.setSelectedIcon(ImageResource.get("checked.png"));
        this.chkHwAccel.setOpaque(false);
        this.chkHwAccel.setFocusPainted(false);
        this.chkHwAccel.setForeground(Color.WHITE);
        this.chkHwAccel.setSelected(true);
        this.add(this.chkHwAccel);
        y += 30;
        this.list.setFixedCellWidth(this.getWidth());
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int x = e.getX();
                if (ConversionWindow.this.renderer.isInside(x)) {
                    int index = ConversionWindow.this.list.getSelectedIndex();
                    if (index < 0) {
                        return;
                    }
                    ConversionWindow.this.pop.show(ConversionWindow.this.list, e.getX(), e.getY());
                }
            }
        });
        this.pop = new JPopupMenu();
        float i2 = 1.5f;
        while (i2 <= 5.0f) {
            JMenuItem item1 = new JMenuItem(String.valueOf((int)(i2 * 100.0f)) + "%");
            item1.addActionListener(this);
            item1.setName(String.valueOf(i2));
            this.pop.add(item1);
            i2 += 0.5f;
        }
    }

    private void showProgressPanel() {
        this.lblOutputFolder.setVisible(false);
        this.lblConvertFormat.setVisible(false);
        this.btnOutFormat.setVisible(false);
        this.txtOutFolder.setVisible(false);
        this.browse.setVisible(false);
        this.convert.setVisible(false);
        this.lblPrg.setVisible(true);
        this.prgConvert.setVisible(true);
        this.chkHwAccel.setVisible(false);
        this.stop.setVisible(true);
    }

    private void showFormatPanel() {
        this.lblOutputFolder.setVisible(true);
        this.lblConvertFormat.setVisible(true);
        this.btnOutFormat.setVisible(true);
        this.txtOutFolder.setVisible(true);
        this.browse.setVisible(true);
        this.convert.setVisible(true);
        this.lblPrg.setVisible(false);
        this.prgConvert.setVisible(false);
        this.chkHwAccel.setVisible(true);
        this.stop.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block20: {
            String name;
            if (!(e.getSource() instanceof JComponent)) break block20;
            JComponent btn = (JComponent)e.getSource();
            switch (name = btn.getName()) {
                case "CLOSE": {
                    this.onClosed();
                    break;
                }
                case "FORMAT_SELECT": {
                    this.fmtWnd.setVisible(true);
                    if (!this.fmtWnd.isApproveOption()) break;
                    MediaFormat fmt = this.fmtWnd.getFormat();
                    this.btnOutFormat.setText(fmt.getDescription());
                    break;
                }
                case "STOP": {
                    this.stop();
                    break;
                }
                case "CONVERT": {
                    int i = 0;
                    while (i < this.model.size()) {
                        ConversionItem item = this.model.getElementAt(i);
                        String file = XDMUtils.getFileNameWithoutExtension(item.inputFileName);
                        String ext = this.fmtWnd.getFormat().getFormat();
                        item.outFileName = String.valueOf(file) + "." + ext;
                        ++i;
                    }
                    System.out.println("starting convert");
                    this.mode = 1;
                    this.t = new Thread(this);
                    this.t.start();
                    break;
                }
                case "BROWSE_FOLDER": {
                    JFileChooser jfc = new JFileChooser();
                    jfc.setFileSelectionMode(1);
                    if (jfc.showOpenDialog(this) != 0) break;
                    this.txtOutFolder.setText(jfc.getSelectedFile().getAbsolutePath());
                    break;
                }
                default: {
                    ConversionItem item;
                    if (!(btn instanceof JMenuItem) || (item = this.list.getSelectedValue()) == null) break;
                    item.volume = name;
                }
            }
        }
    }

    void onClosed() {
        this.stop();
        this.dispose();
    }

    @Override
    public void run() {
        this.stopflag = false;
        if (this.mode == 0) {
            this.loadFiles();
        } else if (this.mode == 1) {
            System.out.println("starting conversion");
            this.convertFiles();
        }
    }

    private String getVideoFolder() {
        File f = new File(System.getProperty("user.home"), "Videos");
        if (!f.exists()) {
            f.mkdirs();
        }
        return f.getAbsolutePath();
    }

    /*
     * Exception decompiling
     */
    private void convertFiles() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 4[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void loadFiles() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 4[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void progress(final int progress) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTime > 1000L) {
            this.lastTime = currentTime;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConversionWindow.this.prgConvert.setValue(progress);
                }
            });
        }
    }
}

