/*
 * Decompiled with CFR 0.152.
 */
package xdman.network;

import java.net.URL;
import xdman.util.StringUtils;

public class ParsedURL {
    private String _url;
    private int port;
    private String host;
    private String pathAndQuery;
    private String protocol;

    public static ParsedURL parse(String urlString) {
        try {
            String query;
            URL url = new URL(urlString);
            ParsedURL parsedURL = new ParsedURL();
            parsedURL._url = urlString;
            parsedURL.host = url.getHost();
            parsedURL.port = url.getPort();
            if (parsedURL.port < 0) {
                parsedURL.port = url.getDefaultPort();
            }
            parsedURL.protocol = url.getProtocol();
            parsedURL.pathAndQuery = url.getPath();
            if (StringUtils.isNullOrEmptyOrBlank(parsedURL.pathAndQuery)) {
                parsedURL.pathAndQuery = "/";
            }
            if (!StringUtils.isNullOrEmptyOrBlank(query = url.getQuery())) {
                parsedURL.pathAndQuery = String.valueOf(parsedURL.pathAndQuery) + "?" + query;
            }
            return parsedURL;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return this._url;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getPathAndQuery() {
        return this.pathAndQuery;
    }

    public String getProtocol() {
        return this.protocol;
    }
}

