/*
 * Decompiled with CFR 0.152.
 */
package xdman.monitoring;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xdman.XDMApp;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.monitoring.ParsedHookData;
import xdman.util.Logger;
import xdman.util.StringUtils;
import xdman.util.XDMUtils;

public class InstagramHandler {
    private static Pattern pattern;

    public static boolean handle(File tempFile, ParsedHookData data) {
        try {
            Matcher matcher;
            String ln;
            StringBuffer buf = new StringBuffer();
            FileInputStream in = new FileInputStream(tempFile);
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            while ((ln = r.readLine()) != null) {
                buf.append(String.valueOf(ln) + "\n");
            }
            ((InputStream)in).close();
            Logger.log("Parsing instagram page...");
            if (pattern == null) {
                pattern = Pattern.compile("\"video\\_url\"\\s*:\\s*\"(.*?)\"");
            }
            if ((matcher = pattern.matcher(buf)).find()) {
                String ext;
                int start = matcher.start();
                int end = matcher.end();
                String url = matcher.group(1);
                Logger.log("Url: " + url);
                HttpMetadata metadata = new HttpMetadata();
                metadata.setUrl(url);
                metadata.setHeaders(data.getRequestHeaders());
                String file = data.getFile();
                if (StringUtils.isNullOrEmptyOrBlank(file)) {
                    file = XDMUtils.getFileName(data.getUrl());
                }
                ext = (ext = XDMUtils.getExtension(XDMUtils.getFileName(url))) != null ? ext.replace(".", "").toUpperCase() : "";
                XDMApp.getInstance().addMedia(metadata, String.valueOf(file) + "." + ext, ext);
            }
            return true;
        }
        catch (Exception e) {
            Logger.log(e);
            return false;
        }
    }
}

