/*
 * Decompiled with CFR 0.152.
 */
package xdman;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import xdman.DownloadQueue;
import xdman.QueueManager;
import xdman.XDMApp;
import xdman.util.DateTimeUtils;
import xdman.util.Logger;
import xdman.util.UpdateChecker;
import xdman.util.XDMUtils;

public class QueueScheduler
implements Runnable {
    private boolean stop = false;
    private long lastKeepAwakePing = 0L;
    private static QueueScheduler _this;

    private QueueScheduler() {
    }

    public static QueueScheduler getInstance() {
        if (_this == null) {
            _this = new QueueScheduler();
        }
        return _this;
    }

    public void start() {
        this.lastKeepAwakePing = System.currentTimeMillis();
        new Thread(this).start();
    }

    @Override
    public void run() {
        long lastUpdateChecked = 0L;
        try {
            Calendar cal = Calendar.getInstance();
            while (!this.stop) {
                try {
                    Date now;
                    DownloadQueue queue;
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - this.lastKeepAwakePing > 3000L && !XDMApp.getInstance().isAllFinished()) {
                        XDMUtils.keepAwakePing();
                        this.lastKeepAwakePing = currentTime;
                    }
                    ArrayList<DownloadQueue> queues = QueueManager.getInstance().getQueueList();
                    int i = 0;
                    while (i < queues.size()) {
                        block20: {
                            block22: {
                                Date onlyDate;
                                block21: {
                                    queue = queues.get(i);
                                    if (queue.isRunning() || queue.getStartTime() == -1L) break block20;
                                    now = new Date();
                                    cal.setTime(now);
                                    onlyDate = DateTimeUtils.getDatePart(cal);
                                    long seconds = DateTimeUtils.getTimePart(now);
                                    if (seconds <= queue.getStartTime() || queue.getEndTime() > 0L && queue.getEndTime() < seconds) break block20;
                                    if (!queue.isPeriodic()) break block21;
                                    int day = cal.get(7);
                                    int mask = 1 << day - 1;
                                    if ((queue.getDayMask() & mask) == mask) break block22;
                                    break block20;
                                }
                                Date execDate = queue.getExecDate();
                                if (execDate == null) break block20;
                                cal.setTime(execDate);
                                Date onlyDate2 = DateTimeUtils.getDatePart(cal);
                                if (onlyDate.compareTo(onlyDate2) < 0) break block20;
                            }
                            queue.start();
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < queues.size()) {
                        queue = queues.get(i);
                        if (queue.isRunning() && queue.getEndTime() >= 1L) {
                            now = new Date();
                            long seconds = DateTimeUtils.getTimePart(now);
                            if (queue.getEndTime() < seconds) {
                                queue.stop();
                            }
                        }
                        ++i;
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception e2) {
                    Logger.log("error in scheduler: " + e2);
                    Logger.log(e2);
                }
                long now = System.currentTimeMillis();
                if (now - lastUpdateChecked > 3600000L) {
                    int stat = UpdateChecker.getUpdateStat();
                    switch (stat) {
                        case 40: {
                            break;
                        }
                        case 10: {
                            XDMApp.getInstance().notifyAppUpdate();
                            break;
                        }
                        case 30: {
                            XDMApp.getInstance().notifyComponentInstall();
                            break;
                        }
                        case 20: {
                            XDMApp.getInstance().notifyComponentUpdate();
                        }
                    }
                }
                lastUpdateChecked = now;
            }
        }
        catch (Exception e) {
            Logger.log("error in scheduler: " + e);
            Logger.log(e);
        }
    }
}

