/*
 * Decompiled with CFR 0.152.
 */
package xdman.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import xdman.network.http.ChunkedInputStream;
import xdman.network.http.HeaderCollection;
import xdman.util.Logger;
import xdman.util.StringUtils;

public class NetUtils {
    public static byte[] getBytes(String str) {
        return str.getBytes();
    }

    public static final String readLine(InputStream in) throws IOException {
        StringBuffer buf = new StringBuffer();
        while (true) {
            int x;
            if ((x = in.read()) == -1) {
                throw new IOException("Unexpected EOF while reading header line");
            }
            if (x == 10) {
                return buf.toString();
            }
            if (x == 13) continue;
            buf.append((char)x);
        }
    }

    public static final int getResponseCode(String statusLine) {
        String[] arr = statusLine.split(" ");
        if (arr.length < 2) {
            return 400;
        }
        return Integer.parseInt(arr[1]);
    }

    public static long getContentLength(HeaderCollection headers) {
        try {
            String clen = headers.getValue("content-length");
            if (clen != null) {
                return Long.parseLong(clen);
            }
            clen = headers.getValue("content-range");
            if (clen != null) {
                String str = clen.split(" ")[1];
                str = str.split("/")[0];
                String[] arr = str.split("-");
                return Long.parseLong(arr[1]) - Long.parseLong(arr[0]) + 1L;
            }
            return -1L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static InputStream getInputStream(HeaderCollection respHeaders, InputStream inStream) throws IOException {
        String transferEncoding = respHeaders.getValue("transfer-encoding");
        if (!StringUtils.isNullOrEmptyOrBlank(transferEncoding)) {
            inStream = new ChunkedInputStream(inStream);
        }
        String contentEncoding = respHeaders.getValue("content-encoding");
        Logger.log("Content-Encoding: " + contentEncoding);
        if (!StringUtils.isNullOrEmptyOrBlank(contentEncoding)) {
            if (contentEncoding.equalsIgnoreCase("gzip")) {
                inStream = new GZIPInputStream(inStream);
            } else if (!contentEncoding.equalsIgnoreCase("none") && !contentEncoding.equalsIgnoreCase("identity")) {
                throw new IOException("Content Encoding not supported: " + contentEncoding);
            }
        }
        return inStream;
    }

    public static void skipRemainingStream(HeaderCollection respHeaders, InputStream inStream) throws IOException {
        inStream = NetUtils.getInputStream(respHeaders, inStream);
        long length = NetUtils.getContentLength(respHeaders);
        NetUtils.skipRemainingStream(inStream, length);
    }

    public static void skipRemainingStream(InputStream inStream, long length) throws IOException {
        byte[] buf = new byte[8192];
        if (length > 0L) {
            while (length > 0L) {
                int r = (int)(length > (long)buf.length ? (long)buf.length : length);
                int x = inStream.read(buf, 0, r);
                if (x != -1) {
                    length -= (long)x;
                    continue;
                }
                break;
            }
        } else {
            int x;
            while ((x = inStream.read(buf)) != -1) {
            }
        }
    }

    public static String getNameFromContentDisposition(String header) {
        block6: {
            if (header != null) break block6;
            return null;
        }
        try {
            header = header.toLowerCase();
            if (header.startsWith("attachment")) {
                String[] arr = header.split(";");
                int i = 0;
                while (i < arr.length) {
                    String str = arr[i].trim();
                    if (str.toLowerCase().startsWith("filename")) {
                        int index = str.indexOf(61);
                        return str.substring(index + 1).replace("\"", "").trim();
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getCleanContentType(String contentType) {
        if (contentType == null || contentType.length() < 1) {
            return contentType;
        }
        int index = contentType.indexOf(";");
        if (index > 0) {
            contentType = contentType.substring(0, index).trim().toLowerCase();
        }
        return contentType;
    }
}

