/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import xdman.Config;
import xdman.DownloadQueue;
import xdman.XDMApp;
import xdman.downloaders.metadata.DashMetadata;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.mediaconversion.MediaFormat;
import xdman.mediaconversion.MediaFormats;
import xdman.ui.components.CustomButton;
import xdman.ui.components.TitlePanel;
import xdman.ui.components.XDMFileChooser;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.Logger;
import xdman.util.XDMUtils;

public class VideoDownloadWindow
extends JDialog
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 416356191545932172L;
    private JTextField txtFile;
    private JPopupMenu pop;
    private CustomButton btnMore;
    private CustomButton btnDN;
    private CustomButton btnCN;
    private HttpMetadata metadata;
    private String folder;
    private String queueId;
    private JComboBox<MediaFormat> cmbOutFormat;
    private String originalExt;
    private DefaultComboBoxModel<MediaFormat> formatListModel;
    private boolean dashAudioOnly;

    public VideoDownloadWindow(HttpMetadata metadata, String file) {
        this.metadata = metadata;
        if (this.metadata == null) {
            this.metadata = new HttpMetadata();
        }
        this.initUI();
        if (file != null && file.length() > 0) {
            this.txtFile.setText(file);
            this.txtFile.setCaretPosition(0);
            this.originalExt = XDMUtils.getExtension(this.txtFile.getText());
        }
        this.getRootPane().setDefaultButton(this.btnDN);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                VideoDownloadWindow.this.txtFile.requestFocus();
            }
        });
        this.queueId = "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComponent) {
            String name = ((JComponent)e.getSource()).getName();
            if (name.startsWith("QUEUE")) {
                System.out.println(name);
                String[] arr = name.split(":");
                this.queueId = arr.length < 2 ? "" : arr[1].trim();
                this.createDownload(false);
            } else if (name.equals("FORMAT_SELECT")) {
                this.updateFileExtension();
            } else if (name.equals("CLOSE")) {
                this.dispose();
            } else if (name.equals("DOWNLOAD_NOW")) {
                this.queueId = "";
                this.createDownload(true);
            } else if (name.equals("BTN_MORE")) {
                if (this.pop == null) {
                    this.createPopup();
                }
                this.pop.show(this.btnMore, 0, this.btnMore.getHeight());
            } else if (name.equals("BROWSE_FOLDER")) {
                this.choseFolder();
            }
        }
    }

    private void createDownload(boolean now) {
        int fmtIndex;
        MediaFormat fmt;
        String fileName = this.txtFile.getText();
        if (fileName.length() < 1) {
            JOptionPane.showMessageDialog(this, StringResource.get("MSG_NO_URL"));
            return;
        }
        this.dispose();
        Logger.log("file: " + this.txtFile.getText());
        if (this.txtFile.getText().length() < 1) {
            JOptionPane.showMessageDialog(this, StringResource.get("MSG_NO_FILE"));
            return;
        }
        String file = XDMUtils.createSafeFileName(this.txtFile.getText());
        if (this.metadata instanceof DashMetadata && (fmt = (MediaFormat)this.cmbOutFormat.getSelectedItem()) != null && fmt.isAudioOnly()) {
            this.dashAudioOnly = true;
        }
        if ((fmtIndex = this.cmbOutFormat.getSelectedIndex()) < 0) {
            fmtIndex = 0;
        }
        XDMApp.getInstance().createDownload(file, this.folder, this.metadata, now, this.queueId, fmtIndex, this.dashAudioOnly ? 1 : 0);
    }

    private void choseFolder() {
        JFileChooser jfc = XDMFileChooser.getFileChooser(1, new File(this.folder == null ? Config.getInstance().getDownloadFolder() : this.folder));
        if (jfc.showOpenDialog(this) == 0) {
            this.folder = jfc.getSelectedFile().getAbsolutePath();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.update(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update(e);
    }

    void update(DocumentEvent e) {
        try {
            Document doc = e.getDocument();
            int len = doc.getLength();
            String text = doc.getText(0, len);
            this.txtFile.setText(XDMUtils.getFileName(text));
        }
        catch (Exception err) {
            Logger.log(err);
        }
    }

    private void initUI() {
        this.setUndecorated(true);
        try {
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT) && !Config.getInstance().isNoTransparency()) {
                this.setOpacity(0.85f);
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        this.setIconImage(ImageResource.get("icon.png").getImage());
        this.setSize(400, 210);
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(ColorResource.getDarkestBgColor());
        TitlePanel titlePanel = new TitlePanel(null, this);
        titlePanel.setOpaque(false);
        titlePanel.setBounds(0, 0, 400, 50);
        CustomButton closeBtn = new CustomButton();
        closeBtn.setBounds(365, 5, 30, 30);
        closeBtn.setBackground(ColorResource.getDarkestBgColor());
        closeBtn.setBorderPainted(false);
        closeBtn.setFocusPainted(false);
        closeBtn.setName("CLOSE");
        closeBtn.setIcon(ImageResource.get("close_btn.png"));
        closeBtn.addActionListener(this);
        titlePanel.add(closeBtn);
        JLabel titleLbl = new JLabel(StringResource.get("VID_TITLE"));
        titleLbl.setFont(FontResource.getBiggerFont());
        titleLbl.setForeground(ColorResource.getSelectionColor());
        titleLbl.setBounds(25, 15, 200, 30);
        titlePanel.add(titleLbl);
        JLabel lineLbl = new JLabel();
        lineLbl.setBackground(ColorResource.getSelectionColor());
        lineLbl.setBounds(0, 55, 400, 1);
        lineLbl.setOpaque(true);
        this.add(lineLbl);
        this.txtFile = new JTextField();
        this.txtFile.setBorder(new LineBorder(ColorResource.getSelectionColor(), 1));
        this.txtFile.setBackground(ColorResource.getDarkestBgColor());
        this.txtFile.setForeground(Color.WHITE);
        this.txtFile.setBounds(90, 79, 230, 20);
        this.txtFile.setCaretColor(ColorResource.getSelectionColor());
        this.add(this.txtFile);
        CustomButton browse = new CustomButton("...");
        browse.setName("BROWSE_FOLDER");
        browse.setMargin(new Insets(0, 0, 0, 0));
        browse.setBounds(325, 79, 40, 20);
        browse.setFocusPainted(false);
        browse.setBackground(ColorResource.getDarkestBgColor());
        browse.setBorder(new LineBorder(ColorResource.getSelectionColor(), 1));
        browse.setForeground(Color.WHITE);
        browse.addActionListener(this);
        browse.setFont(FontResource.getItemFont());
        this.add(browse);
        this.add(titlePanel);
        JLabel lblFile = new JLabel(StringResource.get("ND_FILE"), 4);
        lblFile.setFont(FontResource.getNormalFont());
        lblFile.setForeground(Color.WHITE);
        lblFile.setBounds(10, 79, 75, 23);
        this.add(lblFile);
        JLabel lblFmt = new JLabel(StringResource.get("LBL_CONVERT_TO"), 4);
        lblFmt.setFont(FontResource.getNormalFont());
        lblFmt.setForeground(Color.WHITE);
        lblFmt.setBounds(10, 111, 75, 23);
        this.add(lblFmt);
        this.cmbOutFormat = new JComboBox<MediaFormat>(MediaFormats.getSupportedFormats());
        this.cmbOutFormat.addActionListener(this);
        this.cmbOutFormat.setOpaque(true);
        this.cmbOutFormat.setBounds(90, 111, 277, 20);
        this.cmbOutFormat.setName("FORMAT_SELECT");
        this.add(this.cmbOutFormat);
        JPanel panel = new JPanel(null);
        panel.setBounds(0, 155, 400, 55);
        panel.setBackground(Color.DARK_GRAY);
        this.add(panel);
        this.btnMore = new CustomButton(StringResource.get("ND_MORE"));
        this.btnDN = new CustomButton(StringResource.get("ND_DOWNLOAD_NOW"));
        this.btnCN = new CustomButton(StringResource.get("ND_CANCEL"));
        this.btnMore.setBounds(0, 1, 120, 55);
        this.btnMore.setName("BTN_MORE");
        this.styleButton(this.btnMore);
        panel.add(this.btnMore);
        this.btnDN.setBounds(121, 1, 160, 55);
        this.btnDN.setName("DOWNLOAD_NOW");
        this.styleButton(this.btnDN);
        panel.add(this.btnDN);
        this.btnCN.setBounds(282, 1, 120, 55);
        this.btnCN.setName("CLOSE");
        this.styleButton(this.btnCN);
        panel.add(this.btnCN);
        Logger.log("Dash metadata? " + (this.metadata instanceof DashMetadata));
        this.cmbOutFormat.setEnabled(XDMUtils.isFFmpegInstalled());
    }

    private void createPopup() {
        this.pop = new JPopupMenu();
        this.pop.setBackground(ColorResource.getDarkerBgColor());
        JMenu dl = new JMenu(StringResource.get("ND_DOWNLOAD_LATER"));
        dl.setForeground(Color.WHITE);
        dl.setBorder(new EmptyBorder(5, 5, 5, 5));
        dl.addActionListener(this);
        dl.setBackground(ColorResource.getDarkerBgColor());
        dl.setBorderPainted(false);
        this.pop.add(dl);
        this.createQueueItems(dl);
        JMenuItem ig = new JMenuItem(StringResource.get("ND_IGNORE_URL"));
        ig.setName("IGNORE_URL");
        ig.setForeground(Color.WHITE);
        ig.addActionListener(this);
        this.pop.add(ig);
        this.pop.setInvoker(this.btnMore);
    }

    private void styleButton(CustomButton btn) {
        btn.setBackground(ColorResource.getDarkestBgColor());
        btn.setPressedBackground(ColorResource.getDarkerBgColor());
        btn.setForeground(Color.WHITE);
        btn.setFont(FontResource.getBigFont());
        btn.setBorderPainted(false);
        btn.setMargin(new Insets(0, 0, 0, 0));
        btn.setFocusPainted(false);
        btn.addActionListener(this);
    }

    private void createQueueItems(JMenuItem queueMenuItem) {
        ArrayList<DownloadQueue> queues = XDMApp.getInstance().getQueueList();
        int i = 0;
        while (i < queues.size()) {
            DownloadQueue q = queues.get(i);
            JMenuItem mItem = new JMenuItem(q.getName().length() < 1 ? "Default queue" : q.getName());
            mItem.setName("QUEUE:" + q.getQueueId());
            mItem.setForeground(Color.WHITE);
            mItem.addActionListener(this);
            queueMenuItem.add(mItem);
            ++i;
        }
    }

    private int getFormatIndex(int relativeIndex) {
        if (relativeIndex < 0) {
            return 0;
        }
        MediaFormat format = this.formatListModel.getElementAt(relativeIndex);
        int index = 0;
        MediaFormat[] mediaFormatArray = MediaFormats.getSupportedFormats();
        int n = mediaFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            MediaFormat fmt = mediaFormatArray[n2];
            if (format == fmt) {
                Logger.log("Format index: " + index);
                return index;
            }
            ++index;
            ++n2;
        }
        return 0;
    }

    private void updateFileExtension() {
        String file = XDMUtils.getFileNameWithoutExtension(this.txtFile.getText());
        if (this.cmbOutFormat.getSelectedIndex() < 1) {
            this.txtFile.setText(String.valueOf(file) + this.originalExt);
        } else {
            String ext = ((MediaFormat)this.cmbOutFormat.getSelectedItem()).getFormat();
            this.txtFile.setText(String.valueOf(file) + "." + ext);
        }
    }
}

