/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import xdman.Config;
import xdman.ui.components.DarkScrollBar;
import xdman.ui.components.XDMFrame;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;

public class Page
extends JPanel {
    private XDMFrame parent;
    private int diffx;
    private int diffy;
    private Color bgColor;
    protected JScrollPane jsp;
    private int y = 0;
    private int h = 0;
    private JLabel titleLbl;
    private JLabel btnNav;
    private int width;
    private String title;

    public Page(String title, int width, XDMFrame parent) {
        this.setOpaque(false);
        this.setLayout(null);
        this.title = title;
        this.width = width;
        this.parent = parent;
        this.bgColor = new Color(0, 0, 0, Config.getInstance().isNoTransparency() ? 255 : 200);
        MouseInputAdapter ma = new MouseInputAdapter(){};
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
        this.jsp = new JScrollPane();
        this.jsp.setOpaque(false);
        this.jsp.setBorder(null);
        this.jsp.getViewport().setOpaque(false);
        DarkScrollBar scrollBar = new DarkScrollBar(1);
        this.jsp.setVerticalScrollBar(scrollBar);
        this.jsp.setHorizontalScrollBarPolicy(31);
        this.jsp.getVerticalScrollBar().setUnitIncrement(10);
        this.jsp.getVerticalScrollBar().setBlockIncrement(25);
        this.add(this.jsp);
        this.registerMouseListener();
        this.init();
    }

    private void init() {
        this.y = 25;
        this.h = 40;
        this.btnNav = new JLabel(ImageResource.get("back24.png"));
        this.btnNav.setFont(FontResource.getBiggerFont());
        this.btnNav.setForeground(ColorResource.getSelectionColor());
        this.btnNav.setBounds(15, this.y, 25, this.h);
        this.add(this.btnNav);
        this.btnNav.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Page.this.close();
            }
        });
        this.titleLbl = new JLabel(this.title);
        this.titleLbl.setFont(FontResource.getBiggerFont());
        this.titleLbl.setForeground(ColorResource.getSelectionColor());
        this.titleLbl.setBounds(50, this.y, 200, this.h);
        this.add(this.titleLbl);
        this.y += this.h;
        this.y += 10;
        this.h = 2;
        JLabel lineLbl = new JLabel();
        lineLbl.setBackground(ColorResource.getSelectionColor());
        lineLbl.setBounds(0, this.y, this.width, this.h);
        lineLbl.setOpaque(true);
        this.add(lineLbl);
        this.y += this.h;
    }

    protected void setBgColor(Color color) {
        this.bgColor = color;
    }

    public void registerMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                Page.this.diffx = me.getXOnScreen() - ((Page)Page.this).parent.getLocationOnScreen().x;
                Page.this.diffy = me.getYOnScreen() - ((Page)Page.this).parent.getLocationOnScreen().y;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                Page.this.parent.setLocation(me.getXOnScreen() - Page.this.diffx, me.getYOnScreen() - Page.this.diffy);
            }
        });
    }

    public void close() {
        this.parent.hideDialog(this);
    }

    public void showPanel() {
        int x = this.parent.getWidth() - this.width;
        this.jsp.setBounds(0, this.y, this.width, this.parent.getHeight() - this.y);
        this.setBounds(x, 0, this.width, this.parent.getHeight());
        this.parent.showDialog(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Page.this.jsp.getVerticalScrollBar().setValue(0);
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.bgColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void addToPage(Component c) {
        this.add(c);
    }

    protected XDMFrame getParentFrame() {
        return this.parent;
    }
}

