/*
 * Decompiled with CFR 0.152.
 */
package xdman.monitoring;

import java.io.UnsupportedEncodingException;
import xdman.network.http.HeaderCollection;
import xdman.util.NetUtils;
import xdman.util.XDMUtils;

public class ParsedHookData {
    private static String[] blockedHeaders = new String[]{"accept", "if", "authorization", "proxy", "connection", "expect", "TE", "upgrade", "range"};
    private String url;
    private String file;
    private HeaderCollection requestHeaders;
    private HeaderCollection responseHeaders;
    private long contentLength;
    private String contentType;
    private String ext;
    private boolean partialResponse;

    public static ParsedHookData parse(byte[] b) throws UnsupportedEncodingException {
        ParsedHookData data = new ParsedHookData();
        data.requestHeaders = new HeaderCollection();
        data.responseHeaders = new HeaderCollection();
        String strBuf = new String(b, "utf-8");
        String[] arr = strBuf.split("\r\n");
        int i = 0;
        while (i < arr.length) {
            String str = arr[i];
            if (str.contains("=")) {
                String headerValue;
                String headerName;
                String ln = str;
                int index = ln.indexOf("=");
                String key = ln.substring(0, index).trim().toLowerCase();
                String val = ln.substring(index + 1).trim();
                if (key.equals("url")) {
                    data.setUrl(val);
                } else if (key.equals("file")) {
                    val = XDMUtils.getFileName(val);
                    data.setFile(val);
                } else if (key.equals("req")) {
                    index = val.indexOf(":");
                    if (index > 0) {
                        headerName = val.substring(0, index).trim().toLowerCase();
                        headerValue = val.substring(index + 1).trim();
                        if (headerName.equals("range") && !headerValue.startsWith("bytes=0-")) {
                            data.setPartialResponse(true);
                        }
                        if (!ParsedHookData.isBlockedHeader(headerName)) {
                            data.requestHeaders.addHeader(headerName, headerValue);
                        }
                        System.out.println(ln);
                    }
                } else if (key.equals("res") && (index = val.indexOf(":")) > 0) {
                    headerName = val.substring(0, index).trim().toLowerCase();
                    headerValue = val.substring(index + 1).trim();
                    data.responseHeaders.addHeader(headerName, headerValue);
                }
            }
            ++i;
        }
        if (data.responseHeaders.containsHeader("content-length") || data.responseHeaders.containsHeader("content-range")) {
            data.contentLength = NetUtils.getContentLength(data.responseHeaders);
        }
        if (data.responseHeaders.containsHeader("content-type")) {
            data.contentType = NetUtils.getCleanContentType(data.responseHeaders.getValue("content-type"));
        }
        try {
            data.setExt(XDMUtils.getExtension(XDMUtils.getFileName(data.getUrl())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    private static boolean isBlockedHeader(String name) {
        int i = 0;
        while (i < blockedHeaders.length) {
            if (name.startsWith(blockedHeaders[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(String url) {
        this.url = url;
    }

    public final String getFile() {
        return this.file;
    }

    public final void setFile(String file) {
        this.file = file;
    }

    public final HeaderCollection getRequestHeaders() {
        return this.requestHeaders;
    }

    public final void setRequestHeaders(HeaderCollection requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public final HeaderCollection getResponseHeaders() {
        return this.responseHeaders;
    }

    public final void setResponseHeaders(HeaderCollection responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public final long getContentLength() {
        return this.contentLength;
    }

    public final void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getExt() {
        return this.ext;
    }

    public void setExt(String ext) {
        this.ext = ext;
    }

    public boolean isPartialResponse() {
        return this.partialResponse;
    }

    public void setPartialResponse(boolean partialResponse) {
        this.partialResponse = partialResponse;
    }
}

