/*
 * Decompiled with CFR 0.152.
 */
package xdman.monitoring;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import xdman.XDMApp;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.monitoring.ParsedHookData;
import xdman.util.Logger;
import xdman.util.StringUtils;
import xdman.util.XDMUtils;

public class FBHandler {
    public static boolean handle(File tempFile, ParsedHookData data) {
        try {
            String file;
            HttpMetadata metadata;
            String ln;
            StringBuffer buf = new StringBuffer();
            FileInputStream in = new FileInputStream(tempFile);
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            while ((ln = r.readLine()) != null) {
                buf.append(String.valueOf(ln) + "\n");
            }
            ((InputStream)in).close();
            Logger.log("Parsing facebook page...");
            ArrayList<String> sdUrls1 = FBHandler.findURL("sd_src", buf);
            ArrayList<String> sdUrls2 = FBHandler.findURL("sd_src_no_ratelimit", buf);
            ArrayList<String> hdUrls1 = FBHandler.findURL("hd_src", buf);
            ArrayList<String> hdUrls2 = FBHandler.findURL("hd_src_no_ratelimit", buf);
            int i = 0;
            while (i < sdUrls1.size()) {
                metadata = new HttpMetadata();
                metadata.setUrl(sdUrls1.get(i));
                metadata.setHeaders(data.getRequestHeaders());
                file = data.getFile();
                if (StringUtils.isNullOrEmptyOrBlank(file)) {
                    file = XDMUtils.getFileName(data.getUrl());
                }
                XDMApp.getInstance().addMedia(metadata, String.valueOf(file) + ".mp4", "MP4 LOW");
                ++i;
            }
            i = 0;
            while (i < sdUrls2.size()) {
                metadata = new HttpMetadata();
                metadata.setUrl(sdUrls2.get(i));
                metadata.setHeaders(data.getRequestHeaders());
                file = data.getFile();
                if (StringUtils.isNullOrEmptyOrBlank(file)) {
                    file = XDMUtils.getFileName(data.getUrl());
                }
                XDMApp.getInstance().addMedia(metadata, String.valueOf(file) + ".mp4", "MP4 MEDIUM");
                ++i;
            }
            i = 0;
            while (i < hdUrls1.size()) {
                metadata = new HttpMetadata();
                metadata.setUrl(hdUrls1.get(i));
                metadata.setHeaders(data.getRequestHeaders());
                file = data.getFile();
                if (StringUtils.isNullOrEmptyOrBlank(file)) {
                    file = XDMUtils.getFileName(data.getUrl());
                }
                XDMApp.getInstance().addMedia(metadata, String.valueOf(file) + ".mp4", "MP4 HD");
                ++i;
            }
            i = 0;
            while (i < hdUrls2.size()) {
                metadata = new HttpMetadata();
                metadata.setUrl(hdUrls2.get(i));
                metadata.setHeaders(data.getRequestHeaders());
                file = data.getFile();
                if (StringUtils.isNullOrEmptyOrBlank(file)) {
                    file = XDMUtils.getFileName(data.getUrl());
                }
                XDMApp.getInstance().addMedia(metadata, String.valueOf(file) + ".mp4", "MP4 HQ");
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            Logger.log(e);
            return false;
        }
    }

    private static ArrayList<String> findURL(String keyword, StringBuffer buf) {
        boolean index1 = false;
        int index = 0;
        ArrayList<String> urlList = new ArrayList<String>();
        String urlStart = ":";
        while ((index = buf.indexOf(keyword, index)) >= 0) {
            char ch;
            index += keyword.length();
            if ((index = buf.indexOf(":", index)) < 0) break;
            int collonIndex = ++index;
            while ((ch = buf.charAt(index)) == ' ' || ch == '\n' || ch == '\r' || ch == '\t') {
                ++index;
            }
            ch = buf.charAt(index);
            if (ch != '\"') continue;
            int index3 = buf.indexOf("\"", ++index);
            String url = FBHandler.decodeJSONEscape(buf.substring(index, index3).trim().replace("\"", ""));
            Logger.log(String.valueOf(keyword) + ": " + url);
            urlList.add(url);
        }
        return urlList;
    }

    private static String decodeJSONEscape(String json) {
        StringBuffer buf = new StringBuffer();
        int pos = 0;
        while (true) {
            int index;
            if ((index = json.indexOf("\\u", pos)) < 0) {
                if (pos >= json.length()) break;
                buf.append(json.substring(pos));
                break;
            }
            buf.append(json.substring(pos, index));
            pos = index;
            String code = json.substring(pos + 2, pos + 2 + 4);
            int char_code = Integer.parseInt(code, 16);
            buf.append((char)char_code);
            pos += 6;
        }
        return buf.toString().replace("\\", "");
    }
}

