/*
 * Decompiled with CFR 0.152.
 */
package xdman.mediaconversion;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import xdman.mediaconversion.Format;
import xdman.mediaconversion.FormatGroup;
import xdman.ui.res.StringResource;

public class FormatLoader {
    public static List<FormatGroup> load() {
        ArrayList<FormatGroup> list = new ArrayList<FormatGroup>();
        try {
            Format format;
            String ln;
            InputStream inStream = StringResource.class.getResourceAsStream("/formats/format_db.txt");
            if (inStream == null) {
                inStream = new FileInputStream("formats/format_db.txt");
            }
            InputStreamReader r = new InputStreamReader(inStream, Charset.forName("utf-8"));
            BufferedReader br = new BufferedReader(r);
            while ((ln = br.readLine()).length() >= 1) {
                FormatGroup fg = new FormatGroup();
                String[] arr = ln.split("\\|");
                fg.name = arr[0].trim();
                fg.desc = arr[1].trim();
                System.out.println("group: " + fg.name);
                list.add(fg);
            }
            while ((format = Format.read(br)) != null) {
                FormatLoader.print(format);
                for (FormatGroup fg : list) {
                    if (!fg.name.equals(format.group)) continue;
                    System.out.println(String.valueOf(fg.desc) + " " + format.desc);
                    fg.formats.add(format);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    static void print(Format format) {
        int i;
        System.out.println("\t" + format.getDesc() + " '" + format.group + "'");
        List<String> list = format.getVideoCodecs();
        if (list.size() > 0) {
            System.out.print("\t\tVideo Codec:");
            i = 0;
            while (i < list.size()) {
                if (list.get(i).length() > 1) {
                    if (list.get(i).equals(format.getDefautVideoCodec())) {
                        System.out.print("*");
                    }
                    System.out.print(String.valueOf(list.get(i)) + " ");
                }
                ++i;
            }
            System.out.println("\n");
        }
        if ((list = format.getResolutions()).size() > 0) {
            System.out.print("\t\tResolution:");
            i = 0;
            while (i < list.size()) {
                if (list.get(i).length() > 1) {
                    if (list.get(i).equals(format.getDefaultResolution())) {
                        System.out.print("*");
                    }
                    System.out.print(String.valueOf(list.get(i)) + " ");
                }
                ++i;
            }
            System.out.println("\n");
        }
        if ((list = format.getAudioChannel()).size() > 0) {
            System.out.print("\t\tChannel:");
            i = 0;
            while (i < list.size()) {
                if (list.get(i).equals(format.getDefaultAudioChannel())) {
                    System.out.print("*");
                }
                System.out.print(String.valueOf(list.get(i)) + " ");
                ++i;
            }
            System.out.println("\n");
        }
    }
}

