/*
 * Decompiled with CFR 0.152.
 */
package xdman.downloaders.metadata;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.Iterator;
import java.util.UUID;
import xdman.Config;
import xdman.downloaders.metadata.DashMetadata;
import xdman.downloaders.metadata.HdsMetadata;
import xdman.downloaders.metadata.HlsMetadata;
import xdman.network.http.HeaderCollection;
import xdman.network.http.HttpHeader;
import xdman.util.Logger;
import xdman.util.StringUtils;

public class HttpMetadata {
    protected String id;
    protected String url;
    protected HeaderCollection headers;
    private long size;
    private String ydlUrl;

    public HttpMetadata derive() {
        Logger.log("derive normal metadata");
        HttpMetadata md = new HttpMetadata();
        md.setHeaders(this.getHeaders());
        md.setUrl(this.getUrl());
        md.setSize(this.getSize());
        return md;
    }

    public HttpMetadata() {
        this.id = UUID.randomUUID().toString();
        this.headers = new HeaderCollection();
    }

    protected HttpMetadata(String id) {
        this.id = id;
        this.headers = new HeaderCollection();
    }

    public int getType() {
        if (this.url.startsWith("ftp")) {
            return 1004;
        }
        return 1000;
    }

    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(String url) {
        this.url = url;
    }

    public final HeaderCollection getHeaders() {
        return this.headers;
    }

    public final void setHeaders(HeaderCollection headers) {
        this.headers = headers;
    }

    public String getId() {
        return this.id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HttpMetadata load(String id) {
        Logger.log("loading metadata: " + id);
        BufferedReader br = null;
        HttpMetadata metadata = null;
        try {
            br = new BufferedReader(new FileReader(new File(Config.getInstance().getMetadataFolder(), id)));
            String ln = br.readLine();
            if (ln == null) {
                Logger.log("invalid metadata, file is empty");
                return null;
            }
            int index = ln.indexOf(":");
            if (index < 0) {
                Logger.log("invalid metadata file starting with: " + ln);
                return null;
            }
            String key = ln.substring(0, index).trim().toLowerCase();
            String val = ln.substring(index + 1).trim();
            if (!key.equals("type")) {
                Logger.log("invalid metadata file starting with: " + ln);
                return null;
            }
            int type = Integer.parseInt(val);
            if (type == 1000 || type == 1004) {
                metadata = new HttpMetadata(id);
            } else if (type == 1001) {
                metadata = new HlsMetadata(id);
            } else if (type == 1002) {
                metadata = new HdsMetadata(id);
            } else if (type == 1003) {
                metadata = new DashMetadata(id);
            }
            while (true) {
                String val1;
                String key1;
                int index2;
                if ((ln = br.readLine()) == null) {
                    br.close();
                    return metadata;
                }
                index = ln.indexOf(":");
                if (index < 0) continue;
                key = ln.substring(0, index).trim().toLowerCase();
                val = ln.substring(index + 1).trim();
                if (key.equals("url")) {
                    metadata.setUrl(val);
                }
                if (key.equals("size")) {
                    metadata.setSize(Long.parseLong(val));
                }
                if (key.equals("header")) {
                    index2 = val.indexOf(":");
                    if (index2 < 0) continue;
                    key1 = val.substring(0, index2).trim();
                    val1 = val.substring(index2 + 1).trim();
                    metadata.headers.addHeader(key1, val1);
                }
                if (key.equals("header2")) {
                    index2 = val.indexOf(":");
                    if (index2 < 0) continue;
                    key1 = val.substring(0, index2).trim();
                    val1 = val.substring(index2 + 1).trim();
                    ((DashMetadata)metadata).getHeaders2().addHeader(key1, val1);
                }
                if (key.equals("url2")) {
                    ((DashMetadata)metadata).setUrl2(val);
                }
                if (key.equals("len1")) {
                    ((DashMetadata)metadata).setLen1(Long.parseLong(val));
                }
                if (key.equals("len2")) {
                    ((DashMetadata)metadata).setLen2(Long.parseLong(val));
                }
                if (key.equals("bitrate")) {
                    ((HdsMetadata)metadata).setBitRate(Integer.parseInt(val));
                }
                if (!key.equals("ydlurl")) continue;
                Logger.log("ydurl: " + val);
                metadata.ydlUrl = val;
            }
        }
        catch (Exception e) {
            Logger.log(e);
            return metadata;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void save() {
        block13: {
            FileOutputStream fw = null;
            try {
                File metadataFolder;
                HttpHeader header;
                Iterator<HttpHeader> headerIterator;
                StringBuilder sb = new StringBuilder();
                if (this.url == null) {
                    throw new NullPointerException("url is null");
                }
                sb.append("type: " + this.getType() + "\n");
                sb.append("url: " + this.url + "\n");
                sb.append("size: " + this.size + "\n");
                if (this.headers != null) {
                    headerIterator = this.headers.getAll();
                    while (headerIterator.hasNext()) {
                        header = headerIterator.next();
                        sb.append("header: " + header.getName() + ":" + header.getValue() + "\n");
                    }
                }
                if (this.getType() == 1002) {
                    sb.append("bitrate: " + ((HdsMetadata)this).getBitRate() + "\n");
                }
                if (this.getType() == 1003) {
                    sb.append("url2: " + ((DashMetadata)this).getUrl2() + "\n");
                    sb.append("len1: " + ((DashMetadata)this).getLen1() + "\n");
                    sb.append("len2: " + ((DashMetadata)this).getLen2() + "\n");
                    if (((DashMetadata)this).getHeaders2() != null) {
                        headerIterator = ((DashMetadata)this).getHeaders2().getAll();
                        while (headerIterator.hasNext()) {
                            header = headerIterator.next();
                            sb.append("header2: " + header.getName() + ":" + header.getValue() + "\n");
                        }
                    }
                }
                if (!StringUtils.isNullOrEmptyOrBlank(this.ydlUrl)) {
                    sb.append("ydlUrl: " + this.ydlUrl);
                }
                if (!(metadataFolder = new File(Config.getInstance().getMetadataFolder())).exists()) {
                    metadataFolder.mkdirs();
                }
                File file = new File(metadataFolder, this.id);
                fw = new FileOutputStream(file);
                fw.write(sb.toString().getBytes());
                fw.close();
            }
            catch (Exception e) {
                Logger.log(e);
                if (fw == null) break block13;
                try {
                    fw.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getYdlUrl() {
        return this.ydlUrl;
    }

    public void setYdlUrl(String ydlUrl) {
        this.ydlUrl = ydlUrl;
    }
}

