/*
 * Decompiled with CFR 0.152.
 */
package xdman.downloaders.http;

import xdman.downloaders.AbstractChannel;
import xdman.downloaders.Segment;
import xdman.downloaders.SegmentDownloader;
import xdman.downloaders.http.HttpChannel;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.util.Logger;
import xdman.util.MimeUtil;
import xdman.util.NetUtils;
import xdman.util.StringUtils;
import xdman.util.XDMUtils;

public class HttpDownloader
extends SegmentDownloader {
    private HttpMetadata metadata;
    private String newFileName;
    private boolean isJavaClientRequired;

    public HttpDownloader(String id, String folder, HttpMetadata metadata) {
        super(id, folder);
        this.metadata = metadata;
    }

    @Override
    public AbstractChannel createChannel(Segment segment) {
        HttpChannel hc = new HttpChannel(segment, this.metadata.getUrl(), this.metadata.getHeaders(), this.length, this.isJavaClientRequired);
        return hc;
    }

    @Override
    public int getType() {
        return 1000;
    }

    @Override
    public boolean isFileNameChanged() {
        Logger.log("Checking for filename change " + (this.newFileName != null));
        return this.newFileName != null;
    }

    @Override
    public String getNewFile() {
        return this.newFileName;
    }

    @Override
    protected void chunkConfirmed(Segment c) {
        String newExt;
        String ext;
        String name;
        String contentDispositionHeader;
        String oldFileName = this.getOutputFileName(false);
        HttpChannel hc = (HttpChannel)c.getChannel();
        this.isJavaClientRequired = hc.isJavaClientRequired();
        super.getLastModifiedDate(c);
        if (hc.isRedirected()) {
            this.metadata.setUrl(hc.getRedirectUrl());
            this.metadata.save();
        }
        if (String.valueOf(hc.getHeader("content-type")).contains("text/html") && hc.getHeader("content-disposition") == null) {
            this.newFileName = String.valueOf(XDMUtils.getFileNameWithoutExtension(oldFileName)) + ".html";
            this.outputFormat = 0;
        }
        if ((contentDispositionHeader = hc.getHeader("content-disposition")) != null && this.outputFormat == 0 && (name = NetUtils.getNameFromContentDisposition(contentDispositionHeader)) != null) {
            this.newFileName = name;
            Logger.log("set new filename: " + this.newFileName);
        }
        if (StringUtils.isNullOrEmptyOrBlank(ext = XDMUtils.getExtension(oldFileName)) && (newExt = MimeUtil.getFileExt(hc.getHeader("content-type"))) != null) {
            this.newFileName = String.valueOf(oldFileName) + "." + newExt;
        }
        Logger.log("new filename: " + this.newFileName);
    }

    @Override
    public HttpMetadata getMetadata() {
        return this.metadata;
    }
}

