/*
 * Decompiled with CFR 0.152.
 */
package xdman.downloaders;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import xdman.Config;
import xdman.DownloadListener;
import xdman.XDMApp;
import xdman.downloaders.Segment;
import xdman.downloaders.SegmentDetails;
import xdman.downloaders.SegmentListener;
import xdman.downloaders.http.HttpChannel;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.mediaconversion.FFmpeg;
import xdman.util.HttpDateParser;
import xdman.util.Logger;
import xdman.util.StringUtils;

public abstract class Downloader
implements SegmentListener {
    protected volatile boolean stopFlag;
    protected boolean isJavaClientRequired;
    protected long length;
    protected String folder;
    protected String id;
    protected boolean finished;
    protected int MAX_COUNT = 8;
    protected DownloadListener listener;
    protected long downloaded;
    protected long lastDownloaded;
    protected long prevTime;
    protected int progress;
    protected long lastUpdated;
    protected long lastSaved;
    protected boolean assembling;
    protected float downloadSpeed;
    protected String eta;
    protected SegmentDetails segDet;
    protected int errorCode;
    protected int outputFormat;
    protected boolean converting;
    protected int convertPrg;
    protected String lastModified;
    protected FFmpeg ffmpeg;
    protected ArrayList<Segment> chunks;

    public abstract void start();

    public abstract void stop();

    public abstract void resume();

    public abstract int getType();

    @Override
    public long getSize() {
        return this.length;
    }

    public int getProgress() {
        return this.progress;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public abstract boolean isFileNameChanged();

    public abstract String getNewFile();

    public abstract HttpMetadata getMetadata();

    public String getId() {
        return this.id;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean isAssembling() {
        return this.assembling;
    }

    public boolean isConverting() {
        return this.converting;
    }

    public float getDownloadSpeed() {
        return this.downloadSpeed;
    }

    public String getEta() {
        return this.eta;
    }

    public SegmentDetails getSegmentDetails() {
        return this.segDet;
    }

    public void setOuputMediaFormat(int format) {
        this.outputFormat = format;
    }

    protected synchronized int retryFailedChunks(int rem) throws IOException {
        if (this.stopFlag) {
            return 0;
        }
        int count = 0;
        int totalInactive = this.findTotalInactiveChunk();
        Logger.log("Total inactive chunks: " + totalInactive);
        if (totalInactive > rem) {
            totalInactive = rem;
        }
        if (totalInactive > 0) {
            while (totalInactive > 0) {
                Segment c = this.findInactiveChunk();
                if (c != null) {
                    c.download(this);
                    ++count;
                } else {
                    Logger.log("$$$ debug rem:" + rem);
                }
                --totalInactive;
            }
        }
        return count;
    }

    protected Segment findInactiveChunk() {
        if (this.stopFlag) {
            return null;
        }
        int i = 0;
        while (i < this.chunks.size()) {
            Segment c = this.chunks.get(i);
            if (!c.isFinished() && !c.isActive()) {
                return c;
            }
            ++i;
        }
        return null;
    }

    protected int findTotalInactiveChunk() {
        int count = 0;
        int i = 0;
        while (i < this.chunks.size()) {
            Segment c = this.chunks.get(i);
            if (!c.isFinished() && !c.isActive()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public int getActiveChunkCount() {
        int count = 0;
        int i = 0;
        while (i < this.chunks.size()) {
            if (this.chunks.get(i).isActive()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void registerListener(DownloadListener listener) {
        this.listener = listener;
    }

    public void unregisterListener() {
        this.listener = null;
    }

    protected boolean allFinished() {
        if (this.chunks.size() > 0) {
            int i = 0;
            while (i < this.chunks.size()) {
                Segment chunk = this.chunks.get(i);
                if (!chunk.isFinished()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected Segment getById(String id) {
        int i = 0;
        while (i < this.chunks.size()) {
            if (this.chunks.get(i).getId().equals(id)) {
                return this.chunks.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void cleanup() {
        File dir = new File(this.folder);
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            Logger.log("Delete: " + files[i] + " [" + files[i].length() + "] " + files[i].delete());
            ++i;
        }
        new File(this.folder).delete();
    }

    @Override
    public synchronized void synchronize() {
    }

    @Override
    public synchronized void chunkFailed(String id, String reason) {
        if (this.stopFlag) {
            return;
        }
        int err = 0;
        int i = 0;
        while (i < this.chunks.size()) {
            Segment chunk = this.chunks.get(i);
            if (chunk.isActive()) {
                return;
            }
            if (chunk.getErrorCode() != 0) {
                err = chunk.getErrorCode();
            }
            ++i;
        }
        if (err == 100) {
            this.errorCode = this.downloaded > 0L ? (this.length > 0L ? (this.chunks.size() > 1 ? 102 : 103) : 103) : 100;
        } else {
            Logger.log("Setting final error code: " + err);
            this.errorCode = err;
        }
        this.listener.downloadFailed(this.id);
        Logger.log("failed");
    }

    protected String getOutputFileName(boolean updated) {
        return this.listener.getOutputFile(this.id, updated);
    }

    protected String getOutputFolder() {
        return this.listener.getOutputFolder(this.id);
    }

    @Override
    public synchronized boolean promptCredential(String msg, boolean proxy) {
        return XDMApp.getInstance().promptCredential(this.id, msg, proxy);
    }

    protected File getBackupFile(String folder) {
        File f = new File(folder);
        File[] files = f.listFiles();
        if (files == null || files.length < 1) {
            return null;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(".bak")) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    public void setLastModifiedDate(File outFile) {
        if (Config.getInstance().isFetchTs()) {
            try {
                System.out.println("setting date");
                Date lastModified = HttpDateParser.parseHttpDate(this.lastModified);
                if (lastModified != null) {
                    System.out.println("setting date file " + lastModified);
                    boolean val = outFile.setLastModified(lastModified.getTime());
                    System.out.println("rename: " + val + new Date(outFile.lastModified()));
                }
            }
            catch (Exception e) {
                Logger.log(e);
            }
        }
    }

    public void getLastModifiedDate(Segment c) {
        if (StringUtils.isNullOrEmpty(this.lastModified)) {
            try {
                this.lastModified = ((HttpChannel)c.getChannel()).getHeader("last-modified");
            }
            catch (Exception e) {
                Logger.log(e);
            }
        }
    }

    protected void clearChannel(Segment s) {
        if (s != null) {
            s.clearChannel();
        }
    }
}

