/*
 * Decompiled with CFR 0.152.
 */
package xdman;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.PasswordAuthentication;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import xdman.ClipboardMonitor;
import xdman.Config;
import xdman.CredentialManager;
import xdman.DownloadEntry;
import xdman.DownloadListener;
import xdman.DownloadQueue;
import xdman.DownloadWindowListener;
import xdman.LinkRefreshCallback;
import xdman.ListChangeListener;
import xdman.QueueManager;
import xdman.QueueScheduler;
import xdman.downloaders.Downloader;
import xdman.downloaders.dash.DashDownloader;
import xdman.downloaders.ftp.FtpDownloader;
import xdman.downloaders.hds.HdsDownloader;
import xdman.downloaders.hls.HlsDownloader;
import xdman.downloaders.http.HttpDownloader;
import xdman.downloaders.metadata.DashMetadata;
import xdman.downloaders.metadata.HdsMetadata;
import xdman.downloaders.metadata.HlsMetadata;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.monitoring.BrowserMonitor;
import xdman.network.http.HttpContext;
import xdman.ui.components.ComponentInstaller;
import xdman.ui.components.DownloadCompleteWnd;
import xdman.ui.components.DownloadWindow;
import xdman.ui.components.MainWindow;
import xdman.ui.components.NewDownloadWindow;
import xdman.ui.components.TrayHandler;
import xdman.ui.components.VideoDownloadWindow;
import xdman.ui.components.VideoPopup;
import xdman.ui.res.StringResource;
import xdman.util.FFmpegDownloader;
import xdman.util.LinuxUtils;
import xdman.util.Logger;
import xdman.util.ParamUtils;
import xdman.util.StringUtils;
import xdman.util.UpdateChecker;
import xdman.util.XDMUtils;

public class XDMApp
implements DownloadListener,
DownloadWindowListener,
Comparator<String> {
    public static final String APP_VERSION = "7.1.2";
    private ArrayList<ListChangeListener> listChangeListeners;
    private Map<String, DownloadEntry> downloads;
    private static XDMApp _this;
    private HashMap<String, Downloader> downloaders;
    private HashMap<String, DownloadWindow> downloadWindows;
    private long lastSaved;
    private QueueManager qMgr;
    private LinkRefreshCallback refreshCallback;
    private ArrayList<String> pendingDownloads;
    private static HashMap<String, String> paramMap;
    private MainWindow mainWindow;
    private int pendingNotification = -1;

    public static void instanceStarted() {
        Logger.log("instance starting...");
        final XDMApp app = XDMApp.getInstance();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!paramMap.containsKey("background")) {
                    Logger.log("showing main window.");
                    app.showMainWindow();
                }
                TrayHandler.createTray();
            }
        });
        if (Config.getInstance().isFirstRun()) {
            if (XDMUtils.detectOS() == 10) {
                if (!XDMUtils.isAlreadyAutoStart()) {
                    XDMUtils.addToStartup();
                }
            } else {
                XDMUtils.addToStartup();
            }
        }
        Logger.log("instance started.");
    }

    public static void instanceAlreadyRunning() {
        Logger.log("instance already runninng");
        ParamUtils.sendParam(paramMap);
        System.exit(0);
    }

    public static void start(String[] args) {
        paramMap = new HashMap();
        boolean expect = false;
        boolean winInstall = false;
        String key = null;
        int i = 0;
        while (i < args.length) {
            if (expect) {
                if (key != null) {
                    paramMap.put(key, args[i]);
                }
                expect = false;
            } else if ("-u".equals(args[i])) {
                key = "url";
                expect = true;
            } else if ("-m".equals(args[i])) {
                paramMap.put("background", "true");
                expect = false;
            } else if ("-i".equals(args[i])) {
                paramMap.put("installer", "true");
                expect = false;
                winInstall = true;
            }
            ++i;
        }
        if (winInstall) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("wininstall");
                        if (UpdateChecker.getComponentVersion() == null) {
                            new ComponentInstaller().setVisible(true);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Logger.log("starting monitoring...");
        BrowserMonitor.getInstance().startMonitoring();
    }

    public void showMainWindow() {
        if (this.mainWindow == null) {
            this.mainWindow = new MainWindow();
        }
        this.mainWindow.setVisible(true);
        this.mainWindow.toFront();
    }

    private XDMApp() {
        Config.getInstance().load();
        this.listChangeListeners = new ArrayList();
        this.downloads = new HashMap<String, DownloadEntry>();
        this.downloaders = new HashMap();
        this.downloadWindows = new HashMap();
        this.loadDownloadList();
        this.lastSaved = System.currentTimeMillis();
        this.pendingDownloads = new ArrayList();
        this.qMgr = QueueManager.getInstance();
        this.qMgr.fixCorruptEntries(this.getDownloadIds(), this);
        QueueScheduler.getInstance().start();
        HttpContext.getInstance().init();
        if (Config.getInstance().isMonitorClipboard()) {
            ClipboardMonitor.getInstance().startMonitoring();
        }
    }

    public void exit() {
        this.saveDownloadList();
        this.qMgr.saveQueues();
        Config.getInstance().save();
        System.exit(0);
    }

    @Override
    public void downloadFinished(String id) {
        DownloadWindow wnd;
        DownloadEntry ent = this.downloads.get(id);
        ent.setState(100);
        Downloader d = this.downloaders.remove(id);
        if (d != null && d.getSize() < 0L) {
            ent.setSize(d.getDownloaded());
        }
        if ((wnd = this.downloadWindows.get(id)) != null) {
            wnd.close(100, 0);
            this.downloadWindows.remove(id);
            if (ent.isStartedByUser() && Config.getInstance().showDownloadCompleteWindow()) {
                new DownloadCompleteWnd(ent.getFile(), this.getFolder(ent)).setVisible(true);
            }
        }
        this.notifyListeners(null);
        this.saveDownloadList();
        if (Config.getInstance().isExecAntivir() && !StringUtils.isNullOrEmptyOrBlank(Config.getInstance().getAntivirExe())) {
            this.execAntivir();
        }
        this.processNextItem(id);
        if (this.isAllFinished()) {
            if (Config.getInstance().isAutoShutdown()) {
                this.initShutdown();
            }
            if (Config.getInstance().isExecCmd()) {
                this.execCmd();
            }
        }
    }

    @Override
    public void downloadFailed(String id) {
        Downloader d = this.downloaders.remove(id);
        if (id == null) {
            Logger.log("Download failed, id null");
            return;
        }
        DownloadWindow wnd = this.downloadWindows.get(id);
        if (wnd != null) {
            wnd.close(140, d.getErrorCode());
            this.downloadWindows.remove(id);
        } else {
            Logger.log("Wnd is null!!!");
        }
        DownloadEntry ent = this.downloads.get(id);
        ent.setState(130);
        this.notifyListeners(id);
        this.saveDownloadList();
        Logger.log("removed");
        this.processNextItem(id);
    }

    @Override
    public void downloadStopped(String id) {
        this.downloaders.remove(id);
        DownloadWindow wnd = this.downloadWindows.get(id);
        if (wnd != null) {
            wnd.close(130, 0);
            this.downloadWindows.remove(id);
        }
        DownloadEntry ent = this.downloads.get(id);
        ent.setState(130);
        this.notifyListeners(id);
        this.saveDownloadList();
        this.processNextItem(id);
    }

    @Override
    public void downloadConfirmed(String id) {
        DownloadWindow wnd;
        Logger.log("confirmed " + id);
        Downloader d = this.downloaders.get(id);
        DownloadEntry ent = this.downloads.get(id);
        ent.setSize(d.getSize());
        if (d.isFileNameChanged()) {
            ent.setFile(d.getNewFile());
            ent.setCategory(XDMUtils.findCategory(d.getNewFile()));
            this.updateFileName(ent);
        }
        if ((wnd = this.downloadWindows.get(id)) != null) {
            wnd.update(d, ent.getFile());
        }
        this.notifyListeners(id);
        this.saveDownloadList();
    }

    @Override
    public void downloadUpdated(String id) {
        DownloadEntry ent = this.downloads.get(id);
        Downloader d = this.downloaders.get(id);
        if (d == null) {
            Logger.log("################# sync error ##############");
        }
        ent.setSize(d.getSize());
        ent.setDownloaded(d.getDownloaded());
        ent.setProgress(d.getProgress());
        ent.setState(d.isAssembling() ? 910 : 110);
        DownloadWindow wnd = this.downloadWindows.get(id);
        if (wnd != null) {
            wnd.update(d, ent.getFile());
        }
        this.notifyListeners(id);
        long now = System.currentTimeMillis();
        if (now - this.lastSaved > 5000L) {
            this.saveDownloadList();
            this.lastSaved = now;
        }
    }

    public static XDMApp getInstance() {
        if (_this == null) {
            _this = new XDMApp();
        }
        return _this;
    }

    public void addDownload(final HttpMetadata metadata, final String file) {
        if (this.refreshCallback != null && this.refreshCallback.isValidLink(metadata)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (metadata != null && Config.getInstance().isDownloadAutoStart()) {
                    String fileName = file;
                    if (StringUtils.isNullOrEmptyOrBlank(file)) {
                        fileName = XDMUtils.getFileName(metadata.getUrl());
                    }
                    XDMApp.this.createDownload(fileName, null, metadata, true, "", 0, 0);
                    return;
                }
                new NewDownloadWindow(metadata, file).setVisible(true);
            }
        });
    }

    public void addVideo(final HttpMetadata metadata, final String file) {
        if (this.refreshCallback != null && this.refreshCallback.isValidLink(metadata)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!XDMUtils.isFFmpegInstalled()) {
                    if (JOptionPane.showConfirmDialog(null, StringResource.get("MSG_INSTALL_ADDITIONAL_COMPONENTS"), StringResource.get("MSG_COMPONENT_TITLE"), 0) == 0) {
                        FFmpegDownloader fd = new FFmpegDownloader();
                        fd.start();
                    }
                    return;
                }
                new VideoDownloadWindow(metadata, file).setVisible(true);
            }
        });
    }

    public void addMedia(final HttpMetadata metadata, final String file, final String info) {
        if (Config.getInstance().isShowVideoNotification()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VideoPopup.getInstance().addVideo(metadata, file, info);
                }
            });
        }
    }

    public void youtubeVideoTitleUpdated(final String url, final String title) {
        if (Config.getInstance().isShowVideoNotification()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (VideoPopup.hasInstance()) {
                        VideoPopup.getInstance().updateYoutubeTitle(url, title);
                    }
                }
            });
        }
    }

    public void createDownload(String file, String folder, HttpMetadata metadata, boolean now, String queueId, int formatIndex, int streamIndex) {
        DownloadQueue q;
        metadata.save();
        DownloadEntry ent = new DownloadEntry();
        ent.setId(metadata.getId());
        ent.setOutputFormatIndex(formatIndex);
        ent.setState(130);
        ent.setFile(file);
        ent.setFolder(folder);
        ent.setTempFolder(Config.getInstance().getTemporaryFolder());
        ent.setCategory(XDMUtils.findCategory(file));
        ent.setDate(System.currentTimeMillis());
        this.putInQueue(queueId, ent);
        ent.setStartedByUser(now);
        this.downloads.put(metadata.getId(), ent);
        this.saveDownloadList();
        if (!now && (q = this.qMgr.getQueueById(queueId)) != null && q.isRunning()) {
            Logger.log("Queue is running, if no pending download pickup next available download");
            q.next();
        }
        if (now) {
            this.startDownload(metadata.getId(), metadata, ent, streamIndex);
        }
        this.notifyListeners(null);
    }

    private void startDownload(String id, HttpMetadata metadata, DownloadEntry ent, int streams) {
        if (!this.checkAndBufferRequests(id)) {
            Logger.log("starting " + id + " with: " + metadata + " is dash: " + (metadata instanceof DashMetadata));
            Downloader d = null;
            if (metadata instanceof DashMetadata) {
                DashMetadata dm;
                Logger.log("Dash download with stream: " + streams);
                if (streams == 1) {
                    dm = (DashMetadata)metadata;
                    dm.setUrl(dm.getUrl2());
                    dm.setUrl2(null);
                } else if (streams == 2) {
                    dm = (DashMetadata)metadata;
                    dm.setUrl2(null);
                } else {
                    Logger.log("Dash download created");
                    dm = (DashMetadata)metadata;
                    d = new DashDownloader(id, ent.getTempFolder(), dm);
                }
            }
            if (metadata instanceof HlsMetadata) {
                Logger.log("Hls download created");
                d = new HlsDownloader(id, ent.getTempFolder(), (HlsMetadata)metadata);
            }
            if (metadata instanceof HdsMetadata) {
                Logger.log("Hls download created");
                d = new HdsDownloader(id, ent.getTempFolder(), (HdsMetadata)metadata);
            }
            if (d == null) {
                d = metadata.getType() == 1004 ? new FtpDownloader(id, ent.getTempFolder(), metadata) : new HttpDownloader(id, ent.getTempFolder(), metadata);
            }
            d.setOuputMediaFormat(ent.getOutputFormatIndex());
            this.downloaders.put(id, d);
            d.registerListener(this);
            ent.setState(110);
            d.start();
            if (Config.getInstance().showDownloadWindow()) {
                DownloadWindow wnd = new DownloadWindow(id, this);
                this.downloadWindows.put(id, wnd);
                wnd.setVisible(true);
            }
        } else {
            Logger.log(String.valueOf(id) + ": Maximum download limit reached, queueing request");
        }
    }

    @Override
    public void pauseDownload(String id) {
        Downloader d = this.downloaders.get(id);
        if (d != null) {
            d.stop();
            d.unregisterListener();
        }
    }

    public void resumeDownload(String id, boolean startedByUser) {
        DownloadEntry ent = this.downloads.get(id);
        ent.setStartedByUser(startedByUser);
        if (ent.getState() == 130 || ent.getState() == 140) {
            if (!this.checkAndBufferRequests(id)) {
                HttpMetadata hm;
                ent.setState(110);
                HttpMetadata metadata = HttpMetadata.load(id);
                if (Config.getInstance().showDownloadWindow() && ent.isStartedByUser()) {
                    DownloadWindow wnd = new DownloadWindow(id, this);
                    this.downloadWindows.put(id, wnd);
                    wnd.setVisible(true);
                }
                Downloader d = null;
                if (metadata instanceof DashMetadata) {
                    DashMetadata dm = (DashMetadata)metadata;
                    Logger.log("Dash download- url1: " + dm.getUrl() + " url2: " + dm.getUrl2());
                    d = new DashDownloader(id, ent.getTempFolder(), dm);
                }
                if (metadata instanceof HlsMetadata) {
                    hm = (HlsMetadata)metadata;
                    Logger.log("HLS download- url1: " + hm.getUrl());
                    d = new HlsDownloader(id, ent.getTempFolder(), (HlsMetadata)hm);
                }
                if (metadata instanceof HdsMetadata) {
                    hm = (HdsMetadata)metadata;
                    Logger.log("HLS download- url1: " + hm.getUrl());
                    d = new HdsDownloader(id, ent.getTempFolder(), (HdsMetadata)hm);
                }
                if (d == null) {
                    Logger.log("normal download");
                    d = metadata.getType() == 1004 ? new FtpDownloader(id, ent.getTempFolder(), metadata) : new HttpDownloader(id, ent.getTempFolder(), metadata);
                }
                this.downloaders.put(id, d);
                d.setOuputMediaFormat(ent.getOutputFormatIndex());
                d.registerListener(this);
                d.resume();
            } else {
                Logger.log(String.valueOf(id) + ": Maximum download limit reached, queueing request");
            }
            this.notifyListeners(null);
        }
    }

    public void restartDownload(String id) {
        DownloadEntry ent = this.downloads.get(id);
        if (ent.getState() != 130 && ent.getState() != 140 && ent.getState() != 100) {
            return;
        }
        ent.setState(130);
        this.clearData(ent);
        this.resumeDownload(id, true);
    }

    public synchronized void addListener(ListChangeListener listener) {
        this.listChangeListeners.add(listener);
    }

    public synchronized void removeListener(ListChangeListener listener) {
        this.listChangeListeners.remove(listener);
    }

    private void notifyListeners(String id) {
        if (this.listChangeListeners != null) {
            int i = 0;
            while (i < this.listChangeListeners.size()) {
                if (id != null) {
                    this.listChangeListeners.get(i).listItemUpdated(id);
                } else {
                    this.listChangeListeners.get(i).listChanged();
                }
                ++i;
            }
        }
    }

    public DownloadEntry getEntry(String id) {
        return this.downloads.get(id);
    }

    public ArrayList<String> getDownloadList(int category, int state, String searchText) {
        ArrayList<String> idList = new ArrayList<String>();
        for (String key : this.downloads.keySet()) {
            DownloadEntry ent = this.downloads.get(key);
            if (state != 0 && state != (ent.getState() == 100 ? 100 : 150) || category != 0 && category != ent.getCategory()) continue;
            if (searchText != null && searchText.length() > 0) {
                if (!ent.getFile().contains(searchText)) continue;
                idList.add(ent.getId());
                continue;
            }
            idList.add(ent.getId());
        }
        return idList;
    }

    private void clearData(DownloadEntry ent) {
        if (ent == null) {
            return;
        }
        File folder = new File(ent.getTempFolder(), ent.getId());
        File[] files = folder.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
        }
        folder.delete();
    }

    @Override
    public String getOutputFolder(String id) {
        DownloadEntry ent = this.downloads.get(id);
        if (ent == null) {
            return Config.getInstance().getCategoryOther();
        }
        return this.getFolder(ent);
    }

    @Override
    public String getOutputFile(String id, boolean update) {
        DownloadEntry ent = this.downloads.get(id);
        if (update) {
            this.updateFileName(ent);
        }
        return ent.getFile();
    }

    public String getFolder(DownloadEntry ent) {
        if (ent.getFolder() != null) {
            return ent.getFolder();
        }
        int category = ent.getCategory();
        switch (category) {
            case 10: {
                return Config.getInstance().getCategoryDocuments();
            }
            case 40: {
                return Config.getInstance().getCategoryMusic();
            }
            case 30: {
                return Config.getInstance().getCategoryVideos();
            }
            case 20: {
                return Config.getInstance().getCategoryPrograms();
            }
            case 50: {
                return Config.getInstance().getCategoryCompressed();
            }
        }
        return Config.getInstance().getCategoryOther();
    }

    private void loadDownloadList() {
        File file = new File(Config.getInstance().getDataFolder(), "downloads.txt");
        this.loadDownloadList(file);
    }

    public void loadDownloadList(File file) {
        if (!file.exists()) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));
            int count = Integer.parseInt(reader.readLine().trim());
            int i = 0;
            while (i < count) {
                int fieldCount = Integer.parseInt(reader.readLine().trim());
                DownloadEntry ent = new DownloadEntry();
                int j = 0;
                while (j < fieldCount) {
                    String ln = reader.readLine();
                    int index = ln.indexOf(":");
                    if (index > 0) {
                        String key = ln.substring(0, index).trim();
                        String val = ln.substring(index + 1).trim();
                        if (key.equals("id")) {
                            ent.setId(val);
                        }
                        if (key.equals("file")) {
                            ent.setFile(val);
                        }
                        if (key.equals("category")) {
                            ent.setCategory(Integer.parseInt(val));
                        }
                        if (key.equals("state")) {
                            int state = Integer.parseInt(val);
                            ent.setState(state == 100 ? state : 130);
                        }
                        if (key.equals("folder")) {
                            ent.setFolder(val);
                        }
                        if (key.equals("date")) {
                            ent.setDate(dateFormat.parse(val).getTime());
                        }
                        if (key.equals("downloaded")) {
                            ent.setDownloaded(Long.parseLong(val));
                        }
                        if (key.equals("size")) {
                            ent.setSize(Long.parseLong(val));
                        }
                        if (key.equals("progress")) {
                            ent.setProgress(Integer.parseInt(val));
                        }
                        if (key.equals("queueid")) {
                            ent.setQueueId(val);
                        }
                        if (key.equals("formatIndex")) {
                            ent.setOutputFormatIndex(Integer.parseInt(val));
                        }
                        if (key.equals("tempfolder")) {
                            ent.setTempFolder(val);
                        }
                    }
                    ++j;
                }
                this.downloads.put(ent.getId(), ent);
                ++i;
            }
            reader.close();
        }
        catch (Exception e) {
            Logger.log(e);
        }
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveDownloadList() {
        File file = new File(Config.getInstance().getDataFolder(), "downloads.txt");
        this.saveDownloadList(file);
    }

    public void saveDownloadList(File file) {
        int count = this.downloads.size();
        BufferedWriter writer = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String newLine = System.getProperty("line.separator");
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8")));
            writer.write(String.valueOf(count));
            writer.newLine();
            for (String key : this.downloads.keySet()) {
                DownloadEntry ent = this.downloads.get(key);
                int c = 0;
                StringBuffer sb = new StringBuffer();
                sb.append("id: " + ent.getId() + newLine);
                ++c;
                sb.append("file: " + ent.getFile() + newLine);
                ++c;
                sb.append("category: " + ent.getCategory() + newLine);
                ++c;
                sb.append("state: " + ent.getState() + newLine);
                ++c;
                if (ent.getFolder() != null) {
                    sb.append("folder: " + ent.getFolder() + newLine);
                    ++c;
                }
                sb.append("date: " + dateFormat.format(new Date(ent.getDate())) + newLine);
                ++c;
                sb.append("downloaded: " + ent.getDownloaded() + newLine);
                ++c;
                sb.append("size: " + ent.getSize() + newLine);
                ++c;
                sb.append("progress: " + ent.getProgress() + newLine);
                ++c;
                if (ent.getTempFolder() != null) {
                    sb.append("tempfolder: " + ent.getTempFolder() + newLine);
                    ++c;
                }
                if (ent.getQueueId() != null) {
                    sb.append("queueid: " + ent.getQueueId() + newLine);
                    ++c;
                }
                sb.append("formatIndex: " + ent.getOutputFormatIndex() + newLine);
                writer.write(String.valueOf(++c) + newLine);
                writer.write(sb.toString());
            }
            writer.close();
        }
        catch (Exception e) {
            Logger.log(e);
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void hidePrgWnd(String id) {
        DownloadWindow wnd = this.downloadWindows.get(id);
        if (wnd != null) {
            this.downloadWindows.remove(id);
            wnd.close(130, 0);
        }
    }

    private synchronized int getActiveDownloadCount() {
        int count = 0;
        for (String key : this.downloads.keySet()) {
            DownloadEntry ent = this.downloads.get(key);
            int state = ent.getState();
            if (state == 100 || state == 130 || state == 140) continue;
            ++count;
        }
        return count;
    }

    private synchronized boolean checkAndBufferRequests(String id) {
        int actCount = this.getActiveDownloadCount();
        if (Config.getInstance().getMaxDownloads() > 0 && actCount >= Config.getInstance().getMaxDownloads()) {
            Logger.log("active: " + actCount + " max: " + Config.getInstance().getMaxDownloads());
            if (!this.pendingDownloads.contains(id)) {
                this.pendingDownloads.add(id);
            }
            return true;
        }
        return false;
    }

    private synchronized void processNextItem(String lastId) {
        this.processPendingRequests();
        if (lastId == null) {
            return;
        }
        DownloadEntry ent = this.getEntry(lastId);
        if (ent == null) {
            return;
        }
        DownloadQueue queue = null;
        queue = "".equals(ent.getQueueId()) ? this.qMgr.getDefaultQueue() : this.qMgr.getQueueById(ent.getQueueId());
        if (queue != null && queue.isRunning()) {
            queue.next();
        }
    }

    private void processPendingRequests() {
        int i;
        int activeCount = this.getActiveDownloadCount();
        int maxDownloadCount = Config.getInstance().getMaxDownloads();
        ArrayList<String> tobeStartedIds = new ArrayList<String>();
        if (maxDownloadCount - activeCount > 0) {
            i = 0;
            while (i < Math.min(maxDownloadCount, this.pendingDownloads.size())) {
                String ent = this.pendingDownloads.get(i);
                tobeStartedIds.add(ent);
                ++i;
            }
        }
        if (tobeStartedIds.size() > 0) {
            i = 0;
            while (i < tobeStartedIds.size()) {
                String id = (String)tobeStartedIds.get(i);
                this.pendingDownloads.remove(id);
                DownloadEntry ent = this.getEntry(id);
                if (ent != null) {
                    this.resumeDownload(id, ent.isStartedByUser());
                }
                ++i;
            }
        }
    }

    public boolean queueItemPending(String queueId) {
        if (queueId == null) {
            return false;
        }
        int i = 0;
        while (i < this.pendingDownloads.size()) {
            String id = this.pendingDownloads.get(i);
            DownloadEntry ent = this.getEntry(id);
            if (ent != null && ent.getQueueId() != null && ent.getQueueId().equals(queueId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ArrayList<DownloadQueue> getQueueList() {
        return this.qMgr.getQueueList();
    }

    public DownloadQueue getQueueById(String queueId) {
        return this.qMgr.getQueueById(queueId);
    }

    private void putInQueue(String queueId, DownloadEntry ent) {
        DownloadQueue q = this.getQueueById(queueId);
        String id = ent.getId();
        if (q == null) {
            Logger.log("No queue found for: '" + queueId + "'");
            return;
        }
        String qid = ent.getQueueId();
        DownloadQueue oldQ = this.getQueueById(qid);
        Logger.log("Adding to: '" + queueId + "'");
        if (!q.getQueueId().equals(qid)) {
            if (oldQ != null) {
                oldQ.removeFromQueue(id);
            }
            ent.setQueueId(queueId);
            q.addToQueue(id);
        }
    }

    @Override
    public int compare(String key1, String key2) {
        DownloadEntry ent1 = this.getEntry(key1);
        DownloadEntry ent2 = this.getEntry(key2);
        if (ent1 == null) {
            return -1;
        }
        if (ent2 == null) {
            return 1;
        }
        if (ent1.getDate() > ent2.getDate()) {
            return 1;
        }
        if (ent1.getDate() < ent2.getDate()) {
            return -1;
        }
        return 0;
    }

    private Iterator<String> getDownloadIds() {
        return this.downloads.keySet().iterator();
    }

    public boolean isAllFinished() {
        if (this.getActiveDownloadCount() != 0) {
            return false;
        }
        if (this.pendingDownloads.size() != 0) {
            return false;
        }
        int i = 0;
        while (i < QueueManager.getInstance().getQueueList().size()) {
            DownloadQueue q = QueueManager.getInstance().getQueueList().get(i);
            if (q.hasPendingItems()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void initShutdown() {
        if (XDMUtils.detectOS() == 30) {
            LinuxUtils.initShutdown();
        }
        Logger.log("Initiating shutdown");
    }

    public int deleteDownloads(ArrayList<String> ids, boolean outflie) {
        int c = 0;
        int i = 0;
        while (i < ids.size()) {
            String id = ids.get(i);
            DownloadEntry ent = this.getEntry(id);
            if (ent != null && (ent.getState() == 100 || ent.getState() == 130 || ent.getState() == 140)) {
                DownloadQueue q;
                String qId;
                this.downloads.remove(id);
                if (this.pendingDownloads.contains(id)) {
                    this.pendingDownloads.remove(id);
                }
                if ((qId = ent.getQueueId()) != null && (q = this.getQueueById(qId)) != null && q.getQueueId().length() > 0) {
                    q.removeFromQueue(id);
                }
                this.deleteFiles(ent, outflie);
                ++c;
            }
            ++i;
        }
        this.saveDownloadList();
        this.notifyListeners(null);
        return ids.size() - c;
    }

    private void deleteFiles(DownloadEntry ent, boolean outfile) {
        File f;
        if (ent == null) {
            return;
        }
        String id = ent.getId();
        Logger.log("Deleting metadata for " + id);
        File mf = new File(Config.getInstance().getMetadataFolder(), id);
        boolean deleted = mf.delete();
        Logger.log("Deleted manifest " + id + " " + deleted);
        File df = new File(ent.getTempFolder(), id);
        File[] files = df.listFiles();
        if (files != null && files.length > 0) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                f = fileArray[n2];
                deleted = f.delete();
                Logger.log("Deleted tmp file " + id + " " + deleted);
                ++n2;
            }
        }
        deleted = df.delete();
        Logger.log("Deleted tmp folder " + id + " " + deleted);
        if (outfile) {
            f = new File(XDMApp.getInstance().getFolder(ent), ent.getFile());
            f.delete();
        }
    }

    public void changeOutputFile(String id) {
    }

    public String getURL(String id) {
        try {
            HttpMetadata metadata = HttpMetadata.load(id);
            if (metadata instanceof DashMetadata) {
                DashMetadata dm = (DashMetadata)metadata;
                return String.valueOf(dm.getUrl()) + "\n" + dm.getUrl2();
            }
            return metadata.getUrl();
        }
        catch (Exception e) {
            Logger.log(e);
            return "";
        }
    }

    public void registerRefreshCallback(LinkRefreshCallback callback) {
        this.refreshCallback = callback;
    }

    public void unregisterRefreshCallback() {
        this.refreshCallback = null;
    }

    public void deleteCompleted() {
        Iterator<String> allIds = this.downloads.keySet().iterator();
        ArrayList<String> idList = new ArrayList<String>();
        while (allIds.hasNext()) {
            String id = allIds.next();
            DownloadEntry ent = this.downloads.get(id);
            if (ent.getState() != 100) continue;
            idList.add(id);
        }
        this.deleteDownloads(idList, false);
    }

    public boolean promptCredential(String id, String msg, boolean proxy) {
        DownloadEntry ent = this.getEntry(id);
        if (ent == null) {
            return false;
        }
        if (!ent.isStartedByUser()) {
            return false;
        }
        PasswordAuthentication pauth = this.getCredential(msg, proxy);
        if (pauth == null) {
            return false;
        }
        if (proxy) {
            Config.getInstance().setProxyUser(pauth.getUserName());
            if (pauth.getPassword() != null) {
                Config.getInstance().setProxyPass(new String(pauth.getPassword()));
            }
        } else {
            Logger.log("saving password for: " + msg);
            CredentialManager.getInstance().addCredentialForHost(msg, pauth);
        }
        return true;
    }

    private PasswordAuthentication getCredential(String msg, boolean proxy) {
        JTextField user = new JTextField(30);
        JPasswordField pass = new JPasswordField(30);
        String prompt = proxy ? StringResource.get("PROMPT_PROXY") : String.format(StringResource.get("PROMPT_SERVER"), msg);
        Object[] obj = new Object[]{prompt, StringResource.get("DESC_USER"), user, StringResource.get("DESC_PASS"), pass};
        if (JOptionPane.showOptionDialog(null, obj, StringResource.get("PROMPT_CRED"), 2, -1, null, null, null) == 0) {
            PasswordAuthentication pauth = new PasswordAuthentication(user.getText(), pass.getPassword());
            return pauth;
        }
        return null;
    }

    private void execCmd() {
        if (!StringUtils.isNullOrEmptyOrBlank(Config.getInstance().getCustomCmd())) {
            XDMUtils.exec(Config.getInstance().getCustomCmd());
        }
    }

    private void execAntivir() {
        XDMUtils.exec(String.valueOf(Config.getInstance().getAntivirExe()) + " " + (Config.getInstance().getAntivirCmd() == null ? "" : Config.getInstance().getAntivirCmd()));
    }

    private void updateFileName(DownloadEntry ent) {
        if (Config.getInstance().getDuplicateAction() == 1) {
            return;
        }
        Logger.log("checking for same named file on disk...");
        String id = ent.getId();
        String outputFolder = this.getOutputFolder(id);
        File f = new File(outputFolder, ent.getFile());
        int c = 1;
        String ext = XDMUtils.getExtension(f.getAbsolutePath());
        if (ext == null) {
            ext = "";
        }
        String f2 = XDMUtils.getFileNameWithoutExtension(ent.getFile());
        while (f.exists()) {
            f = new File(outputFolder, String.valueOf(f2) + "_" + c + ext);
            ++c;
        }
        Logger.log("Updating file name- old: " + ent.getFile() + " new: " + f.getName());
        ent.setFile(f.getName());
    }

    public void importList(File file) {
        this.loadDownloadList(file);
    }

    public void exportList(File file) {
        this.saveDownloadList(file);
    }

    public void notifyComponentUpdate() {
        this.pendingNotification = 20;
        if (this.mainWindow != null) {
            this.mainWindow.showNotification();
        }
    }

    public void notifyComponentInstall() {
        this.pendingNotification = 30;
        if (this.mainWindow != null) {
            this.mainWindow.showNotification();
        }
    }

    public void notifyAppUpdate() {
        this.pendingNotification = 10;
        if (this.mainWindow != null) {
            this.mainWindow.showNotification();
        }
    }

    public void clearNotifications() {
        this.pendingNotification = -1;
        if (this.mainWindow != null) {
            this.mainWindow.showNotification();
        }
    }

    public int getNotification() {
        return this.pendingNotification;
    }

    private void openTempFolder(String id) {
        DownloadEntry ent = this.getEntry(id);
        if (ent == null) {
            return;
        }
        File df = new File(ent.getTempFolder(), id);
        try {
            XDMUtils.openFolder(null, df.getAbsolutePath());
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public void openPreview(String id) {
        DownloadEntry ent = XDMApp.getInstance().getEntry(id);
        if (ent != null && (ent.getCategory() == 30 || ent.getCategory() == 40)) {
            if (XDMUtils.isFFmpegInstalled()) {
                XDMApp.getInstance().openPreviewPlayer(id);
            } else {
                JOptionPane.showMessageDialog(null, StringResource.get("LBL_COMPONENT_MISSING"));
            }
        } else if (JOptionPane.showConfirmDialog(null, StringResource.get("LBL_NOT_A_VIDEO"), "Preview", 0) == 0) {
            XDMApp.getInstance().openTempFolder(id);
        }
    }

    private void openPreviewPlayer(String id) {
        XDMUtils.browseURL("http://127.0.0.1:9614/preview/media/" + id);
    }
}

