/*
 * Decompiled with CFR 0.152.
 */
package xdman;

import java.net.URL;
import xdman.Config;
import xdman.XDMApp;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.util.Logger;
import xdman.util.StringUtils;
import xdman.util.XDMUtils;

public class ClipboardMonitor
implements Runnable {
    private String lastContent;
    private static ClipboardMonitor _this;
    private Thread t;

    public static ClipboardMonitor getInstance() {
        if (_this == null) {
            _this = new ClipboardMonitor();
        }
        return _this;
    }

    private ClipboardMonitor() {
    }

    public void startMonitoring() {
        try {
            if (this.t == null) {
                this.t = new Thread(this);
                this.t.start();
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public void stopMonitoring() {
        try {
            if (this.t != null && this.t.isAlive()) {
                this.t.interrupt();
                this.t = null;
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                String txt;
                if (StringUtils.isNullOrEmptyOrBlank(txt = XDMUtils.getClipBoardText())) {
                    return;
                }
                if (!txt.equals(this.lastContent)) {
                    Logger.log("New content: " + txt);
                    this.lastContent = txt;
                    try {
                        new URL(txt);
                        HttpMetadata md = new HttpMetadata();
                        md.setUrl(txt);
                        String file = XDMUtils.getFileName(txt);
                        String ext = XDMUtils.getExtension(file);
                        if (!StringUtils.isNullOrEmptyOrBlank(ext)) {
                            ext = ext.toUpperCase().replace(".", "");
                        }
                        String[] arr = Config.getInstance().getFileExts();
                        boolean found = false;
                        int i = 0;
                        while (i < arr.length) {
                            if (arr[i].contains(ext)) {
                                found = true;
                                break;
                            }
                            ++i;
                        }
                        if (found) {
                            XDMApp.getInstance().addDownload(md, file);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            Logger.log(e);
            return;
        }
    }
}

