/*
 * Decompiled with CFR 0.152.
 */
package xdman.util;

import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import xdman.Config;
import xdman.Main;
import xdman.util.LinuxUtils;
import xdman.util.Logger;
import xdman.util.MacUtils;
import xdman.util.WinUtils;

public class XDMUtils {
    private static Map<Integer, String> categoryFolderMap = new HashMap<Integer, String>();
    private static final char[] invalid_chars;
    static String[] doc;
    static String[] cmp;
    static String[] music;
    static String[] vid;
    static String[] prog;
    public static final int WINDOWS = 10;
    public static final int MAC = 20;
    public static final int LINUX = 30;

    static {
        categoryFolderMap.put(10, "Documents");
        categoryFolderMap.put(40, "Music");
        categoryFolderMap.put(30, "Videos");
        categoryFolderMap.put(20, "Programs");
        categoryFolderMap.put(50, "Compressed");
        invalid_chars = new char[]{'/', '\\', '\"', '?', '*', '<', '>', ':', '|'};
        doc = new String[]{".doc", ".docx", ".txt", ".pdf", ".rtf", ".xml", ".c", ".cpp", ".java", ".cs", ".vb", ".html", ".htm", ".chm", ".xls", ".xlsx", ".ppt", ".pptx", ".js", ".css"};
        cmp = new String[]{".7z", ".zip", ".rar", ".gz", ".tgz", ".tbz2", ".bz2", ".lzh", ".sit", ".z"};
        music = new String[]{".mp3", ".wma", ".ogg", ".aiff", ".au", ".mid", ".midi", ".mp2", ".mpa", ".wav", ".aac", ".oga", ".ogx", ".ogm", ".spx", ".opus"};
        vid = new String[]{".mpg", ".mpeg", ".avi", ".flv", ".asf", ".mov", ".mpe", ".wmv", ".mkv", ".mp4", ".3gp", ".divx", ".vob", ".webm", ".ts"};
        prog = new String[]{".exe", ".msi", ".bin", ".sh", ".deb", ".cab", ".cpio", ".dll", ".jar", "rpm", ".run", ".py"};
    }

    public static String getFolderForCategory(int category) {
        return categoryFolderMap.get(category);
    }

    public static String decodeFileName(String str) {
        char[] ch = str.toCharArray();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < ch.length) {
            if (ch[i] != '/' && ch[i] != '\\' && ch[i] != '\"' && ch[i] != '?' && ch[i] != '*' && ch[i] != '<' && ch[i] != '>' && ch[i] != ':') {
                if (ch[i] == '%' && i + 2 < ch.length) {
                    int c = Integer.parseInt(String.valueOf(ch[i + 1]) + ch[i + 2], 16);
                    buf.append((char)c);
                    i += 2;
                } else {
                    buf.append(ch[i]);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String getFileName(String uri) {
        String path;
        block11: {
            block10: {
                int qindex;
                block9: {
                    block8: {
                        try {
                            if (uri != null) break block8;
                            return "FILE";
                        }
                        catch (Exception e) {
                            Logger.log(e);
                            return "FILE";
                        }
                    }
                    if (!uri.equals("/") && uri.length() >= 1) break block9;
                    return "FILE";
                }
                int x = uri.lastIndexOf("/");
                path = uri;
                if (x > -1) {
                    path = uri.substring(x);
                }
                if ((qindex = path.indexOf("?")) > -1) {
                    path = path.substring(0, qindex);
                }
                if ((path = XDMUtils.decodeFileName(path)).length() >= 1) break block10;
                return "FILE";
            }
            if (!path.equals("/")) break block11;
            return "FILE";
        }
        return XDMUtils.createSafeFileName(path);
    }

    public static String createSafeFileName(String str) {
        String safe_name = str;
        int i = 0;
        while (i < invalid_chars.length) {
            if (safe_name.indexOf(invalid_chars[i]) != -1) {
                safe_name = safe_name.replace(invalid_chars[i], '_');
            }
            ++i;
        }
        return safe_name;
    }

    public static boolean validateURL(String url) {
        try {
            url = url.toLowerCase();
            if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://")) {
                new URL(url);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int findCategory(String filename) {
        String file = filename.toLowerCase();
        int i = 0;
        while (i < doc.length) {
            if (file.endsWith(doc[i])) {
                return 10;
            }
            ++i;
        }
        i = 0;
        while (i < cmp.length) {
            if (file.endsWith(cmp[i])) {
                return 50;
            }
            ++i;
        }
        i = 0;
        while (i < music.length) {
            if (file.endsWith(music[i])) {
                return 40;
            }
            ++i;
        }
        i = 0;
        while (i < prog.length) {
            if (file.endsWith(prog[i])) {
                return 20;
            }
            ++i;
        }
        i = 0;
        while (i < vid.length) {
            if (file.endsWith(vid[i])) {
                return 30;
            }
            ++i;
        }
        return 60;
    }

    public static String appendArray2Str(String[] arr) {
        boolean first = true;
        StringBuffer buf = new StringBuffer();
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!first) {
                buf.append(",");
            }
            buf.append(s);
            first = false;
            ++n2;
        }
        return buf.toString();
    }

    public static String[] appendStr2Array(String str) {
        String[] arr = str.split(",");
        ArrayList<String> arrList = new ArrayList<String>();
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String txt = s.trim();
            if (txt.length() > 0) {
                arrList.add(txt);
            }
            ++n2;
        }
        arr = new String[arrList.size()];
        return arrList.toArray(arr);
    }

    public static String getExtension(String file) {
        int index = file.lastIndexOf(".");
        if (index > 0) {
            String ext = file.substring(index);
            return ext;
        }
        return null;
    }

    public static String getFileNameWithoutExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index > 0) {
            fileName = fileName.substring(0, index);
            return fileName;
        }
        return fileName;
    }

    public static void copyStream(InputStream instream, OutputStream outstream, long size) throws Exception {
        int x;
        byte[] b = new byte[8192];
        long rem = size;
        do {
            int bs = (int)(size > 0L ? (rem > (long)b.length ? (long)b.length : rem) : (long)b.length);
            x = instream.read(b, 0, bs);
            if (x == -1) {
                if (size <= 0L) break;
                throw new EOFException("Unexpected EOF");
            }
            outstream.write(b, 0, x);
        } while (size <= 0L || (rem -= (long)x) > 0L);
    }

    public static final int detectOS() {
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (os.contains("mac") || os.contains("darwin") || os.contains("os x") || os.contains("os x")) {
            return 20;
        }
        if (os.contains("linux")) {
            return 30;
        }
        if (os.contains("windows")) {
            return 10;
        }
        return -1;
    }

    public static final int getOsArch() {
        if (System.getProperty("os.arch").contains("64")) {
            return 64;
        }
        return 32;
    }

    public static void openFile(String file, String folder) throws Exception {
        int os = XDMUtils.detectOS();
        File f = new File(folder, file);
        switch (os) {
            case 10: {
                WinUtils.open(f);
                break;
            }
            case 30: {
                LinuxUtils.open(f);
                break;
            }
            case 20: {
                MacUtils.open(f);
                break;
            }
            default: {
                Desktop.getDesktop().open(f);
            }
        }
    }

    public static void openFolder(String file, String folder) throws Exception {
        int os = XDMUtils.detectOS();
        switch (os) {
            case 10: {
                WinUtils.openFolder(folder, file);
                break;
            }
            case 30: {
                File f = new File(folder);
                LinuxUtils.open(f);
                break;
            }
            case 20: {
                MacUtils.openFolder(folder, file);
                break;
            }
            default: {
                File ff = new File(folder);
                Desktop.getDesktop().open(ff);
            }
        }
    }

    public static void copyURL(String url) {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(url), null);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static boolean exec(String args) {
        try {
            Logger.log("Launching: " + args);
            Runtime.getRuntime().exec(args);
        }
        catch (IOException e) {
            Logger.log(e);
            return false;
        }
        return true;
    }

    public static long getFreeSpace(String folder) {
        if (folder == null) {
            return new File(Config.getInstance().getTemporaryFolder()).getFreeSpace();
        }
        return new File(folder).getFreeSpace();
    }

    public static void keepAwakePing() {
        try {
            int os = XDMUtils.detectOS();
            if (os == 30) {
                LinuxUtils.keepAwakePing();
            } else if (os == 10) {
                WinUtils.keepAwakePing();
            } else if (os == 20) {
                MacUtils.keepAwakePing();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isAlreadyAutoStart() {
        try {
            int os = XDMUtils.detectOS();
            if (os == 30) {
                return LinuxUtils.isAlreadyAutoStart();
            }
            if (os == 10) {
                return WinUtils.isAlreadyAutoStart();
            }
            if (os == 20) {
                return MacUtils.isAlreadyAutoStart();
            }
            return false;
        }
        catch (Throwable e) {
            Logger.log(e);
            return false;
        }
    }

    public static void addToStartup() {
        try {
            int os = XDMUtils.detectOS();
            if (os == 30) {
                LinuxUtils.addToStartup();
            } else if (os == 10) {
                WinUtils.addToStartup();
            } else if (os == 20) {
                MacUtils.addToStartup();
            }
        }
        catch (Throwable e) {
            Logger.log(e);
        }
    }

    public static void removeFromStartup() {
        try {
            int os = XDMUtils.detectOS();
            if (os == 30) {
                LinuxUtils.removeFromStartup();
            } else if (os == 10) {
                WinUtils.removeFromStartup();
            } else if (os == 20) {
                MacUtils.removeFromStartup();
            }
        }
        catch (Throwable e) {
            Logger.log(e);
        }
    }

    public static File getJarFile() {
        try {
            return new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean checkComponentsInstalled() {
        File ffFile = new File(Config.getInstance().getDataFolder(), XDMUtils.detectOS() == 10 ? "ffmpeg.exe" : "ffmpeg");
        File ytFile = new File(Config.getInstance().getDataFolder(), XDMUtils.detectOS() == 10 ? "youtube-dl.exe" : "youtube-dl");
        if (ffFile.exists() && ytFile.exists()) {
            return true;
        }
        ffFile = new File(XDMUtils.getJarFile().getParentFile(), XDMUtils.detectOS() == 10 ? "ffmpeg.exe" : "ffmpeg");
        ytFile = new File(XDMUtils.getJarFile().getParentFile(), XDMUtils.detectOS() == 10 ? "youtube-dl.exe" : "youtube-dl");
        return ffFile.exists() && ytFile.exists();
    }

    public static String getClipBoardText() {
        try {
            return (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            Logger.log(e);
            return "";
        }
    }

    public static void browseURL(String url) {
        int os = XDMUtils.detectOS();
        if (os == 10) {
            WinUtils.browseURL(url);
        } else if (os == 30) {
            LinuxUtils.browseURL(url);
        } else if (os == 20) {
            MacUtils.browseURL(url);
        }
    }

    public static boolean below7() {
        try {
            int version = Integer.parseInt(System.getProperty("os.version").split("\\.")[0]);
            return version < 6;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getDownloadsFolder() {
        String path;
        if (XDMUtils.detectOS() == 30 && (path = LinuxUtils.getXDGDownloaDir()) != null) {
            return path;
        }
        return new File(System.getProperty("user.home"), "Downloads").getAbsolutePath();
    }

    public static boolean isFFmpegInstalled() {
        File f1 = new File(Config.getInstance().getDataFolder(), "ffmpeg" + (XDMUtils.detectOS() == 10 ? ".exe" : ""));
        if (f1.exists()) {
            return true;
        }
        return new File(XDMUtils.getJarFile().getParentFile(), "ffmpeg" + (XDMUtils.detectOS() == 10 ? ".exe" : "")).exists();
    }

    public static boolean isMacPopupTrigger(MouseEvent e) {
        if (XDMUtils.detectOS() == 20) {
            return (e.getModifiers() & 0x10) != 0 && (e.getModifiers() & 2) != 0;
        }
        return false;
    }

    public static void mkdirs(String folder) {
        File outFolder = new File(folder);
        if (!outFolder.exists()) {
            outFolder.mkdirs();
        }
    }
}

