/*
 * Decompiled with CFR 0.152.
 */
package xdman.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.tukaani.xz.XZInputStream;
import xdman.Config;
import xdman.DownloadListener;
import xdman.DownloadWindowListener;
import xdman.downloaders.http.HttpDownloader;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.ui.components.DownloadWindow;
import xdman.ui.components.FFmpegExtractorWnd;
import xdman.util.FFExtractCallback;
import xdman.util.Logger;
import xdman.util.XDMUtils;

public class FFmpegDownloader
implements DownloadListener,
DownloadWindowListener,
FFExtractCallback {
    HttpDownloader d;
    DownloadWindow wnd;
    String url = "http://xdman.sourceforge.net/components/";
    String tmpFile;
    boolean stop;
    FFmpegExtractorWnd wnd2;

    public FFmpegDownloader() {
        if (XDMUtils.detectOS() == 10) {
            this.url = XDMUtils.below7() ? String.valueOf(this.url) + "xp.zip.xz" : String.valueOf(this.url) + "win.zip.xz";
        } else if (XDMUtils.detectOS() == 20) {
            this.url = String.valueOf(this.url) + "mac.zip.xz";
        } else if (XDMUtils.detectOS() == 30) {
            this.url = XDMUtils.getOsArch() == 32 ? String.valueOf(this.url) + "linux86.zip.xz" : String.valueOf(this.url) + "linux64.zip.xz";
        }
        this.tmpFile = UUID.randomUUID().toString();
    }

    public void start() {
        HttpMetadata metadata = new HttpMetadata();
        metadata.setUrl(this.url);
        System.out.println(this.url);
        this.d = new HttpDownloader(metadata.getId(), Config.getInstance().getTemporaryFolder(), metadata);
        this.d.registerListener(this);
        this.d.start();
        this.wnd = new DownloadWindow(metadata.getId(), this);
        this.wnd.setVisible(true);
    }

    @Override
    public void downloadFinished(String id) {
        this.extractFFmpeg();
        this.wnd.close(100, 0);
    }

    @Override
    public void downloadFailed(String id) {
        this.wnd.close(140, this.d.getErrorCode());
        this.deleteTmpFiles(id);
    }

    @Override
    public void downloadStopped(String id) {
        this.wnd.close(130, 0);
        this.deleteTmpFiles(id);
    }

    @Override
    public void downloadConfirmed(String id) {
    }

    @Override
    public void downloadUpdated(String id) {
        this.wnd.update(this.d, "Components");
    }

    @Override
    public String getOutputFolder(String id) {
        return Config.getInstance().getTemporaryFolder();
    }

    @Override
    public String getOutputFile(String id, boolean update) {
        return this.tmpFile;
    }

    @Override
    public void pauseDownload(String id) {
        if (this.d != null) {
            this.d.stop();
            this.d.unregisterListener();
        }
    }

    @Override
    public void hidePrgWnd(String id) {
    }

    private void deleteTmpFiles(String id) {
        Logger.log("Deleting metadata for " + id);
        File mf = new File(Config.getInstance().getMetadataFolder(), id);
        boolean deleted = mf.delete();
        Logger.log("Deleted manifest " + id + " " + deleted);
        File df = new File(Config.getInstance().getTemporaryFolder(), id);
        File[] files = df.listFiles();
        if (files != null && files.length > 0) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                deleted = f.delete();
                Logger.log("Deleted tmp file " + id + " " + deleted);
                ++n2;
            }
        }
        deleted = df.delete();
        Logger.log("Deleted tmp folder " + id + " " + deleted);
    }

    private void extractFFmpeg() {
        ZipInputStream zipIn = null;
        OutputStream out = null;
        this.wnd2 = new FFmpegExtractorWnd(this);
        this.wnd2.setVisible(true);
        try {
            try {
                ZipEntry ent;
                File input = new File(Config.getInstance().getTemporaryFolder(), this.tmpFile);
                zipIn = new ZipInputStream(new XZInputStream(new FileInputStream(input)));
                while ((ent = zipIn.getNextEntry()) != null) {
                    int x;
                    String name = ent.getName();
                    File outFile = new File(Config.getInstance().getDataFolder(), name);
                    out = new FileOutputStream(outFile);
                    byte[] buf = new byte[8192];
                    while ((x = zipIn.read(buf)) != -1) {
                        out.write(buf, 0, x);
                    }
                    out.close();
                    out = null;
                    outFile.setExecutable(true);
                }
                input.delete();
                this.wnd2.dispose();
            }
            catch (Exception e) {
                Logger.log(e);
                try {
                    zipIn.close();
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e2) {
                    Logger.log(e2);
                }
            }
        }
        finally {
            try {
                zipIn.close();
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                Logger.log(e);
            }
        }
    }

    @Override
    public void stop() {
        if (this.wnd2 != null) {
            this.wnd2.dispose();
        }
    }
}

