/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.laf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import xdman.ui.components.CustomButton;
import xdman.ui.components.DarkScrollBar;
import xdman.ui.res.ImageResource;

public class XDMScrollBarUI
extends BasicScrollBarUI {
    Color roColor1 = new Color(170, 170, 170);
    Color roColor2;
    Color barColor1 = new Color(215, 215, 215);
    Color barColor2;
    Color trackColor1 = new Color(240, 240, 240);
    Color trackColor2;
    boolean darkMode = false;

    public static ComponentUI createUI(JComponent c) {
        return new XDMScrollBarUI();
    }

    public XDMScrollBarUI() {
        this.roColor2 = new Color(160, 160, 160);
        this.barColor2 = new Color(130, 130, 130);
        this.trackColor2 = new Color(70, 70, 70);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.darkMode = this.scrollbar instanceof DarkScrollBar;
        if (this.scrollbar.getOrientation() == 0) {
            c.setPreferredSize(new Dimension(15, this.darkMode ? 8 : 15));
        } else {
            c.setPreferredSize(new Dimension(this.darkMode ? 8 : 15, 15));
        }
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        int w = thumbBounds.width;
        int h = thumbBounds.height;
        g.translate(thumbBounds.x, thumbBounds.y);
        Graphics2D g2 = (Graphics2D)g;
        if (this.isThumbRollover()) {
            g2.setColor(this.darkMode ? this.roColor2 : this.roColor1);
        } else {
            g2.setColor(this.darkMode ? this.barColor2 : this.barColor1);
        }
        g.fillRect(0, 0, w, h);
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle r) {
        g.setColor(this.darkMode ? this.trackColor2 : this.trackColor1);
        g.translate(r.x, r.y);
        g.fillRect(0, 0, r.width, r.height);
        g.translate(-r.x, -r.y);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return this.createScrollButton(orientation);
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return this.createScrollButton(orientation);
    }

    protected JButton createZeroButton() {
        JButton button = new JButton();
        Dimension zeroDim = new Dimension(0, 0);
        button.setPreferredSize(zeroDim);
        button.setMinimumSize(zeroDim);
        button.setMaximumSize(zeroDim);
        return button;
    }

    private JButton createScrollButton(int orientation) {
        this.darkMode = this.scrollbar instanceof DarkScrollBar;
        if (this.darkMode) {
            return this.createZeroButton();
        }
        CustomButton btn = new CustomButton();
        btn.setBackground(this.darkMode ? this.trackColor2 : this.trackColor1);
        btn.setContentAreaFilled(false);
        btn.setHorizontalAlignment(0);
        btn.setMargin(new Insets(0, 0, 0, 0));
        btn.setBorderPainted(false);
        if (orientation == 1) {
            btn.setIcon(ImageResource.get("up_arrow.png"));
            btn.setPreferredSize(new Dimension(15, 18));
        }
        if (orientation == 5) {
            btn.setIcon(ImageResource.get("down_arrow.png"));
            btn.setPreferredSize(new Dimension(15, 18));
        }
        if (orientation == 3) {
            btn.setIcon(ImageResource.get("right_arrow.png"));
            btn.setPreferredSize(new Dimension(18, 15));
        }
        if (orientation == 7) {
            btn.setIcon(ImageResource.get("left_arrow.png"));
            btn.setPreferredSize(new Dimension(18, 15));
        }
        return btn;
    }
}

