/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import xdman.DownloadEntry;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.util.FormatUtilities;

public class XDMTableCellRenderer
implements TableCellRenderer {
    JLabel iconLbl;
    JLabel titleLbl = new JLabel("This is sample title text");
    JLabel statLbl;
    JLabel dateLbl;
    JLabel lineLbl;
    JPanel pcell;

    public XDMTableCellRenderer() {
        this.titleLbl.setForeground(Color.BLACK);
        this.iconLbl = new JLabel();
        this.iconLbl.setForeground(Color.BLACK);
        this.statLbl = new JLabel("This is sample status text");
        this.statLbl.setForeground(Color.BLACK);
        this.dateLbl = new JLabel("Yesterday");
        this.dateLbl.setForeground(Color.BLACK);
        this.lineLbl = new JLabel();
        this.iconLbl.setOpaque(false);
        this.iconLbl.setPreferredSize(new Dimension(56, 56));
        this.iconLbl.setIcon(ImageResource.get("doc.png"));
        this.titleLbl.setBackground(Color.WHITE);
        this.titleLbl.setFont(FontResource.getItemFont());
        this.titleLbl.setOpaque(false);
        this.statLbl.setBackground(Color.WHITE);
        this.statLbl.setFont(FontResource.getNormalFont());
        this.statLbl.setOpaque(false);
        this.dateLbl.setBackground(Color.WHITE);
        this.dateLbl.setOpaque(false);
        this.dateLbl.setFont(FontResource.getNormalFont());
        this.lineLbl = new JLabel();
        this.lineLbl.setBackground(ColorResource.getWhite());
        this.lineLbl.setOpaque(true);
        this.lineLbl.setMinimumSize(new Dimension(10, 1));
        this.lineLbl.setMaximumSize(new Dimension(this.lineLbl.getMaximumSize().width, 1));
        this.lineLbl.setPreferredSize(new Dimension(this.lineLbl.getPreferredSize().width, 1));
        this.pcell = new JPanel(new BorderLayout());
        this.pcell.setBackground(Color.WHITE);
        this.pcell.add((Component)this.iconLbl, "West");
        Box box = Box.createHorizontalBox();
        box.add(this.statLbl);
        box.add(Box.createHorizontalGlue());
        box.add(this.dateLbl);
        box.setBorder(new EmptyBorder(0, 0, 10, 0));
        JPanel p = new JPanel(new BorderLayout());
        p.setOpaque(false);
        p.add(this.titleLbl);
        p.add((Component)box, "South");
        p.setBorder(new EmptyBorder(5, 0, 5, 5));
        this.pcell.add(p);
        this.pcell.add((Component)this.lineLbl, "South");
        this.pcell.setBorder(new EmptyBorder(0, 15, 0, 15));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        DownloadEntry ent = (DownloadEntry)value;
        this.titleLbl.setText(ent.getFile());
        this.dateLbl.setText(ent.getDateStr());
        this.statLbl.setText(FormatUtilities.getFormattedStatus(ent));
        if (isSelected) {
            this.pcell.setBackground(ColorResource.getSelectionColor());
            this.lineLbl.setOpaque(false);
            this.titleLbl.setForeground(Color.WHITE);
            this.dateLbl.setForeground(Color.WHITE);
            this.statLbl.setForeground(Color.WHITE);
        } else {
            this.pcell.setBackground(Color.WHITE);
            this.lineLbl.setOpaque(true);
            this.titleLbl.setForeground(Color.BLACK);
            this.dateLbl.setForeground(Color.BLACK);
            this.statLbl.setForeground(Color.BLACK);
        }
        switch (ent.getCategory()) {
            case 10: {
                this.iconLbl.setIcon(ImageResource.get("doc.png"));
                break;
            }
            case 50: {
                this.iconLbl.setIcon(ImageResource.get("arc.png"));
                break;
            }
            case 20: {
                this.iconLbl.setIcon(ImageResource.get("program.png"));
                break;
            }
            case 40: {
                this.iconLbl.setIcon(ImageResource.get("music.png"));
                break;
            }
            case 30: {
                this.iconLbl.setIcon(ImageResource.get("video.png"));
                break;
            }
            default: {
                this.iconLbl.setIcon(ImageResource.get("other.png"));
            }
        }
        return this.pcell;
    }
}

