/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import xdman.mediaconversion.Format;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.util.StringUtils;

public class MediaFormatRender
implements ListCellRenderer<Format> {
    private JPanel component = new JPanel(new BorderLayout());
    private JLabel lbl;
    private JLabel lblVideoDet;

    public MediaFormatRender() {
        this.component.setBackground(ColorResource.getDarkerBgColor());
        this.component.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.lbl = new JLabel();
        this.lbl.setFont(FontResource.getBigFont());
        this.component.add(this.lbl);
        this.lblVideoDet = new JLabel();
        this.lblVideoDet.setOpaque(false);
        this.component.add((Component)this.lblVideoDet, "South");
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Format> list, Format value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.component.setBackground(ColorResource.getSelectionColor());
        } else {
            this.component.setBackground(ColorResource.getDarkerBgColor());
        }
        this.lbl.setText(value.getDesc().trim());
        StringBuilder buf = new StringBuilder();
        String vcodec = value.getDefautValue(value.getVideoCodecs(), value.getDefautVideoCodec());
        String acodec = value.getDefautValue(value.getAudioCodecs(), value.getDefautAudioCodec());
        String resolution = value.getDefautValue(value.getResolutions(), value.getDefaultResolution());
        if (!StringUtils.isNullOrEmptyOrBlank(resolution)) {
            buf.append(resolution);
        }
        if (!StringUtils.isNullOrEmptyOrBlank(vcodec)) {
            buf.append(buf.length() > 0 ? " / " : "");
            buf.append(vcodec);
        }
        if (!StringUtils.isNullOrEmptyOrBlank(acodec)) {
            buf.append(buf.length() > 0 ? " - " : "");
            buf.append(acodec);
        }
        if (buf.length() > 0) {
            this.lblVideoDet.setText(buf.toString());
        }
        return this.component;
    }
}

