/*
 * Decompiled with CFR 0.152.
 */
package xdman.preview;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import xdman.DownloadEntry;
import xdman.XDMApp;
import xdman.preview.Chunk;
import xdman.preview.ChunkComparator;

public class ChunkLoader {
    static List<Chunk> load(String id, int type) {
        if (type == 1000) {
            return ChunkLoader.loadHttp(id);
        }
        if (type == 1003) {
            return ChunkLoader.loadDash(id);
        }
        if (type == 1001) {
            return ChunkLoader.loadHLS(id);
        }
        return null;
    }

    private static List<Chunk> loadDash(String id) {
        System.out.println("loading http chunk " + id);
        ArrayList<Chunk> list = new ArrayList<Chunk>();
        BufferedReader br = null;
        try {
            DownloadEntry ent = XDMApp.getInstance().getEntry(id);
            if (ent == null) {
                return null;
            }
            String folder = ent.getTempFolder();
            File f = new File(folder, id);
            if (f.exists()) {
                f = new File(f.getAbsolutePath(), "state.txt");
            }
            if (f.exists()) {
                br = new BufferedReader(new FileReader(f));
            }
            br.readLine();
            br.readLine();
            br.readLine();
            br.readLine();
            int chunkCount = Integer.parseInt(br.readLine());
            int i = 0;
            while (i < chunkCount) {
                String cid = br.readLine();
                long len = Long.parseLong(br.readLine());
                long off = Long.parseLong(br.readLine());
                br.readLine();
                String tag = br.readLine();
                Chunk chunk = new Chunk();
                chunk.id = cid;
                chunk.length = len;
                chunk.startOff = off;
                chunk.tag = tag;
                list.add(chunk);
                ++i;
            }
            Collections.sort(list, new ChunkComparator());
            ArrayList<Chunk> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static List<Chunk> loadHLS(String id) {
        System.out.println("loading http chunk " + id);
        ArrayList<Chunk> list = new ArrayList<Chunk>();
        BufferedReader br = null;
        try {
            DownloadEntry ent = XDMApp.getInstance().getEntry(id);
            if (ent == null) {
                return null;
            }
            String folder = ent.getTempFolder();
            File f = new File(folder, id);
            if (f.exists()) {
                f = new File(f.getAbsolutePath(), "state.txt");
            }
            if (f.exists()) {
                br = new BufferedReader(new FileReader(f));
            }
            br.readLine();
            br.readLine();
            br.readLine();
            int urlCount = Integer.parseInt(br.readLine());
            int i = 0;
            while (i < urlCount) {
                br.readLine();
                ++i;
            }
            int chunkCount = Integer.parseInt(br.readLine());
            int i2 = 0;
            while (i2 < chunkCount) {
                String cid = br.readLine();
                long len = Long.parseLong(br.readLine());
                long off = Long.parseLong(br.readLine());
                br.readLine();
                Chunk chunk = new Chunk();
                chunk.id = cid;
                chunk.length = len;
                chunk.startOff = off;
                list.add(chunk);
                ++i2;
            }
            Collections.sort(list, new ChunkComparator());
            ArrayList<Chunk> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static List<Chunk> loadHttp(String id) {
        System.out.println("loading http chunk " + id);
        ArrayList<Chunk> list = new ArrayList<Chunk>();
        BufferedReader br = null;
        try {
            DownloadEntry ent = XDMApp.getInstance().getEntry(id);
            if (ent == null) {
                return null;
            }
            String folder = ent.getTempFolder();
            File f = new File(folder, id);
            if (f.exists()) {
                f = new File(f.getAbsolutePath(), "state.txt");
            }
            if (f.exists()) {
                br = new BufferedReader(new FileReader(f));
            }
            br.readLine();
            br.readLine();
            int chunkCount = Integer.parseInt(br.readLine());
            int i = 0;
            while (i < chunkCount) {
                String cid = br.readLine();
                long len = Long.parseLong(br.readLine());
                long off = Long.parseLong(br.readLine());
                br.readLine();
                Chunk chunk = new Chunk();
                chunk.id = cid;
                chunk.length = len;
                chunk.startOff = off;
                list.add(chunk);
                ++i;
            }
            Collections.sort(list, new ChunkComparator());
            ArrayList<Chunk> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

