/*
 * Decompiled with CFR 0.152.
 */
package xdman.network.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import xdman.network.ProxyResolver;
import xdman.network.http.HeaderCollection;
import xdman.network.http.HttpClient;
import xdman.network.http.HttpContext;
import xdman.network.http.HttpHeader;
import xdman.network.http.WebProxy;

public class JavaHttpClient
extends HttpClient {
    private HttpURLConnection hc;
    private boolean followRedirect = false;
    private String _url;
    private URL realURL;

    public JavaHttpClient(String url) {
        this._url = url;
        this.requestHeaders = new HeaderCollection();
        this.responseHeaders = new HeaderCollection();
    }

    @Override
    public void connect() throws IOException {
        URL url;
        HttpContext.getInstance().init();
        WebProxy webproxy = ProxyResolver.resolve(this._url);
        this.realURL = url = new URL(this._url);
        if (webproxy != null) {
            Proxy proxy = new Proxy(webproxy.isSocks() ? Proxy.Type.SOCKS : Proxy.Type.HTTP, new InetSocketAddress(webproxy.getHost(), webproxy.getPort()));
            this.hc = (HttpURLConnection)url.openConnection(proxy);
        } else {
            this.hc = (HttpURLConnection)url.openConnection();
        }
        Iterator<HttpHeader> headers = this.requestHeaders.getAll();
        while (headers.hasNext()) {
            HttpHeader header = headers.next();
            this.hc.addRequestProperty(header.getName(), header.getValue());
        }
        this.hc.setInstanceFollowRedirects(this.followRedirect);
        this.statusCode = this.hc.getResponseCode();
        this.statusMessage = this.hc.getResponseMessage();
        Map<String, List<String>> responseHeaderMap = this.hc.getHeaderFields();
        for (String key : responseHeaderMap.keySet()) {
            if (key == null) continue;
            List<String> headerValues = responseHeaderMap.get(key);
            for (String value : headerValues) {
                HttpHeader header = new HttpHeader(key, value);
                this.responseHeaders.addHeader(header);
            }
        }
    }

    public void setFollowRedirect(boolean followRedirect) {
        this.followRedirect = followRedirect;
    }

    @Override
    public long getContentLength() throws IOException {
        return this.hc.getContentLengthLong();
    }

    @Override
    public void dispose() {
        this.hc.disconnect();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.hc.getInputStream();
    }

    @Override
    public String getHost() {
        return String.valueOf(this.realURL.getHost()) + (this.realURL.getPort() > 0 ? ":" + this.realURL.getPort() : "");
    }
}

