/*
 * Decompiled with CFR 0.152.
 */
package xdman.downloaders.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import xdman.downloaders.AbstractChannel;
import xdman.downloaders.Segment;
import xdman.network.ftp.FtpClient;
import xdman.network.http.JavaClientRequiredException;
import xdman.util.Logger;
import xdman.util.XDMUtils;

public class FtpChannel
extends AbstractChannel {
    private String url;
    private FtpClient hc;
    private InputStream in;
    private boolean redirected;
    private String redirectUrl;
    private long length;

    public FtpChannel(Segment chunk, String url) {
        super(chunk);
        this.url = url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean connectImpl() {
        int sleepInterval = 0;
        boolean isRedirect = false;
        if (this.stop) {
            this.closeImpl();
            return false;
        }
        if (this.chunk.getLength() < 0L && this.chunk.getDownloaded() > 0L) {
            this.errorCode = 103;
            this.closeImpl();
            Logger.log("server does not support resuming");
            return false;
        }
        try {
            this.chunk.reopenStream();
        }
        catch (IOException e) {
            Logger.log(e);
            this.closeImpl();
            this.errorCode = 103;
            return false;
        }
        PasswordAuthentication passwd = new PasswordAuthentication("anonymous", "anonymous".toCharArray());
        while (!this.stop) {
            isRedirect = false;
            try {
                Logger.log("ftp Connecting to: " + this.url + " " + this.chunk.getTag() + " offset " + (this.chunk.getStartOffset() + this.chunk.getDownloaded()));
                this.hc = new FtpClient(this.url);
                long startOff = this.chunk.getStartOffset() + this.chunk.getDownloaded();
                if (startOff > 0L) {
                    this.hc.setOffset(startOff);
                }
                this.hc.setUser(passwd.getUserName());
                this.hc.setPassword(new String(passwd.getPassword()));
                this.hc.connect();
                if (this.stop) {
                    this.closeImpl();
                    return false;
                }
                int code = this.hc.getStatusCode();
                Logger.log(this.chunk + ": " + code);
                if (code != 200 && code != 206 && code != 416 && code != 413 && code != 401 && code != 408 && code != 407 && code != 503) {
                    this.errorCode = 100;
                    this.closeImpl();
                    return false;
                }
                if (code == 407 || code == 401) {
                    Logger.log("asking for password");
                    boolean proxy = code == 407;
                    passwd = Authenticator.requestPasswordAuthentication(null, this.hc.getPort(), "ftp", "", "ftp");
                    if (passwd == null) {
                        if (!this.chunk.promptCredential(this.hc.getHost(), proxy)) {
                            this.errorCode = 100;
                            this.closeImpl();
                            return false;
                        }
                        passwd = Authenticator.requestPasswordAuthentication(null, this.hc.getPort(), "ftp", "", "ftp");
                        Logger.log("Passwd: " + passwd);
                        throw new JavaClientRequiredException();
                    }
                }
                if (this.stop) {
                    this.closeImpl();
                    return false;
                }
                if (this.chunk.getDownloaded() + this.chunk.getStartOffset() > 0L && code != 206) {
                    this.closeImpl();
                    this.errorCode = 103;
                    return false;
                }
                this.length = this.hc.getContentLength();
                if (this.hc.getContentLength() > 0L && XDMUtils.getFreeSpace(null) < this.hc.getContentLength()) {
                    Logger.log("Disk is full");
                    this.errorCode = 133;
                    this.closeImpl();
                    return false;
                }
                this.in = this.hc.getInputStream();
                Logger.log("Connection success");
                return true;
            }
            catch (JavaClientRequiredException e) {
                sleepInterval = 0;
            }
            catch (Exception e) {
                Logger.log(this.chunk);
                Logger.log(e);
                if (isRedirect) {
                    this.closeImpl();
                    continue;
                }
                sleepInterval = 5000;
            }
            this.closeImpl();
            try {
                Thread.sleep(sleepInterval);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Logger.log("return as " + this.errorCode);
        return false;
    }

    @Override
    protected InputStream getInputStreamImpl() {
        return this.in;
    }

    @Override
    protected long getLengthImpl() {
        return this.length;
    }

    @Override
    protected void closeImpl() {
        if (this.hc != null) {
            this.hc.dispose();
        }
    }

    public boolean isFinished() {
        return false;
    }

    public boolean isRedirected() {
        return this.redirected;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }
}

