/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.message.saaj;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.EntityReference;
import org.w3c.dom.ProcessingInstruction;

public class SaajStaxWriter
implements XMLStreamWriter {
    protected SOAPMessage soap;
    protected String envURI;
    protected SOAPElement currentElement;
    protected DeferredElement deferredElement;
    protected static final String Envelope = "Envelope";
    protected static final String Header = "Header";
    protected static final String Body = "Body";
    protected static final String xmlns = "xmlns";

    public SaajStaxWriter(SOAPMessage sOAPMessage) throws SOAPException {
        this.soap = sOAPMessage;
        this.currentElement = this.soap.getSOAPPart().getEnvelope();
        this.envURI = this.currentElement.getNamespaceURI();
        this.deferredElement = new DeferredElement();
    }

    public SOAPMessage getSOAPMessage() {
        return this.soap;
    }

    @Override
    public void writeStartElement(String string) throws XMLStreamException {
        this.currentElement = this.deferredElement.flushTo(this.currentElement);
        this.deferredElement.setLocalName(string);
    }

    @Override
    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.writeStartElement(null, string2, string);
    }

    @Override
    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.currentElement = this.deferredElement.flushTo(this.currentElement);
        if (this.envURI.equals(string3)) {
            try {
                if (Envelope.equals(string2)) {
                    this.currentElement = this.soap.getSOAPPart().getEnvelope();
                    this.fixPrefix(string);
                    return;
                }
                if (Header.equals(string2)) {
                    this.currentElement = this.soap.getSOAPHeader();
                    this.fixPrefix(string);
                    return;
                }
                if (Body.equals(string2)) {
                    this.currentElement = this.soap.getSOAPBody();
                    this.fixPrefix(string);
                    return;
                }
            }
            catch (SOAPException sOAPException) {
                throw new XMLStreamException(sOAPException);
            }
        }
        this.deferredElement.setLocalName(string2);
        this.deferredElement.setNamespaceUri(string3);
        this.deferredElement.setPrefix(string);
    }

    private void fixPrefix(String string) throws XMLStreamException {
        String string2 = this.currentElement.getPrefix();
        if (string != null && !string.equals(string2)) {
            this.currentElement.setPrefix(string);
        }
    }

    @Override
    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.writeStartElement(null, string2, string);
    }

    @Override
    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.writeStartElement(string, string2, string3);
    }

    @Override
    public void writeEmptyElement(String string) throws XMLStreamException {
        this.writeStartElement(null, string, null);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.currentElement = this.deferredElement.flushTo(this.currentElement);
        if (this.currentElement != null) {
            this.currentElement = this.currentElement.getParentElement();
        }
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.currentElement = this.deferredElement.flushTo(this.currentElement);
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public void flush() throws XMLStreamException {
    }

    @Override
    public void writeAttribute(String string, String string2) throws XMLStreamException {
        this.writeAttribute(null, null, string, string2);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        if (string2 == null && string == null && xmlns.equals(string3)) {
            this.writeNamespace("", string4);
        } else if (this.deferredElement.isInitialized()) {
            this.deferredElement.addAttribute(string, string2, string3, string4);
        } else {
            SaajStaxWriter.addAttibuteToElement(this.currentElement, string, string2, string3, string4);
        }
    }

    @Override
    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        this.writeAttribute(null, string, string2, string3);
    }

    @Override
    public void writeNamespace(String string, String string2) throws XMLStreamException {
        String string3;
        String string4 = string3 = string == null || xmlns.equals(string) ? "" : string;
        if (this.deferredElement.isInitialized()) {
            this.deferredElement.addNamespaceDeclaration(string3, string2);
        } else {
            try {
                this.currentElement.addNamespaceDeclaration(string3, string2);
            }
            catch (SOAPException sOAPException) {
                throw new XMLStreamException(sOAPException);
            }
        }
    }

    @Override
    public void writeDefaultNamespace(String string) throws XMLStreamException {
        this.writeNamespace("", string);
    }

    @Override
    public void writeComment(String string) throws XMLStreamException {
        this.currentElement = this.deferredElement.flushTo(this.currentElement);
        Comment comment = this.soap.getSOAPPart().createComment(string);
        this.currentElement.appendChild(comment);
    }

    @Override
    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.currentElement = this.deferredElement.flushTo(this.currentElement);
        ProcessingInstruction processingInstruction = this.soap.getSOAPPart().createProcessingInstruction(string, "");
        this.currentElement.appendChild(processingInstruction);
    }

    @Override
    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        this.currentElement = this.deferredElement.flushTo(this.currentElement);
        ProcessingInstruction processingInstruction = this.soap.getSOAPPart().createProcessingInstruction(string, string2);
        this.currentElement.appendChild(processingInstruction);
    }

    @Override
    public void writeCData(String string) throws XMLStreamException {
        this.currentElement = this.deferredElement.flushTo(this.currentElement);
        CDATASection cDATASection = this.soap.getSOAPPart().createCDATASection(string);
        this.currentElement.appendChild(cDATASection);
    }

    @Override
    public void writeDTD(String string) throws XMLStreamException {
        this.currentElement = this.deferredElement.flushTo(this.currentElement);
    }

    @Override
    public void writeEntityRef(String string) throws XMLStreamException {
        this.currentElement = this.deferredElement.flushTo(this.currentElement);
        EntityReference entityReference = this.soap.getSOAPPart().createEntityReference(string);
        this.currentElement.appendChild(entityReference);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
    }

    @Override
    public void writeStartDocument(String string) throws XMLStreamException {
        if (string != null) {
            this.soap.getSOAPPart().setXmlVersion(string);
        }
    }

    @Override
    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        if (string2 != null) {
            this.soap.getSOAPPart().setXmlVersion(string2);
        }
        if (string != null) {
            try {
                this.soap.setProperty("javax.xml.soap.character-set-encoding", string);
            }
            catch (SOAPException sOAPException) {
                throw new XMLStreamException(sOAPException);
            }
        }
    }

    @Override
    public void writeCharacters(String string) throws XMLStreamException {
        this.currentElement = this.deferredElement.flushTo(this.currentElement);
        try {
            this.currentElement.addTextNode(string);
        }
        catch (SOAPException sOAPException) {
            throw new XMLStreamException(sOAPException);
        }
    }

    @Override
    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.currentElement = this.deferredElement.flushTo(this.currentElement);
        char[] cArray2 = n == 0 && n2 == cArray.length ? cArray : Arrays.copyOfRange(cArray, n, n + n2);
        try {
            this.currentElement.addTextNode(new String(cArray2));
        }
        catch (SOAPException sOAPException) {
            throw new XMLStreamException(sOAPException);
        }
    }

    @Override
    public String getPrefix(String string) throws XMLStreamException {
        return this.currentElement.lookupPrefix(string);
    }

    @Override
    public void setPrefix(String string, String string2) throws XMLStreamException {
        if (!this.deferredElement.isInitialized()) {
            throw new XMLStreamException("Namespace not associated with any element");
        }
        this.deferredElement.addNamespaceDeclaration(string, string2);
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.setPrefix("", string);
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        if ("javax.xml.stream.isRepairingNamespaces".equals(string)) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return new NamespaceContext(){

            @Override
            public String getNamespaceURI(String string) {
                return SaajStaxWriter.this.currentElement.getNamespaceURI(string);
            }

            @Override
            public String getPrefix(String string) {
                return SaajStaxWriter.this.currentElement.lookupPrefix(string);
            }

            @Override
            public Iterator getPrefixes(final String string) {
                return new Iterator<String>(){
                    String prefix;
                    {
                        this.prefix = this.getPrefix(string);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.prefix != null;
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        String string2 = this.prefix;
                        this.prefix = null;
                        return string2;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    static void addAttibuteToElement(SOAPElement sOAPElement, String string, String string2, String string3, String string4) throws XMLStreamException {
        try {
            if (string2 == null) {
                sOAPElement.setAttributeNS("", string3, string4);
            } else {
                QName qName = string == null ? new QName(string2, string3) : new QName(string2, string3, string);
                sOAPElement.addAttribute(qName, string4);
            }
        }
        catch (SOAPException sOAPException) {
            throw new XMLStreamException(sOAPException);
        }
    }

    static class AttributeDeclaration {
        final String prefix;
        final String namespaceUri;
        final String localName;
        final String value;

        AttributeDeclaration(String string, String string2, String string3, String string4) {
            this.prefix = string;
            this.namespaceUri = string2;
            this.localName = string3;
            this.value = string4;
        }
    }

    static class DeferredElement {
        private String prefix;
        private String localName;
        private String namespaceUri;
        private final List<NamespaceDeclaration> namespaceDeclarations = new LinkedList<NamespaceDeclaration>();
        private final List<AttributeDeclaration> attributeDeclarations = new LinkedList<AttributeDeclaration>();

        DeferredElement() {
            this.reset();
        }

        public void setPrefix(String string) {
            this.prefix = string;
        }

        public void setLocalName(String string) {
            if (string == null) {
                throw new IllegalArgumentException("localName can not be null");
            }
            this.localName = string;
        }

        public void setNamespaceUri(String string) {
            this.namespaceUri = string;
        }

        public void addNamespaceDeclaration(String string, String string2) {
            if (null == this.namespaceUri && null != string2 && string.equals(DeferredElement.emptyIfNull(this.prefix))) {
                this.namespaceUri = string2;
            }
            this.namespaceDeclarations.add(new NamespaceDeclaration(string, string2));
        }

        public void addAttribute(String string, String string2, String string3, String string4) {
            if (string2 == null && string == null && SaajStaxWriter.xmlns.equals(string3)) {
                this.addNamespaceDeclaration(string, string4);
            } else {
                this.attributeDeclarations.add(new AttributeDeclaration(string, string2, string3, string4));
            }
        }

        public SOAPElement flushTo(SOAPElement sOAPElement) throws XMLStreamException {
            try {
                if (this.localName != null) {
                    SOAPElement sOAPElement2 = this.namespaceUri == null ? sOAPElement.addChildElement(this.localName) : (this.prefix == null ? sOAPElement.addChildElement(new QName(this.namespaceUri, this.localName)) : sOAPElement.addChildElement(this.localName, this.prefix, this.namespaceUri));
                    for (NamespaceDeclaration object : this.namespaceDeclarations) {
                        sOAPElement.addNamespaceDeclaration(object.prefix, object.namespaceUri);
                    }
                    for (AttributeDeclaration attributeDeclaration : this.attributeDeclarations) {
                        SaajStaxWriter.addAttibuteToElement(sOAPElement2, attributeDeclaration.prefix, attributeDeclaration.namespaceUri, attributeDeclaration.localName, attributeDeclaration.value);
                    }
                    this.reset();
                    return sOAPElement2;
                }
                return sOAPElement;
            }
            catch (SOAPException sOAPException) {
                throw new XMLStreamException(sOAPException);
            }
        }

        public boolean isInitialized() {
            return this.localName != null;
        }

        private void reset() {
            this.localName = null;
            this.prefix = null;
            this.namespaceUri = null;
            this.namespaceDeclarations.clear();
            this.attributeDeclarations.clear();
        }

        private static String emptyIfNull(String string) {
            return string == null ? "" : string;
        }
    }

    static class NamespaceDeclaration {
        final String prefix;
        final String namespaceUri;

        NamespaceDeclaration(String string, String string2) {
            this.prefix = string;
            this.namespaceUri = string2;
        }
    }
}

