/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.reflect.opt;

import com.sun.xml.internal.bind.Util;
import com.sun.xml.internal.bind.v2.bytecode.ClassTailor;
import com.sun.xml.internal.bind.v2.runtime.reflect.opt.Injector;
import com.sun.xml.internal.bind.v2.runtime.reflect.opt.SecureLoader;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class AccessorInjector {
    private static final Logger logger = Util.getClassLogger();
    protected static final boolean noOptimize;
    private static final ClassLoader CLASS_LOADER;

    AccessorInjector() {
    }

    public static Class<?> prepare(Class clazz, String string, String string2, String ... stringArray) {
        if (noOptimize) {
            return null;
        }
        try {
            ClassLoader classLoader = SecureLoader.getClassClassLoader(clazz);
            if (classLoader == null) {
                return null;
            }
            Class clazz2 = Injector.find(classLoader, string2);
            if (clazz2 == null) {
                byte[] byArray = AccessorInjector.tailor(string, string2, stringArray);
                if (byArray == null) {
                    return null;
                }
                clazz2 = Injector.inject(classLoader, string2, byArray);
                if (clazz2 == null) {
                    Injector.find(classLoader, string2);
                }
            }
            return clazz2;
        }
        catch (SecurityException securityException) {
            logger.log(Level.INFO, "Unable to create an optimized TransducedAccessor ", securityException);
            return null;
        }
    }

    private static byte[] tailor(String string, String string2, String ... stringArray) {
        InputStream inputStream = CLASS_LOADER != null ? CLASS_LOADER.getResourceAsStream(string + ".class") : ClassLoader.getSystemResourceAsStream(string + ".class");
        if (inputStream == null) {
            return null;
        }
        return ClassTailor.tailor(inputStream, string, string2, stringArray);
    }

    static {
        boolean bl = noOptimize = Util.getSystemProperty(ClassTailor.class.getName() + ".noOptimize") != null;
        if (noOptimize) {
            logger.info("The optimized code generation is disabled");
        }
        CLASS_LOADER = SecureLoader.getClassClassLoader(AccessorInjector.class);
    }
}

