/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.proxy;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.zip.GZIPInputStream;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.core.common.http.XDMHttpClient;
import org.sdg.xdman.core.common.http.io.ChunkedInputStream;
import org.sdg.xdman.gui.MediaInfo;
import org.sdg.xdman.gui.MediaTableModel;
import org.sdg.xdman.plugin.firefox.FFPluginBuilder;
import org.sdg.xdman.plugin.youtube.JSONParser;
import org.sdg.xdman.proxy.IConnection;
import org.sdg.xdman.proxy.IConnectionListener;
import org.sdg.xdman.proxy.RequestIntercepter;
import org.sdg.xdman.proxy.UAList;
import org.sdg.xdman.proxy.XDMHelper;
import org.sdg.xdman.proxy.XDMProxyServer;
import org.sdg.xdman.util.XDMUtil;

public class RequestHandler
extends Observable
implements Runnable,
IConnection {
    String error = "HTTP/1.1 502 Bad Gateway\r\n\r\nERROR";
    MediaTableModel model;
    Socket socket;
    InputStream in;
    InputStream remoteIn;
    OutputStream out;
    OutputStream remoteOut;
    String requestLine;
    String url;
    String responseLine;
    URL uri;
    Socket remote;
    HashMap<String, String> requestHeader;
    HashMap<String, String> responseHeader;
    Thread t;
    String host;
    String path;
    String query;
    int port;
    byte[] b;
    XDMConfig config;
    StringBuffer cookies = new StringBuffer();
    StringBuffer serverCookie = new StringBuffer();
    RequestIntercepter intercepter;
    public Boolean intercept = false;
    long dwn;
    String type = "GET";
    IConnectionListener cl;
    boolean stop = false;
    public ArrayList<String> blockedHosts;
    public ArrayList<String> skippedHosts;
    String proxy_pac = "function FindProxyForURL(url, host){var proxy_yes = \"PROXY 127.0.0.1:9614; DIRECT\";if(url.indexOf(\"http://\")==0)return proxy_yes; else return \"DIRECT\";}";

    void start() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void run() {
        try {
            this.handleRequest();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.cl != null) {
            this.cl.closed(this);
        }
    }

    private void handleRequest() throws IOException, URISyntaxException {
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
        this.requestLine = this.readLine(this.in);
        System.out.println("***********************************HANDLING REQUEST*****************************");
        System.out.println(this.socket);
        if (this.requestLine.startsWith("XDM_HELPER 9614")) {
            XDMHelper.helperInit(this.out);
            System.out.println(XDMHelper.setProxy());
            return;
        }
        if (this.requestLine.startsWith("PARAM")) {
            String ln22;
            HashMap<String, String> arg = new HashMap<String, String>();
            while ((ln22 = this.readLine(this.in)) != null && ln22.length() >= 1) {
                System.out.println("PARAM_LINE: " + ln22 + " " + ln22.length());
                int pos = ln22.indexOf(":");
                if (pos <= 0) continue;
                String key = ln22.substring(0, pos).trim();
                String value = ln22.substring(pos + 1).trim();
                arg.put(key, value);
            }
            if (this.intercepter != null && arg.size() > 0) {
                this.intercepter.intercept(arg);
            }
            try {
                this.socket.close();
            }
            catch (Exception ln22) {
                // empty catch block
            }
            return;
        }
        System.out.println("REQUEST LINE: " + this.requestLine);
        if (this.requestLine.length() < 1) {
            this.in.close();
            this.out.close();
            return;
        }
        String[] arr = this.requestLine.split(" ");
        if (arr.length < 1) {
            this.in.close();
            this.out.close();
            return;
        }
        this.url = arr[1];
        this.url = this.url.trim();
        System.out.println("**************************URL: " + this.url);
        if (this.url.equals("/proxy.pac")) {
            String line;
            while ((line = this.readLine(this.in)) != null && line.length() >= 1) {
                String ua;
                if (!line.toLowerCase().startsWith("user-agent") || !XDMProxyServer.browsers.add(UAList.getBrowser(ua = line.substring(line.indexOf(58)).trim()))) continue;
                this.setChanged();
                this.notifyObservers(XDMProxyServer.browsers);
            }
            this.out.write("HTTP/1.0 200 OK\r\nContent-Type: application/x-ns-proxy-autoconfig\r\n\r\n".getBytes());
            this.out.write(this.proxy_pac.getBytes());
            this.out.close();
            this.in.close();
            this.socket.close();
            return;
        }
        if (this.url.startsWith("/")) {
            System.out.println("SELF#########################################");
            this.handleLocalRequest(this.url);
            this.out.close();
            this.in.close();
            this.socket.close();
            return;
        }
        if (this.url.startsWith("http://localhost:" + this.config.port)) {
            this.handleLocalRequest(new URL(this.url).getPath());
            this.out.close();
            this.in.close();
            this.socket.close();
            return;
        }
        this.resolveURI(this.url);
        try {
            this.connectToHost();
        }
        catch (Exception e) {
            try {
                OutputStream out = this.socket.getOutputStream();
                out.write(this.error.getBytes());
                out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException(e.getMessage());
        }
        if (this.requestLine.startsWith("GET ") || this.requestLine.startsWith("HEAD")) {
            this.handleGET();
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
        } else if (this.requestLine.startsWith("POST")) {
            this.handlePOST();
            this.handleGET();
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
        } else {
            throw new IOException("Invalid method: " + this.requestLine);
        }
    }

    private void handleLocalRequest(String url2) {
        try {
            int x;
            System.out.println("Fetching resource: " + url2);
            System.out.println("Local PATH: " + url2);
            if (url2.equals("/flv")) {
                String line;
                ArrayList<String> flvList = new ArrayList<String>();
                while ((line = this.readLine(this.in)) != null && line.length() >= 2) {
                    System.out.println("LINK: " + line);
                    if (!line.toLowerCase().startsWith("link")) continue;
                    String link = line.substring(line.indexOf(":") + 1);
                    flvList.add(link.trim());
                }
                if (this.intercepter != null) {
                    this.intercepter.intercept(flvList);
                    this.out.write("HTTP/1.1 200 OK\r\n\r\n".getBytes());
                    this.out.flush();
                }
                return;
            }
            if (url2.equals("/link")) {
                String line;
                while ((line = this.readLine(this.in)) != null && line.length() >= 2) {
                    System.out.println("LINK: " + line);
                    if (!line.toLowerCase().startsWith("link")) continue;
                    String link = line.substring(line.indexOf(":") + 1);
                    if (this.intercepter == null) continue;
                    this.intercepter.intercept(link.trim());
                    this.out.write("HTTP/1.1 200 OK\r\n\r\n".getBytes());
                    this.out.flush();
                }
                return;
            }
            if (url2.equals("/xdmff.xpi")) {
                ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
                try {
                    new FFPluginBuilder().buildXPI(bufOut, this.config.fileTypes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.out.write("HTTP/1.1 500 Internal Server Error\r\n\r\n".getBytes());
                    return;
                }
                System.out.println("Creating XPI on the fly...");
                this.out.write("HTTP/1.1 200 OK\r\n".getBytes());
                byte[] buffer = bufOut.toByteArray();
                this.out.write(("Content-Length: " + buffer.length + "\r\n").getBytes());
                this.out.write("Content-Type: application/x-xpinstall\r\n\r\n".getBytes());
                this.out.write(buffer);
                this.out.flush();
                System.out.println("XPI SENT...");
                this.out.close();
                return;
            }
            String line = null;
            String ua = null;
            if (url2.equals("/test")) {
                System.out.println("Checking for browser...");
                while ((line = this.readLine(this.in)) != null && line.length() >= 2) {
                    if (!line.toLowerCase().startsWith("user-agent")) continue;
                    int index = line.indexOf(":");
                    if (index <= -1) break;
                    ua = line.substring(index).trim();
                    break;
                }
                if (ua == null) {
                    this.out.write("HTTP/1.1 200 OK\r\nContent-type: text/html\r\n\r\n<h1>XDM can not capture downloads from this browser.</h1>".getBytes());
                } else if (XDMProxyServer.browsers.contains(UAList.getBrowser(ua))) {
                    this.out.write("HTTP/1.1 200 OK\r\nContent-type: text/html\r\n\r\n<h1>XDM can capture downloads from this browser.</h1>".getBytes());
                } else {
                    this.out.write("HTTP/1.1 200 OK\r\nContent-type: text/html\r\n\r\n<h1>XDM can not capture downloads from this browser.</h1>".getBytes());
                }
                return;
            }
            InputStream localIn = this.getClass().getResourceAsStream(url2);
            if (localIn == null) {
                throw new NullPointerException();
            }
            this.out.write("HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n".getBytes());
            while ((x = localIn.read()) != -1) {
                this.out.write(x);
            }
        }
        catch (Exception e) {
            try {
                this.out.write("HTTP/1.1 200 OK\r\n\r\nNot Found\r\n".getBytes());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handlePOST() throws IOException {
        try {
            int x;
            this.type = "POST";
            System.out.println("\n\nHANDLING POST REQUEST:: " + this.path + "\n");
            this.remoteOut.write(("POST " + this.path + " HTTP/1.0\r\n").getBytes());
            String line = null;
            StringBuffer buf = new StringBuffer();
            while ((line = this.readLine(this.in)) != null && line.length() >= 1) {
                System.out.println(line);
                int index = line.indexOf(":");
                String key = line.substring(0, index).trim();
                String value = line.substring(index + 1).trim();
                this.requestHeader.put(key.toLowerCase(), value);
                if (!key.equalsIgnoreCase("Accept-Encoding") && !key.equalsIgnoreCase("Proxy-Connection")) {
                    buf.append(String.valueOf(line) + "\r\n");
                }
                if (!key.toLowerCase().equals("user-agent") || !XDMProxyServer.browsers.add(UAList.getBrowser(value))) continue;
                this.setChanged();
                this.notifyObservers(XDMProxyServer.browsers);
            }
            if (this.cl != null) {
                this.cl.connected(this);
            }
            this.remoteOut.write((String.valueOf(buf.toString()) + "\r\n").getBytes());
            this.remoteOut.flush();
            int length = Integer.parseInt(this.requestHeader.get("content-length"));
            this.b = new byte[8192];
            int read = 0;
            while ((x = length - read > this.b.length ? this.in.read(this.b) : this.in.read(this.b, 0, length - read)) != -1) {
                this.remoteOut.write(this.b, 0, x);
                this.dwn += (long)x;
                if (length != (read += x)) continue;
            }
            this.remoteOut.flush();
            this.responseLine = this.readLine(this.remoteIn);
            this.responseLine = this.responseLine.replace("HTTP/1.1", "HTTP/1.0");
            System.out.println(this.responseLine);
            this.out.write((String.valueOf(this.responseLine) + "\r\n").getBytes());
            while ((line = this.readLine(this.remoteIn)) != null && line.length() >= 1) {
                System.out.println(line);
                int index = line.indexOf(":");
                String key = line.substring(0, index).trim();
                String value = line.substring(index + 1).trim();
                this.responseHeader.put(key.toLowerCase(), value);
                this.out.write((String.valueOf(line) + "\r\n").getBytes());
            }
            if (this.cl != null) {
                this.cl.update(this);
            }
            this.out.write("connection: close\r\n\r\n".getBytes());
            this.out.flush();
            while (!this.stop) {
                x = this.remoteIn.read(this.b);
                if (x == -1) break;
                this.out.write(this.b, 0, x);
            }
            this.out.close();
            this.in.close();
            this.remoteIn.close();
            this.remoteOut.close();
            this.remote.close();
            this.socket.close();
        }
        catch (Exception err) {
            try {
                this.remoteIn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.remoteOut.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.remote.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.out.write(this.error.getBytes());
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException("Error handling POST: " + err);
        }
    }

    private void handleGET() throws UnknownHostException, IOException, URISyntaxException {
        try {
            String accept_encoding;
            int i;
            String value;
            String key;
            System.out.println("using http proxy: " + this.config.useHttpProxy);
            StringBuffer buf = new StringBuffer();
            if (this.requestLine.toUpperCase().startsWith("HEAD")) {
                this.type = "HEAD";
                buf.append("HEAD " + (this.config.useHttpProxy ? this.url : this.path) + " HTTP/1.1\r\n");
            } else {
                this.type = "GET";
                buf.append("GET " + (this.config.useHttpProxy ? this.url : this.path) + " HTTP/1.1\r\n");
            }
            System.out.println("\n\nHANDLING GET REQUEST: " + this.url + "\n");
            String line = null;
            while ((line = this.readLine(this.in)) != null && line.length() >= 1) {
                System.out.println(line);
                if (line.toLowerCase().startsWith("cookie")) {
                    this.cookies.append(String.valueOf(line) + "\r\n");
                }
                int index = line.indexOf(":");
                key = line.substring(0, index).trim();
                value = line.substring(index + 1).trim();
                if (!(key.equalsIgnoreCase("Accept-Encoding") || key.equalsIgnoreCase("Proxy-Connection") || key.equalsIgnoreCase("Connection"))) {
                    this.requestHeader.put(key.toLowerCase(), value);
                    buf.append(String.valueOf(line) + "\r\n");
                } else {
                    System.out.println("Skipping: " + key);
                }
                if (key.equalsIgnoreCase("accept-encoding")) {
                    String[] enc = value.split(",");
                    i = 0;
                    while (i < enc.length) {
                        String e = enc[i].trim();
                        if (e.equalsIgnoreCase("gzip")) {
                            this.requestHeader.put("accept-encoding", "gzip");
                        }
                        ++i;
                    }
                }
                if (key.toLowerCase().equals("user-agent") && XDMProxyServer.browsers.add(UAList.getBrowser(value))) {
                    this.setChanged();
                    this.notifyObservers(XDMProxyServer.browsers);
                }
                System.out.println("Key " + key);
            }
            if (this.config.compress && (accept_encoding = this.requestHeader.get("accept-encoding")) != null && accept_encoding.toLowerCase().indexOf("gzip") != -1) {
                buf.append("Accept-Encoding: gzip\r\n");
                this.requestHeader.put("accept-encoding", "gzip");
            }
            buf.append("Connection: close\r\n");
            if (this.config.useHttpProxy) {
                buf.append("Proxy-Connection: Keep-Alive\r\n");
            }
            if (this.cl != null) {
                this.cl.connected(this);
            }
            System.out.println("***********SENDING REQUEST: ************\n" + buf.toString() + "\r\n");
            this.remoteOut.write((String.valueOf(buf.toString()) + "\r\n").getBytes());
            this.remoteOut.flush();
            this.responseLine = this.readLine(this.remoteIn);
            buf = new StringBuffer();
            System.out.println(this.responseLine);
            buf.append(String.valueOf(this.responseLine) + "\r\n");
            while ((line = this.readLine(this.remoteIn)) != null && line.length() >= 1) {
                System.out.println(line);
                int index = line.indexOf(":");
                key = line.substring(0, index).trim();
                value = line.substring(index + 1).trim();
                this.responseHeader.put(key.toLowerCase(), value);
                buf.append(String.valueOf(line) + "\r\n");
                if (!line.toLowerCase().startsWith("set-cookie")) continue;
                this.serverCookie.append("cookie: " + value + "\r\n");
            }
            if (this.cl != null) {
                this.cl.update(this);
            }
            String type = this.responseHeader.get("content-type");
            System.out.println(type);
            String clen = this.responseHeader.get("content-length");
            int len = -1;
            if (clen != null) {
                try {
                    len = Integer.parseInt(clen);
                }
                catch (Exception enc) {
                    // empty catch block
                }
            }
            System.out.println("XDM_SKIP: " + this.requestHeader.get("xdm-skip"));
            if (type != null && this.requestHeader.get("xdm-skip") == null && !type.toLowerCase().startsWith("text/") && this.config != null) {
                boolean skip = false;
                if (this.skippedHosts != null) {
                    i = 0;
                    while (i < this.skippedHosts.size()) {
                        if (this.host.equals(this.skippedHosts.get(i))) {
                            skip = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (this.matchFileType() && !skip) {
                    if (this.requestHeader.get("range") == null) {
                        System.out.println("Rangle field is null so use this request");
                        XDMHttpClient client = new XDMHttpClient(this.config);
                        client.url = this.uri;
                        client.ua = this.requestHeader.get("user-agent");
                        client.in = this.createInStream(this.remoteIn);
                        client.sock = this.remote;
                        client.statusLine = this.responseLine;
                        client.header = this.responseHeader;
                        client.sendGet = true;
                        client.connected = true;
                        client.referer = this.requestHeader.get("referer");
                        client.cook = this.cookies.toString();
                        client.cookie = this.serverCookie;
                        client.requestHeader = this.requestHeader;
                        if (this.intercepter != null) {
                            this.intercepter.intercept(client, this);
                            if (this.intercept.booleanValue()) {
                                this.out.write("HTTP/1.0 204 No Content\r\n\r\n".getBytes());
                                this.in.close();
                                this.out.close();
                                this.socket.close();
                                return;
                            }
                            System.out.println("Dont intercept");
                        }
                    }
                } else if ((type.toLowerCase().startsWith("video/") || type.toLowerCase().startsWith("audio/")) && this.model != null) {
                    MediaInfo info = new MediaInfo();
                    info.referer = this.requestHeader.get("referer");
                    System.out.println("FLV REFERER: " + this.requestHeader.get("referer"));
                    info.name = XDMUtil.getFileName(this.uri.getPath());
                    info.url = this.uri.toString();
                    info.size = len < 0 ? "Unknown" : XDMUtil.getFormattedLength(len);
                    info.type = type;
                    this.model.add(info);
                }
            }
            System.out.println("Sending data back to browser==========================================================");
            buf.append("Proxy-Connection: close\r\n\r\n");
            this.out.write(buf.toString().getBytes());
            this.out.flush();
            this.b = new byte[8192];
            int read = 0;
            FileOutputStream yt_out = null;
            File tmpFile = null;
            if (this.url.startsWith("http://www.youtube.com/watch?v=")) {
                String fn = "yt_file_";
                int i2 = 0;
                tmpFile = new File(this.config.tempdir, String.valueOf(fn) + i2);
                while (tmpFile.exists()) {
                    tmpFile = new File(this.config.tempdir, String.valueOf(fn) + i2++);
                }
                yt_out = new FileOutputStream(tmpFile);
            }
            while (!this.stop) {
                int x = this.remoteIn.read(this.b);
                if (x == -1) break;
                this.out.write(this.b, 0, x);
                if (yt_out != null) {
                    yt_out.write(this.b, 0, x);
                }
                this.dwn += (long)x;
                if (len > 0 && (read += x) >= len) break;
            }
            this.out.close();
            if (yt_out != null) {
                yt_out.close();
                if (tmpFile != null) {
                    try {
                        FileInputStream yt_in = new FileInputStream(tmpFile);
                        JSONParser js = new JSONParser();
                        ArrayList<String> list = js.list(yt_in);
                        ((InputStream)yt_in).close();
                        if (list != null) {
                            int j = 0;
                            while (j < list.size()) {
                                String yt_url = list.get(j);
                                if (this.model != null) {
                                    MediaInfo info = new MediaInfo();
                                    info.referer = this.url;
                                    info.name = XDMUtil.getFileName(new URL(yt_url).getPath());
                                    info.url = yt_url;
                                    info.size = "Unknown";
                                    info.type = "Unknown";
                                    this.model.add(info);
                                }
                                ++j;
                            }
                        }
                    }
                    catch (Exception exx) {
                        tmpFile.delete();
                        exx.printStackTrace();
                    }
                }
            }
            this.in.close();
            this.remoteIn.close();
            this.remoteOut.close();
            this.remote.close();
            this.socket.close();
        }
        catch (Exception err) {
            err.printStackTrace();
            try {
                this.remoteIn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.remoteOut.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.remote.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.out.write(this.error.getBytes());
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException("Error handling GET: " + err);
        }
    }

    void readFullStream(InputStream in, int clen) throws Exception {
        byte[] buff = new byte[8192];
        int rem = clen;
        if (clen > 0) {
            int x;
            do {
                x = 0;
            } while ((x = rem < buff.length ? in.read(buff, 0, rem) : in.read(buff, 0, buff.length)) != -1 && (rem -= x) > 0);
        }
    }

    void connectToHost() throws UnknownHostException, IOException {
        System.out.println("REQUSET: " + this.requestLine);
        System.out.println("URI: " + this.uri);
        if (this.blockedHosts != null) {
            int i = 0;
            while (i < this.blockedHosts.size()) {
                if (this.host.equals(this.blockedHosts.get(i))) {
                    throw new IOException("Host is blocked");
                }
                ++i;
            }
        }
        this.remote = new Socket();
        this.remote.setTcpNoDelay(true);
        this.remote.setSoTimeout(this.config.timeout * 1000);
        this.remote.setReceiveBufferSize(this.config.tcpBuf);
        if (this.config.useHttpProxy) {
            this.remote.connect(new InetSocketAddress(this.config.httpProxyHost, this.config.httpProxyPort));
        } else {
            this.remote.connect(new InetSocketAddress(this.host, this.port));
        }
        this.remoteIn = this.remote.getInputStream();
        this.remoteOut = this.remote.getOutputStream();
        this.requestHeader = new HashMap();
        this.responseHeader = new HashMap();
    }

    void resolveURI(String u) throws MalformedURLException {
        u = u.trim();
        System.out.println("***************************Resolving uri: " + u);
        this.uri = new URL(u);
        System.out.println("URI IS:" + this.uri + " " + this.url);
        this.host = this.uri.getHost();
        this.port = this.uri.getPort();
        this.path = this.uri.getPath();
        this.query = this.uri.getQuery();
        System.out.println("HOST: " + this.host);
        System.out.println("PORT: " + this.port);
        if (!this.path.startsWith("/")) {
            this.path = "/" + this.path;
        }
        if (this.query != null) {
            this.path = String.valueOf(this.path) + "?" + this.query;
        }
        if (this.port < 0) {
            this.port = 80;
        }
    }

    String readLine(InputStream in) throws IOException {
        StringBuffer buf = new StringBuffer();
        int x;
        while ((x = in.read()) != -1) {
            if (x == 10) {
                return buf.toString();
            }
            if (x == 13) continue;
            buf.append((char)x);
        }
        return buf.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean matchFileType() {
        try {
            if (this.config == null) {
                return false;
            }
            String file = this.uri.getPath().toUpperCase();
            System.out.println("Matching: " + file);
            String[] type = this.config.fileTypes;
            int i = 0;
            while (true) {
                if (i >= type.length) {
                    System.out.println("Not Matched");
                    return false;
                }
                if (file.endsWith("." + type[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Not Matched: " + e.getMessage() + " " + e);
            e.printStackTrace();
            return false;
        }
    }

    InputStream createInStream(InputStream in) throws IOException {
        String tenc = this.responseHeader.get("transfer-encoding");
        InputStream in2 = in;
        if (tenc != null) {
            if (tenc.equalsIgnoreCase("chunked")) {
                in2 = new ChunkedInputStream(in);
            } else {
                throw new IOException("Transfer Encoding not supported: " + tenc);
            }
        }
        String enc = this.responseHeader.get("content-encoding");
        InputStream in3 = in2;
        if (enc != null) {
            if (enc.equalsIgnoreCase("gzip")) {
                in3 = new GZIPInputStream(in2);
            } else if (enc.equalsIgnoreCase("none")) {
                in3 = in2;
            } else {
                throw new IOException("Content Encoding not supported: " + enc);
            }
        }
        return in3;
    }

    public String getApplication() {
        if (this.requestHeader == null) {
            return "";
        }
        String ua = this.requestHeader.get("user-agent");
        if (ua == null) {
            return "Unknown";
        }
        return UAList.getBrowser(ua);
    }

    public String getContentLength() {
        if (this.responseHeader == null) {
            return "";
        }
        String len = this.responseHeader.get("content-length");
        if (len == null) {
            return "Unknown";
        }
        return len;
    }

    public String getContentType() {
        if (this.responseHeader == null) {
            return "";
        }
        String ct = this.responseHeader.get("content-type");
        if (ct == null) {
            return "Unknown";
        }
        return ct;
    }

    public String getDownloaded() {
        return String.valueOf(this.dwn) + " Bytes";
    }

    public String getHost() {
        return this.host;
    }

    public String getRequest() {
        if (this.requestHeader == null) {
            return "";
        }
        StringBuffer r = new StringBuffer();
        r.append(String.valueOf(this.requestLine) + "\r\n");
        for (String key : this.requestHeader.keySet()) {
            String val = this.requestHeader.get(key);
            r.append(String.valueOf(key) + ": " + val + "\r\n");
        }
        r.append(this.cookies + "\r\n");
        return r.toString();
    }

    public String getResponse() {
        if (this.responseHeader == null) {
            return "";
        }
        StringBuffer r = new StringBuffer();
        r.append(String.valueOf(this.responseLine) + "\r\n");
        for (String key : this.responseHeader.keySet()) {
            String val = this.responseHeader.get(key);
            r.append(String.valueOf(key) + ": " + val + "\r\n");
        }
        r.append(this.cookies + "\r\n");
        return r.toString();
    }

    public String getURL() {
        return this.url;
    }

    public String getHTTPTYPE() {
        return this.type;
    }

    public void stop() {
        this.stop = true;
    }
}

