/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.sdg.xdman.core.common.ConnectionManager;
import org.sdg.xdman.core.common.DownloadInfo;
import org.sdg.xdman.gui.IDownloadListener;
import org.sdg.xdman.gui.IconUtil;
import org.sdg.xdman.util.XDMUtil;

public class DownloadListItem
extends Observable
implements Observer,
Serializable {
    private static final long serialVersionUID = -4925098929484510725L;
    IDownloadListener listener;
    String cookies;
    String filename;
    boolean q;
    int state;
    String status;
    String timeleft;
    String transferrate;
    String lasttry;
    String description;
    String dateadded;
    String saveto;
    String type;
    String url;
    String size;
    String tempdir = "";
    transient ConnectionManager mgr;
    transient JFrame window;
    transient Icon icon;
    public HashMap<String, String> extra;

    void setCallback(ConnectionManager mgr, Observer o, IDownloadListener l) {
        this.mgr = mgr;
        mgr.addObserver(this);
        this.addObserver(o);
        this.listener = l;
    }

    public void update(Observable o, Object obj) {
        if (this.mgr == null) {
            return;
        }
        DownloadInfo info = (DownloadInfo)obj;
        this.status = info.status;
        this.timeleft = info.eta;
        this.transferrate = info.speed;
        this.url = info.url;
        this.size = info.length;
        this.type = info.category;
        this.state = info.state;
        if (info.state == 50 || info.state == 40 || info.state == 30) {
            this.mgr = null;
            this.window = null;
            System.out.println("removed connection mgr");
            if (info.state == 50) {
                this.q = false;
                this.status = "Download complete";
            } else {
                this.status = "Stopped";
            }
            if (this.listener != null) {
                this.listener.downloadStateChanged();
            }
            this.listener = null;
        }
        if (info.state == 70) {
            this.tempdir = info.tempdir;
            this.filename = info.file;
            this.icon = IconUtil.getIcon(XDMUtil.findCategory(this.filename));
            if (this.listener != null) {
                this.listener.downloadStateChanged();
            }
        }
        this.setChanged();
        this.notifyObservers(this);
    }

    public void setDest(String dest) {
        if (this.mgr != null) {
            this.saveto = dest;
            this.mgr.setDestdir(dest);
        }
    }
}

