/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import org.sdg.xdman.core.common.IXDMConstants;
import org.sdg.xdman.gui.DownloadListItem;
import org.sdg.xdman.gui.IDownloadListener;
import org.sdg.xdman.gui.IconUtil;
import org.sdg.xdman.util.XDMUtil;

public class DownloadList
implements IXDMConstants,
Serializable,
IDownloadListener {
    private static final long serialVersionUID = -3009294778243929872L;
    LinkedList<DownloadListItem> list = new LinkedList();
    String type;
    int state;
    String appdir;

    public DownloadList(String appdir) {
        this.appdir = appdir;
        this.loadDownloadList();
    }

    DownloadListItem get(int index) {
        if (this.type == null && this.state == 0) {
            return this.list.get(index);
        }
        int k = 0;
        int i = 0;
        while (i < this.list.size()) {
            DownloadListItem item = this.list.get(i);
            if (this.sameType(item.type) && this.sameState(item.state)) {
                if (k == index) {
                    return item;
                }
                ++k;
            }
            ++i;
        }
        return null;
    }

    void remove(DownloadListItem item) {
        this.list.remove(item);
    }

    void remove(int index) {
        if (this.type == null && this.state == 0) {
            this.list.remove(index);
        }
        int k = 0;
        int i = 0;
        while (i < this.list.size()) {
            DownloadListItem item = this.list.get(i);
            if (this.sameType(item.type) && this.sameState(item.state)) {
                if (k == index) {
                    this.list.remove(i);
                }
                ++k;
            }
            ++i;
        }
    }

    void add(DownloadListItem item) {
        this.list.add(item);
    }

    int size() {
        if (this.type == null && this.state == 0) {
            return this.list.size();
        }
        int k = 0;
        int i = 0;
        while (i < this.list.size()) {
            DownloadListItem item = this.list.get(i);
            if (this.sameType(item.type) && this.sameState(item.state)) {
                ++k;
            }
            ++i;
        }
        return k;
    }

    void setType(String type) {
        this.type = type;
    }

    void setState(int state) {
        this.state = state;
    }

    int getIndex(DownloadListItem item) {
        if (this.type == null && this.state == 0) {
            return this.list.indexOf(item);
        }
        int k = 0;
        int i = 0;
        while (i < this.list.size()) {
            DownloadListItem itm = this.list.get(i);
            if (this.sameType(itm.type) && this.sameState(itm.state)) {
                if (item.equals(itm)) {
                    return k;
                }
                ++k;
            }
            ++i;
        }
        return -1;
    }

    boolean sameType(String type) {
        if (this.type == null) {
            return true;
        }
        return this.type.equalsIgnoreCase(type);
    }

    boolean sameState(int state) {
        if (this.state == 0) {
            return true;
        }
        if (this.state == 50) {
            return this.state == state;
        }
        return state != 50;
    }

    public void downloadStateChanged() {
        this.saveDownloadList();
    }

    private synchronized void saveDownloadList() {
        System.out.println("Saving config...");
        ObjectOutputStream out = null;
        try {
            try {
                out = new ObjectOutputStream(new FileOutputStream(new File(this.appdir, ".xdmlist")));
                out.writeObject(this.list);
                System.out.println("Done");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    private void loadDownloadList() {
        block14: {
            ObjectInputStream in = null;
            try {
                try {
                    in = new ObjectInputStream(new FileInputStream(new File(this.appdir, ".xdmlist")));
                    this.list = (LinkedList)in.readObject();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.list == null) {
            this.list = new LinkedList();
        }
        int i = 0;
        while (i < this.list.size()) {
            DownloadListItem item = this.list.get(i);
            item.icon = IconUtil.getIcon(XDMUtil.findCategory(item.filename));
            if (item.state != 50 && item.state != 30) {
                item.state = 40;
                item.status = "Stopped";
            }
            ++i;
        }
    }
}

