/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.core.common.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.sdg.xdman.core.common.AuthenticationException;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.core.common.http.io.ChunkedInputStream;
import org.sdg.xdman.util.Base64;

public class XDMHttpClient {
    SSLContext context;
    public boolean connected = false;
    public boolean sendGet = false;
    public Socket sock;
    public URL url;
    public String host;
    public String path;
    public String protocol;
    public String query;
    public String referer;
    public String ua;
    int port;
    List<String> head = new ArrayList<String>();
    public HashMap<String, String> header = new HashMap();
    public OutputStream out;
    public InputStream in;
    public String statusLine;
    public String cook;
    public StringBuffer cookie = new StringBuffer();
    public HashMap<String, String> requestHeader;
    boolean usingProxy = false;
    final int HTTP_PROXY = 10;
    final int HTTPS_PROXY = 20;
    final int NONE = 30;
    int proxyType = 30;
    XDMConfig config;
    long len;

    public XDMHttpClient(XDMConfig config) {
        this.config = config;
    }

    public String getHostString() {
        if (this.port != 80 || this.port != 443) {
            return String.valueOf(this.host) + ":" + this.port;
        }
        return this.host;
    }

    public void addCookieString(String cookie) {
        this.cook = cookie;
    }

    public String getCookieString() {
        return this.cookie.toString();
    }

    public void addHeader(String key, String value) {
        String hkey = key.toLowerCase();
        int i = 0;
        while (i < this.head.size()) {
            String str = this.head.get(i);
            String mkey = str.substring(0, str.indexOf(":")).toLowerCase().trim();
            if (mkey.equalsIgnoreCase(hkey)) {
                this.head.set(i, String.valueOf(hkey) + ": " + value);
                return;
            }
            ++i;
        }
        this.head.add(String.valueOf(key) + ": " + value);
    }

    public String getHeader(String key) {
        return this.header.get(key.toLowerCase());
    }

    public void connect(String uri) throws UnknownHostException, IOException, URISyntaxException, AuthenticationException {
        if (this.connected) {
            return;
        }
        uri = uri.trim();
        this.url = new URL(uri);
        System.out.println("URI IS:" + uri + " " + this.url);
        this.host = this.url.getHost();
        this.port = this.url.getPort();
        this.protocol = this.url.getProtocol();
        this.path = this.url.getPath();
        this.query = this.url.getQuery();
        System.out.println("HOST: " + this.host);
        System.out.println("PORT: " + this.port);
        System.out.println("PROT: " + this.protocol);
        if (this.path == null) {
            this.path = "/";
        }
        if (!this.path.startsWith("/")) {
            this.path = "/" + this.path;
        }
        if (this.query != null) {
            this.path = String.valueOf(this.path) + "?" + this.query;
        }
        if (this.port < 0) {
            if (this.protocol.equals("http")) {
                this.port = 80;
            }
            if (this.protocol.equals("https")) {
                this.port = 443;
            }
        }
        if (this.protocol.equalsIgnoreCase("http")) {
            this.sock = new Socket();
            this.sock.setTcpNoDelay(true);
            this.sock.setReceiveBufferSize(this.config.tcpBuf);
            if (this.config.useHttpProxy) {
                this.proxyType = 10;
                String proxyHost = this.config.httpProxyHost;
                int proxyPort = this.config.httpProxyPort;
                this.sock.connect(new InetSocketAddress(proxyHost, proxyPort));
            } else {
                this.proxyType = 30;
                this.sock.connect(new InetSocketAddress(this.host, this.port));
            }
        } else if (this.protocol.equalsIgnoreCase("https")) {
            if (this.config.useHttpsProxy) {
                this.proxyType = 20;
                this.sock = new Socket();
                this.sock.setReceiveBufferSize(this.config.tcpBuf);
                this.sock.setTcpNoDelay(true);
                this.doTunneling(this.config.httpsProxyHost, this.config.httpsProxyPort);
            } else {
                this.proxyType = 30;
                this.acceptAllCerts();
                this.sock = this.context.getSocketFactory().createSocket();
                this.sock.setTcpNoDelay(true);
                this.sock.setReceiveBufferSize(this.config.tcpBuf);
                this.sock.connect(new InetSocketAddress(this.host, this.port));
            }
        } else {
            throw new IOException("Protocol " + this.protocol + " is not supported");
        }
        this.sock.setTcpNoDelay(true);
        this.in = this.sock.getInputStream();
        this.out = this.sock.getOutputStream();
        String h = this.host;
        if (this.port != 80 && this.port != 443) {
            h = String.valueOf(h) + ":" + this.port;
        }
        this.sock.setKeepAlive(true);
        this.addHeader("Host", h);
        System.out.println("Buffer Size: " + this.sock.getReceiveBufferSize() + " " + this.sock.getTcpNoDelay());
        this.connected = true;
    }

    void doTunneling(String host, int port) throws IOException, AuthenticationException {
        String str;
        this.sock.connect(new InetSocketAddress(host, port));
        StringBuffer buf = new StringBuffer();
        String proxyUser = this.config.httpsUser;
        String proxyPass = this.config.httpsPass;
        boolean proxyAuth = false;
        if (proxyUser != null && proxyUser.length() >= 1 && proxyPass != null && proxyPass.length() >= 1) {
            proxyAuth = true;
        }
        String authString = "";
        if (proxyAuth) {
            authString = "Proxy-Authorization: Basic " + Base64.encode((String.valueOf(this.config.httpsUser) + ":" + this.config.httpsPass).getBytes()) + "\r\n";
        }
        buf.append("CONNECT " + this.host + ":" + this.port + " HTTP/1.1\r\nHost: " + this.host + ":" + this.port + "\r\n" + "Proxy-Connection: Close\r\n" + (authString.length() < 1 ? "" : String.valueOf(authString) + "\r\n") + "\r\n");
        this.out = this.sock.getOutputStream();
        this.in = this.sock.getInputStream();
        this.out.write(buf.toString().getBytes());
        this.out.flush();
        String statLine = this.readLine(this.in);
        System.out.println("Proxy Status LINE: " + statLine);
        String rc = statLine.split(" ")[1];
        if (rc.equals("407")) {
            throw new AuthenticationException("Proxy Authentication required");
        }
        if (!rc.equals("200")) {
            throw new IOException("Unable to establish connection with proxy");
        }
        while ((str = this.readLine(this.in)).length() >= 1) {
            System.out.println(str);
        }
        this.acceptAllCerts();
        SSLSocket sock2 = (SSLSocket)this.context.getSocketFactory().createSocket(this.sock, this.host, this.port, true);
        sock2.startHandshake();
        this.sock = sock2;
    }

    private void acceptAllCerts() {
        try {
            try {
                this.context = SSLContext.getInstance("TLS");
            }
            catch (Exception e) {
                this.context = SSLContext.getInstance("SSL");
            }
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }};
            this.context.init(null, trustAllCerts, null);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendGET() throws IOException {
        if (this.sendGet) {
            return;
        }
        System.out.println(this.path);
        if (this.path.length() < 1) {
            this.path = "/";
        }
        if (this.proxyType == 10) {
            this.path = this.url.toString();
        }
        StringBuffer buf = new StringBuffer("GET " + this.path + " HTTP/1.1\r\n");
        if (this.proxyType == 10) {
            this.addHeader("Proxy-Connection", "Close");
            System.out.println("USING PROXY");
            String proxyUser = this.config.httpUser;
            String proxyPass = this.config.httpPass;
            boolean proxyAuth = false;
            if (proxyUser != null && proxyUser.length() >= 1 && proxyPass != null && proxyPass.length() >= 1) {
                proxyAuth = true;
            }
            if (proxyAuth) {
                System.out.println("Proxy Auth");
                this.addHeader("Proxy-Authorization", "Basic " + Base64.encode((String.valueOf(this.config.httpUser) + ":" + this.config.httpPass).getBytes()));
            }
        }
        int i = 0;
        while (i < this.head.size()) {
            String h = this.head.get(i);
            if (!h.toLowerCase().startsWith("connection:")) {
                buf.append(String.valueOf(h) + "\r\n");
            }
            ++i;
        }
        if (this.cook != null) {
            System.out.println("SETTIMG COOOOOOOOOOOOOOOOOOOOOOOOOOOOKIE: " + this.cook);
            buf.append(this.cook);
        }
        if (!buf.toString().endsWith("\r\n")) {
            buf.append("\r\n");
        }
        buf.append("Connection: close\r\n");
        buf.append("\r\n");
        System.out.println("HEADERS: " + buf);
        this.out.write(buf.toString().getBytes());
        this.out.flush();
        System.out.println("Waiting for server response " + this.sock);
        this.statusLine = this.readLine(this.in);
        System.out.println("STATUS LINE: " + this.statusLine);
        while (true) {
            String ln = this.readLine(this.in);
            System.out.println("RAW HEADER: " + ln);
            if (ln.length() < 1) break;
            int index = ln.indexOf(":");
            String key = ln.substring(0, index).trim();
            String value = ln.substring(index + 1).trim();
            System.out.println(String.valueOf(key) + ":" + value);
            this.header.put(key.toLowerCase(), value);
            if (!ln.toLowerCase().startsWith("set-cookie")) continue;
            this.cookie.append("cookie: " + value + "\r\n");
            System.out.println("Accepting cookie");
        }
        String tenc = this.getHeader("transfer-encoding");
        InputStream in2 = this.in;
        if (tenc != null) {
            if (tenc.equalsIgnoreCase("chunked")) {
                in2 = new ChunkedInputStream(this.in);
            } else {
                throw new IOException("Transfer Encoding not supported: " + tenc);
            }
        }
        String enc = this.getHeader("content-encoding");
        InputStream in3 = in2;
        if (enc != null) {
            if (enc.equalsIgnoreCase("gzip")) {
                in3 = new GZIPInputStream(in2);
            } else if (enc.equalsIgnoreCase("none")) {
                in3 = in2;
            } else {
                throw new IOException("Content Encoding not supported: " + enc);
            }
        }
        this.in = in3;
        this.sendGet = true;
    }

    String readLine(InputStream in) throws IOException {
        StringBuffer buf = new StringBuffer();
        int x;
        while ((x = in.read()) != -1) {
            if (x == 10) {
                return buf.toString();
            }
            if (x == 13) continue;
            buf.append((char)x);
        }
        return buf.toString();
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void close() {
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connected = false;
        this.sendGet = false;
        this.sock = null;
    }

    public void setTimeOut(int timeout) {
        try {
            this.sock.setSoTimeout(timeout);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public int getResponseCode() {
        System.out.println("Parsing status line");
        String[] arr = this.statusLine.split(" ");
        if (arr.length < 2) {
            return 400;
        }
        return Integer.parseInt(arr[1]);
    }

    public long getContentLength() {
        try {
            String clen = this.getHeader("content-length");
            System.out.println("Cstr: " + clen);
            if (clen != null) {
                return Long.parseLong(clen);
            }
            clen = this.getHeader("content-range");
            if (clen != null) {
                String str = clen.split(" ")[1];
                str = str.split("/")[0];
                String[] arr = str.split("-");
                return Long.parseLong(arr[1]) - Long.parseLong(arr[0]) + 1L;
            }
            return -1L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public String getContentName() {
        block5: {
            int index;
            String fm;
            block6: {
                String cd;
                block4: {
                    cd = this.getHeader("content-disposition");
                    if (cd != null) break block4;
                    return null;
                }
                cd = cd.toLowerCase();
                if (!cd.startsWith("attachment")) break block5;
                fm = cd.split(";")[1].trim();
                index = fm.indexOf("=");
                if (index >= 0) break block6;
                return null;
            }
            try {
                return fm.substring(index + 1).trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setBufSize(int sz) throws SocketException {
        this.sock.setReceiveBufferSize(sz);
    }

    public int getBufSize() throws SocketException {
        return this.sock.getReceiveBufferSize();
    }

    public void prepareReuse() {
        this.sendGet = false;
        this.head = new ArrayList<String>();
        String h = this.host;
        if (this.port != 80 && this.port != 443) {
            h = String.valueOf(h) + ":" + this.port;
        }
        this.addHeader("Host", h);
        this.addHeader("Connection", "Keep-Alive");
    }
}

