/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.core.common.http;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Set;
import org.sdg.xdman.core.common.AuthenticationException;
import org.sdg.xdman.core.common.Authenticator;
import org.sdg.xdman.core.common.Connection;
import org.sdg.xdman.core.common.ConnectionManager;
import org.sdg.xdman.core.common.Credential;
import org.sdg.xdman.core.common.InvalidContentException;
import org.sdg.xdman.core.common.InvalidReplyException;
import org.sdg.xdman.core.common.ResumeNotSupportedException;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.core.common.http.XDMHttpClient;
import org.sdg.xdman.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpConnection
extends Connection {
    public XDMHttpClient client;
    boolean clientSet = false;
    int count = 0;
    XDMConfig config;
    public int errorCode;

    public HttpConnection(String url, String fileName, long startOff, long length, long contentLength, int timeout, ConnectionManager mgr, Object lock, HashMap<String, String> extra, String cookie, Credential c, XDMConfig config) {
        super(url, fileName, startOff, length, contentLength, timeout, mgr, lock, extra, cookie);
        this.credential = c;
        this.config = config;
    }

    public HttpConnection(String url, String fileName, long startOff, long length, long contentLength, int timeout, ConnectionManager mgr, Object lock, XDMHttpClient client, HashMap<String, String> extra, String cookie, Credential c, XDMConfig config) {
        super(url, fileName, startOff, length, contentLength, timeout, mgr, lock, extra, cookie);
        this.client = client;
        this.config = config;
        if (client != null) {
            this.clientSet = true;
        }
        this.credential = c;
    }

    public HttpConnection(Connection.State state, int timeout, ConnectionManager mgr, Object lock, String cookie, Credential c, XDMConfig config) {
        super(state, timeout, mgr, lock, cookie);
        this.credential = c;
        this.config = config;
    }

    @Override
    public boolean connect() {
        this.status = 10;
        while (true) {
            block58: {
                this.read = 0L;
                this.clen = 0L;
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
                this.message = "Connecting...";
                this.mgr.updated();
                this.msg("Connecting...");
                if (this.length <= 0L || this.startOff + this.downloaded - (this.startOff + this.length - 1L) <= 0L) break block58;
                this.mgr.donwloadComplete(this);
                return true;
            }
            try {
                long len;
                if (!this.clientSet) {
                    if (this.client == null) {
                        this.client = new XDMHttpClient(this.config);
                    }
                } else {
                    System.out.println("***********************************REUSING CONNECTION******************************");
                    this.clientSet = false;
                }
                this.msg("Connecting to..." + this.url);
                if (!this.client.connected) {
                    this.client.connect(this.url);
                    this.msg("Connecting client...");
                } else {
                    this.msg("Reusing client conn..");
                }
                this.count = 0;
                this.client.setTimeOut(this.timeout);
                if (this.extra != null) {
                    Set keys = this.extra.keySet();
                    for (String key : keys) {
                        String value = (String)this.extra.get(key);
                        if (key.equalsIgnoreCase("cookie") || key.equalsIgnoreCase("range") || key.equalsIgnoreCase("connection") || key.equalsIgnoreCase("host")) continue;
                        this.client.addHeader(key, value);
                    }
                }
                if (this.length > 0L) {
                    this.client.addHeader("Range", "bytes=" + (this.startOff + this.downloaded) + "-");
                }
                if (this.extra == null || this.extra.get("user-agent") == null) {
                    this.client.addHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0)");
                }
                if (this.cookies != null) {
                    if (this.cookies.length() > 0) {
                        System.out.println("Setting cookies: " + this.cookies);
                        this.client.addCookieString(this.cookies);
                    }
                } else {
                    System.out.println("COOKIE IS NULL");
                }
                if (this.credential == null) {
                    this.credential = Authenticator.getInstance().getCredential(this.client.host);
                }
                if (this.credential != null) {
                    System.out.println("Adding auth");
                    this.client.addHeader("Authorization", "Basic " + Base64.encode((String.valueOf(this.credential.user) + ":" + this.credential.pass).getBytes()));
                }
                this.msg("SEND GET...");
                this.message = "Send GET...";
                this.client.sendGET();
                this.count = 0;
                this.msg("SEND GET...Done");
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
                this.message = "Parsing response...";
                this.mgr.updated();
                int code = this.client.getResponseCode();
                this.msg("content-range: " + this.client.getHeader("content-range"));
                this.msg("Response code: " + code);
                this.cookies = this.client.getCookieString();
                System.out.println("COOKIE RECEIVED: " + this.cookies + " " + this.cookies.length());
                if (code >= 300 && code < 400) {
                    this.client.close();
                    if (this.length < 0L) {
                        this.url = this.client.getHeader("location");
                        if (!this.url.startsWith("http")) {
                            this.url = "http://" + this.client.getHostString() + "/" + this.url;
                        }
                        this.url = this.url.replace(" ", "%20");
                        throw new IllegalAccessException("Redirecting to: " + this.url);
                    }
                    throw new InvalidReplyException(code, "Invalid redirect");
                }
                System.out.println("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ " + this.client.getHeader("content-range"));
                if (code != 200 && code != 206 && code != 416 && code != 413 && code != 401 && code != 408 && code != 407 && code != 503) {
                    throw new InvalidReplyException(code, "Invalid response from server");
                }
                if (code == 503) {
                    throw new Exception();
                }
                if (code == 401) {
                    this.credential = this.mgr.getCreditential();
                    if (this.credential == null) {
                        throw new AuthenticationException(this.client.statusLine);
                    }
                    throw new IllegalArgumentException("Unauthorized");
                }
                if (code == 407) {
                    throw new AuthenticationException(this.client.statusLine);
                }
                if (this.startOff + this.downloaded > 0L && code != 206) {
                    throw new ResumeNotSupportedException("Server does not support partial content(Resume feature)");
                }
                this.clen = len = this.client.getContentLength();
                if (this.length < 0L) {
                    try {
                        this.length = len;
                        this.contentLength = len;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.msg("Expected contentlength: " + this.contentLength + " found " + len + " " + this.length);
                if (this.contentLength != -1L && this.length != -1L && this.contentLength != len && this.contentLength - this.downloaded != len) {
                    throw new InvalidContentException("Invalid Content Length: Expected: " + this.contentLength + " but got: " + len);
                }
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
                this.in = this.client.getInputStream();
                this.status = 20;
                this.message = "Downloading...";
                this.buf = new byte[this.config.tcpBuf];
                this.mgr.updated();
                this.msg("Notify...");
                this.msg("Going to call connected()...");
                this.content_type = this.client.getHeader("content-type");
                try {
                    if (this.content_type.indexOf(";") >= 0) {
                        this.content_type = this.content_type.split(";")[0].trim();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("Final content-type: " + this.content_type);
                this.content_disposition = this.client.getContentName();
                this.mgr.connected(this);
                this.msg("Returned from connected()");
                return true;
            }
            catch (UnknownHostException e) {
                this.message = "Disconnect.";
                this.mgr.updated();
                this.msg(e);
                e.printStackTrace();
                this.close();
                if (this.count > 5) {
                    this.status = 30;
                    this.lastError = "Host not found";
                    this.errorCode = 0;
                    break;
                }
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
                this.msg("Sleeping 5 sec");
                this.message = "Disconnect.";
                try {
                    Thread.sleep(5000L);
                    this.chkPause();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.message = "Connecting...";
                this.mgr.updated();
                ++this.count;
            }
            catch (IllegalAccessException e) {
                this.message = "Redirecting...";
                this.mgr.updated();
                this.msg(e);
                e.printStackTrace();
                this.close();
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
            }
            catch (IllegalArgumentException e) {
                this.message = "Authenticating...";
                this.mgr.updated();
                this.msg(e);
                e.printStackTrace();
                this.close();
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
            }
            catch (AuthenticationException e) {
                this.message = e.getMessage();
                this.errorCode = 0;
                this.mgr.updated();
                this.msg(e);
                e.printStackTrace();
                this.close();
                this.status = 30;
                this.lastError = this.client.statusLine;
                if (this.lastError != null && this.lastError.length() >= 1) break;
                this.lastError = "Proxy Authentication Required";
                break;
            }
            catch (InvalidContentException e) {
                this.message = e.getMessage();
                this.errorCode = 1;
                this.mgr.updated();
                this.msg(e);
                e.printStackTrace();
                this.close();
                this.status = 30;
                this.lastError = "Content size invalid";
                break;
            }
            catch (InvalidReplyException e) {
                this.message = e.getMessage();
                this.errorCode = 3;
                this.mgr.updated();
                this.msg(e);
                e.printStackTrace();
                this.close();
                this.status = 30;
                this.lastError = this.client.statusLine;
                break;
            }
            catch (ResumeNotSupportedException e) {
                this.message = e.getMessage();
                this.errorCode = 4;
                this.mgr.updated();
                this.msg(e);
                e.printStackTrace();
                this.close();
                this.status = 30;
                this.lastError = "Resume not supported";
                break;
            }
            catch (Exception e) {
                this.message = "ReConnecting...";
                this.mgr.updated();
                this.msg(e);
                e.printStackTrace();
                this.close();
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
                this.msg("Sleeping 2 sec");
                try {
                    Thread.sleep(2000L);
                    this.chkPause();
                }
                catch (Exception exception) {}
            }
            catch (Error e) {
                this.message = "Not a valid response";
                this.errorCode = 5;
                this.mgr.updated();
                this.msg(e);
                e.printStackTrace();
                this.close();
                this.status = 30;
                this.lastError = "Not a valid response";
                break;
            }
            this.msg("Remaining " + (this.length - this.downloaded));
            if (this.stop) {
                this.close();
                break;
            }
            this.chkPause();
            this.client = null;
            this.clientSet = false;
            try {
                this.client.close();
            }
            catch (Exception exception) {}
        }
        this.msg("Exiting connect");
        if (!this.stop) {
            this.status = 30;
            this.message = "disconnect.";
            this.mgr.updated();
            this.mgr.failed(String.valueOf(this.lastError) + " ", this.errorCode);
        }
        return false;
    }

    long getContentLengthFromRange(String r) {
        try {
            String len = r.split("/")[0].split("-")[1];
            return Long.parseLong(len) + 1L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    @Override
    public void close() {
        this.msg(this.stop);
        this.msg(this.stop ? "STOP " : "Releasing all resource...");
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.msg("Releasing all resource...done");
        this.message = "disconnect";
    }

    @Override
    public boolean isEOF() {
        try {
            System.out.println("IS EOF: " + this.in.read());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.read == this.clen && this.read > 0L;
    }
}

