/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import org.sdg.xdman.core.common.IXDMConstants;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.gui.DownloadListItem;
import org.sdg.xdman.gui.IconUtil;
import org.sdg.xdman.gui.StringResource;
import org.sdg.xdman.util.XDMUtil;

public class DownloadList
implements IXDMConstants,
Serializable {
    private static final long serialVersionUID = -3009294778243929872L;
    ArrayList<DownloadListItem> list = new ArrayList();
    String type;
    int state;
    String appdir;
    public transient String searchStr = "";

    public DownloadList(String appdir) {
        this.appdir = appdir;
        this.loadDownloadList();
    }

    boolean isMatched(DownloadListItem item) {
        if (!XDMUtil.isNullOrEmpty(this.searchStr)) {
            return item.filename.contains(this.searchStr);
        }
        return true;
    }

    DownloadListItem get(int index) {
        int k = 0;
        int i = 0;
        while (i < this.list.size()) {
            DownloadListItem item = this.list.get(i);
            if (this.sameType(item.type) && this.sameState(item.state) && this.isMatched(item)) {
                if (k == index) {
                    return item;
                }
                ++k;
            }
            ++i;
        }
        return null;
    }

    DownloadListItem getByID(UUID id) {
        int i = 0;
        while (i < this.list.size()) {
            DownloadListItem item = this.list.get(i);
            if (item.id != null && item.id.equals(id)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    void remove(DownloadListItem item) {
        this.list.remove(item);
    }

    void remove(int index) {
        int k = 0;
        int i = 0;
        while (i < this.list.size()) {
            DownloadListItem item = this.list.get(i);
            if (this.sameType(item.type) && this.sameState(item.state) && this.isMatched(item)) {
                if (k == index) {
                    this.list.remove(i);
                }
                ++k;
            }
            ++i;
        }
    }

    void add(DownloadListItem item) {
        this.list.add(0, item);
    }

    int size() {
        int k = 0;
        int i = 0;
        while (i < this.list.size()) {
            DownloadListItem item = this.list.get(i);
            if (this.sameType(item.type) && this.sameState(item.state) && this.isMatched(item)) {
                ++k;
            }
            ++i;
        }
        return k;
    }

    void setType(String type) {
        this.type = type;
    }

    void setState(int state) {
        this.state = state;
    }

    int getIndex(DownloadListItem item) {
        int k = 0;
        int i = 0;
        while (i < this.list.size()) {
            DownloadListItem itm = this.list.get(i);
            if (this.sameType(itm.type) && this.sameState(itm.state) && this.isMatched(itm)) {
                if (item.equals(itm)) {
                    return k;
                }
                ++k;
            }
            ++i;
        }
        return -1;
    }

    boolean sameType(String type) {
        if (this.type == null) {
            return true;
        }
        return this.type.equalsIgnoreCase(type);
    }

    boolean sameState(int state) {
        if (this.state == 0) {
            return true;
        }
        if (this.state == 50) {
            return this.state == state;
        }
        return state != 50;
    }

    public void downloadStateChanged() {
        this.saveDownloadList();
    }

    private synchronized void saveDownloadList() {
        ObjectOutputStream out = null;
        try {
            try {
                out = new ObjectOutputStream(new FileOutputStream(new File(this.appdir, ".xdm")));
                out.writeObject(this.list);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    private void loadDownloadList() {
        block14: {
            ObjectInputStream in = null;
            try {
                try {
                    in = new ObjectInputStream(new FileInputStream(new File(this.appdir, ".xdm")));
                    this.list = (ArrayList)in.readObject();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.list == null) {
            this.list = new ArrayList();
        }
        int i = 0;
        while (i < this.list.size()) {
            DownloadListItem item = this.list.get(i);
            item.icon = IconUtil.getIcon(XDMUtil.findCategory(item.filename));
            if (item.state != 50 && item.state != 30) {
                item.state = 40;
                item.status = String.valueOf(StringResource.getString("STOPPED")) + " " + (item.sprg == null ? "---" : item.sprg) + " of " + (item.size == null ? "---" : item.size);
            }
            ++i;
        }
        this.sort();
    }

    public void sort() {
        Collections.sort(this.list);
        if (!XDMConfig.sortAsc) {
            Collections.reverse(this.list);
        }
    }
}

