/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.gui.StringResource;
import org.sdg.xdman.gui.XDMIconMap;
import org.sdg.xdman.util.XDMUtil;

public class DownloadCompleteDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -6952846084893748315L;
    JTextField file;
    JTextField folder;
    JButton open;
    JButton close;
    JButton open_folder;
    JCheckBox chk;
    XDMConfig config;

    public DownloadCompleteDialog(XDMConfig config) {
        this.setSize(320, 300);
        this.setAlwaysOnTop(true);
        this.config = config;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridwidth = 3;
        gc.fill = 2;
        JLabel lbl = new JLabel(StringResource.getString("DWN_DONE"));
        lbl.setFont(new Font("Dialog", 1, 14));
        lbl.setHorizontalAlignment(0);
        lbl.setHorizontalTextPosition(0);
        lbl.setVerticalTextPosition(0);
        lbl.setVerticalAlignment(0);
        panel.add((Component)lbl, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        panel.add((Component)new JLabel(StringResource.getString("FILE")), gc);
        gc.gridx = 0;
        gc.gridy = 2;
        this.file = new JTextField(30);
        this.file.setBackground(Color.WHITE);
        panel.add((Component)this.file, gc);
        this.file.setEditable(false);
        gc.gridx = 0;
        gc.gridy = 3;
        panel.add((Component)new JLabel(StringResource.getString("SAVE_IN")), gc);
        this.folder = new JTextField(30);
        this.folder.setBackground(Color.WHITE);
        this.folder.setEditable(false);
        gc.gridy = 4;
        panel.add((Component)this.folder, gc);
        this.open = new JButton(StringResource.getString("CTX_OPEN"));
        this.open.addActionListener(this);
        this.open_folder = new JButton(StringResource.getString("CTX_OPEN_FOLDER"));
        this.open_folder.addActionListener(this);
        this.close = new JButton(StringResource.getString("CANCEL"));
        this.close.addActionListener(this);
        this.open.setPreferredSize(this.open_folder.getPreferredSize());
        this.open.setMinimumSize(this.open_folder.getPreferredSize());
        this.open.setMaximumSize(this.open_folder.getPreferredSize());
        this.close.setPreferredSize(this.open_folder.getPreferredSize());
        this.close.setMinimumSize(this.open_folder.getPreferredSize());
        this.close.setMaximumSize(this.open_folder.getPreferredSize());
        gc.gridx = 0;
        gc.gridy = 5;
        gc.gridwidth = 1;
        panel.add((Component)this.open, gc);
        gc.gridx = 1;
        panel.add((Component)this.open_folder, gc);
        gc.gridx = 2;
        panel.add((Component)this.close, gc);
        this.add(panel);
        this.chk = new JCheckBox(StringResource.getString("DONT_SHOW_AGAIN"));
        gc.gridy = 6;
        gc.gridx = 0;
        gc.gridwidth = 3;
        panel.add((Component)this.chk, gc);
        this.setIconImage(XDMIconMap.getIcon("APP_ICON").getImage());
    }

    void setData(String file, String path) {
        this.file.setText(file);
        this.folder.setText(path);
        this.setTitle(file);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.open) {
            XDMUtil.open(new File(this.folder.getText(), this.file.getText()));
            System.out.println(new File(this.folder.getText(), this.file.getText()));
            this.config.showDownloadCompleteDlg = !this.chk.isSelected();
            this.setVisible(false);
        }
        if (e.getSource() == this.open_folder) {
            XDMUtil.open(new File(this.folder.getText()));
            this.config.showDownloadCompleteDlg = !this.chk.isSelected();
            this.setVisible(false);
        }
        if (e.getSource() == this.close) {
            this.config.showDownloadCompleteDlg = !this.chk.isSelected();
            this.setVisible(false);
        }
    }
}

