/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.gui.HelpDialog;
import org.sdg.xdman.gui.StringResource;
import org.sdg.xdman.gui.XDMIconMap;
import org.sdg.xdman.util.LinuxUtil;
import org.sdg.xdman.util.XDMUtil;

public class BrowserIntDlg
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -6629147016436649030L;
    JTabbedPane pane;
    JPanel p0;
    JPanel p1;
    JPanel p2;
    JPanel p3;
    JTextArea text1;
    JTextArea text2;
    JTextArea text3;
    JTextArea text4;
    JLabel ff;
    JButton helpff;
    JButton auto;
    JButton man;
    JButton openfolder1;
    JButton chromeHelp;
    JButton openfolder2;
    JButton operaHelp;
    JCheckBox autoStart;
    JCheckBox adv;
    boolean unix = false;
    JButton btn1;
    JButton btn2;
    XDMConfig config;
    Color bgColor;

    public BrowserIntDlg(XDMConfig config) {
        this.config = config;
        this.setTitle(StringResource.getString("BI_LBL_11"));
        this.setIconImage(XDMIconMap.getIcon("APP_ICON").getImage());
        this.text1 = new JTextArea();
        this.text1.setOpaque(false);
        this.text1.setBackground(this.bgColor);
        this.text1.setWrapStyleWord(true);
        this.text1.setEditable(false);
        this.text1.setLineWrap(true);
        this.text1.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.text1.setText(StringResource.getString("BI_LBL_1"));
        this.add((Component)this.text1, "North");
        this.ff = new JLabel(XDMIconMap.getIcon("APP_ICON"));
        this.bgColor = new Color(UIManager.getColor("Label.background").getRGB());
        this.ff.setText("http://127.0.0.1:9614/xdmff.xpi");
        this.ff.setName("http://127.0.0.1:9614/xdmff.xpi");
        this.ff.setHorizontalAlignment(0);
        this.ff.setVerticalAlignment(0);
        this.ff.setHorizontalTextPosition(0);
        this.ff.setVerticalTextPosition(3);
        this.ff.setBackground(Color.WHITE);
        this.ff.setOpaque(true);
        this.ff.setBorder(new LineBorder(Color.GRAY));
        this.ff.setCursor(new Cursor(13));
        this.ff.setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Transferable createTransferable(JComponent c) {
                return new StringSelection(c.getName());
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        this.ff.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JComponent c = (JComponent)e.getSource();
                TransferHandler th = c.getTransferHandler();
                th.exportAsDrag(c, e, 1);
            }
        });
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int w = 400;
        int h = 400;
        if (d.width < w) {
            w = d.width;
        }
        if (d.height < h) {
            h = d.height;
        }
        this.setSize(w, h);
        this.btn1 = new JButton(StringResource.getString("BI_LBL_7"));
        this.btn1.addActionListener(this);
        this.btn2 = new JButton(StringResource.getString("BI_LBL_12"));
        this.btn2.addActionListener(this);
        this.autoStart = new JCheckBox(StringResource.getString("BI_LBL_8"));
        this.autoStart.addActionListener(this);
        this.autoStart.setSelected(config.autostart);
        this.createP0();
        this.createP1();
        this.createP2();
        this.pane = new JTabbedPane();
        this.pane.addTab(StringResource.getString("BI_LBL_23"), XDMIconMap.getIcon("CR_ICON"), this.p0);
        this.pane.addTab(StringResource.getString("BI_LBL_9"), XDMIconMap.getIcon("FF_ICON"), this.p1);
        this.pane.addTab(StringResource.getString("BI_LBL_10"), XDMIconMap.getIcon("OT_ICON"), this.p2);
        JTextArea txt = new JTextArea(StringResource.getString("BI_LBL_5"));
        txt.setBorder(new EmptyBorder(5, 5, 5, 5));
        txt.setBackground(this.bgColor);
        txt.setOpaque(false);
        txt.setWrapStyleWord(true);
        txt.setEditable(false);
        txt.setLineWrap(true);
        this.add((Component)txt, "South");
        this.add(this.pane);
    }

    void createP2() {
        this.p2 = new JPanel(new BorderLayout());
        this.p2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.p2.add(this.createUnixPanel());
        JTextArea txt1 = new JTextArea(StringResource.getString("BI_LBL_6"));
        txt1.setBorder(new EmptyBorder(0, 0, 0, 0));
        txt1.setBackground(this.bgColor);
        txt1.setOpaque(false);
        txt1.setWrapStyleWord(true);
        txt1.setEditable(false);
        txt1.setLineWrap(true);
        this.p2.add((Component)txt1, "North");
    }

    void createP1() {
        Box box = Box.createHorizontalBox();
        this.p1 = new JPanel(new BorderLayout());
        this.text2 = new JTextArea();
        Cursor c = this.text2.getCursor();
        this.text2.setBackground(this.bgColor);
        this.text2.setOpaque(false);
        this.text2.setWrapStyleWord(true);
        this.text2.setEditable(false);
        this.text2.setLineWrap(true);
        this.text2.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.text2.setText(StringResource.getString("BI_LBL_2"));
        this.text2.setCursor(c);
        box.add(this.text2);
        this.helpff = new JButton(StringResource.getString("BI_LBL_3"));
        this.helpff.addActionListener(this);
        box.add(this.helpff);
        this.p1.add((Component)box, "South");
        this.p1.add(this.ff);
        this.p1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    void createP0() {
        this.p0 = new JPanel(new BorderLayout());
        JLabel lbl = new JLabel(XDMIconMap.getIcon("CI_ICON"));
        this.p0.add((Component)lbl, "North");
        JTextArea text3 = new JTextArea();
        text3.setBackground(this.bgColor);
        text3.setOpaque(false);
        text3.setWrapStyleWord(true);
        text3.setEditable(false);
        text3.setLineWrap(true);
        text3.setBorder(new EmptyBorder(0, 0, 0, 0));
        String txt = new File(XDMUtil.getJarPath(), "xdm-helper").getAbsolutePath();
        text3.setText(StringResource.getString("BI_LBL_17").replace("<FOLDER>", txt));
        this.p0.add(text3);
        this.p0.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    void createP3() {
        this.p3 = new JPanel(new BorderLayout());
        JTextArea text3 = new JTextArea();
        text3.setBackground(this.bgColor);
        text3.setOpaque(false);
        text3.setWrapStyleWord(true);
        text3.setEditable(false);
        text3.setLineWrap(true);
        text3.setBorder(new EmptyBorder(0, 0, 0, 0));
        String txt = new File(XDMUtil.getJarPath(), "xdm-helper").getAbsolutePath();
        text3.setText(StringResource.getString("BI_LBL_26").replace("<FOLDER>", txt));
        this.p3.add(text3);
        Box vb = Box.createVerticalBox();
        Box box = Box.createHorizontalBox();
        this.openfolder2 = new JButton(StringResource.getString("BI_LBL_19"));
        this.operaHelp = new JButton(StringResource.getString("BI_LBL_24"));
        this.operaHelp.setPreferredSize(this.openfolder2.getPreferredSize());
        box.add(Box.createHorizontalGlue());
        box.add(this.openfolder2);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.operaHelp);
        this.operaHelp = new JButton(StringResource.getString("BI_LBL_24"));
        box.add(Box.createHorizontalGlue());
        vb.add(box);
        vb.add(Box.createVerticalStrut(10));
        vb.add(Box.createVerticalGlue());
        this.p3.add((Component)vb, "South");
        this.p3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    JPanel createUnixPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(5, 5, 5, 5);
        gc.fill = 2;
        gc.weightx = 1.0;
        p.add((Component)this.btn1, gc);
        gc.gridy = 1;
        p.add((Component)this.btn2, gc);
        gc.gridy = 2;
        gc.weightx = 0.0;
        p.add((Component)this.autoStart, gc);
        gc.gridy = 3;
        return p;
    }

    void setLinuxProxy() {
        if (JOptionPane.showConfirmDialog(this, StringResource.getString("BI_LBL_13"), StringResource.getString("DEFAULT_TITLE"), 0, 3) == 0) {
            if (!LinuxUtil.setLinuxProxy()) {
                JOptionPane.showMessageDialog(this, StringResource.getString("BI_LBL_14"), StringResource.getString("DEFAULT_TITLE"), 0);
            } else {
                JOptionPane.showMessageDialog(this, StringResource.getString("BI_LBL_16"));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btn1) {
            this.setLinuxProxy();
        } else if (e.getSource() == this.autoStart) {
            if (this.autoStart.isSelected()) {
                LinuxUtil.enableAutoStartLinux();
                this.config.autostart = true;
            } else {
                LinuxUtil.disableAutoStartLinux();
                this.config.autostart = false;
            }
        } else if (e.getSource() == this.btn2) {
            this.showHelp("BROWSER_INTEGRATION");
        } else if (e.getSource() == this.helpff) {
            this.showHelp("CAPTURE_VIDEO");
        }
    }

    void showHelp(String topic) {
        try {
            HelpDialog hlp = HelpDialog.getHelpDialog();
            hlp.setDocument(topic);
            hlp.setLocationRelativeTo(null);
            hlp.setVisible(true);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new BrowserIntDlg(null).setVisible(true);
    }
}

