/*
 * Decompiled with CFR 0.152.
 */
package sun.net.sdp;

import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public final class SdpSupport {
    private static final String os = AccessController.doPrivileged(new GetPropertyAction("os.name"));
    private static final boolean isSupported = os.equals("SunOS") || os.equals("Linux");

    private SdpSupport() {
    }

    public static int createSocket() throws IOException {
        if (!isSupported) {
            throw new UnsupportedOperationException("SDP not supported on this platform");
        }
        return SdpSupport.create0();
    }

    public static void convertSocket(int n) throws IOException {
        if (!isSupported) {
            throw new UnsupportedOperationException("SDP not supported on this platform");
        }
        SdpSupport.convert0(n);
    }

    private static native int create0() throws IOException;

    private static native void convert0(int var0) throws IOException;

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
    }
}

