/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.NativeLibLoader;
import sun.awt.image.SunWritableRaster;

public class BytePackedRaster
extends SunWritableRaster {
    int dataBitOffset;
    int scanlineStride;
    int pixelBitStride;
    int bitMask;
    byte[] data;
    int shiftOffset;
    int type;
    private int maxX;
    private int maxY;

    private static native void initIDs();

    public BytePackedRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public BytePackedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public BytePackedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, BytePackedRaster bytePackedRaster) {
        super(sampleModel, dataBuffer, rectangle, point, bytePackedRaster);
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new RasterFormatException("BytePackedRasters must havebyte DataBuffers");
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        this.data = dataBufferByte.getData();
        if (dataBufferByte.getNumBanks() != 1) {
            throw new RasterFormatException("DataBuffer for BytePackedRasters must only have 1 bank.");
        }
        int n = dataBufferByte.getOffset();
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            this.type = 11;
            this.pixelBitStride = multiPixelPackedSampleModel.getPixelBitStride();
            if (this.pixelBitStride != 1 && this.pixelBitStride != 2 && this.pixelBitStride != 4) {
                throw new RasterFormatException("BytePackedRasters must have a bit depth of 1, 2, or 4");
            }
            this.scanlineStride = multiPixelPackedSampleModel.getScanlineStride();
            this.dataBitOffset = multiPixelPackedSampleModel.getDataBitOffset() + n * 8;
            int n2 = rectangle.x - point.x;
            int n3 = rectangle.y - point.y;
            this.dataBitOffset += n2 * this.pixelBitStride + n3 * this.scanlineStride * 8;
        } else {
            throw new RasterFormatException("BytePackedRasters must haveMultiPixelPackedSampleModel");
        }
        this.bitMask = (1 << this.pixelBitStride) - 1;
        this.shiftOffset = 8 - this.pixelBitStride;
        this.verify(false);
    }

    public int getDataBitOffset() {
        return this.dataBitOffset;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelBitStride() {
        return this.pixelBitStride;
    }

    public byte[] getDataStorage() {
        return this.data;
    }

    public Object getDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[this.numDataElements] : (byte[])object;
        int n3 = this.dataBitOffset + (n - this.minX) * this.pixelBitStride;
        int n4 = this.data[(n2 - this.minY) * this.scanlineStride + (n3 >> 3)] & 0xFF;
        int n5 = this.shiftOffset - (n3 & 7);
        byArray[0] = (byte)(n4 >> n5 & this.bitMask);
        return byArray;
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        return this.getByteData(n, n2, n3, n4, (byte[])object);
    }

    public Object getPixelData(int n, int n2, int n3, int n4, Object object) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[this.numDataElements * n3 * n4] : (byte[])object;
        int n5 = this.pixelBitStride;
        int n6 = this.dataBitOffset + (n - this.minX) * n5;
        int n7 = (n2 - this.minY) * this.scanlineStride;
        int n8 = 0;
        byte[] byArray2 = this.data;
        for (int i = 0; i < n4; ++i) {
            int n9 = n6;
            for (int j = 0; j < n3; ++j) {
                int n10 = this.shiftOffset - (n9 & 7);
                byArray[n8++] = (byte)(this.bitMask & byArray2[n7 + (n9 >> 3)] >> n10);
                n9 += n5;
            }
            n7 += this.scanlineStride;
        }
        return byArray;
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        return this.getByteData(n, n2, n3, n4, byArray);
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[n3 * n4];
        }
        int n5 = this.pixelBitStride;
        int n6 = this.dataBitOffset + (n - this.minX) * n5;
        int n7 = (n2 - this.minY) * this.scanlineStride;
        int n8 = 0;
        byte[] byArray2 = this.data;
        for (int i = 0; i < n4; ++i) {
            int n9;
            int n10;
            int n11 = n6;
            for (n10 = 0; n10 < n3 && (n11 & 7) != 0; ++n10) {
                n9 = this.shiftOffset - (n11 & 7);
                byArray[n8++] = (byte)(this.bitMask & byArray2[n7 + (n11 >> 3)] >> n9);
                n11 += n5;
            }
            n9 = n7 + (n11 >> 3);
            switch (n5) {
                case 1: {
                    byte by;
                    while (n10 < n3 - 7) {
                        by = byArray2[n9++];
                        byArray[n8++] = (byte)(by >> 7 & 1);
                        byArray[n8++] = (byte)(by >> 6 & 1);
                        byArray[n8++] = (byte)(by >> 5 & 1);
                        byArray[n8++] = (byte)(by >> 4 & 1);
                        byArray[n8++] = (byte)(by >> 3 & 1);
                        byArray[n8++] = (byte)(by >> 2 & 1);
                        byArray[n8++] = (byte)(by >> 1 & 1);
                        byArray[n8++] = (byte)(by & 1);
                        n11 += 8;
                        n10 += 8;
                    }
                    break;
                }
                case 2: {
                    byte by;
                    while (n10 < n3 - 7) {
                        by = byArray2[n9++];
                        byArray[n8++] = (byte)(by >> 6 & 3);
                        byArray[n8++] = (byte)(by >> 4 & 3);
                        byArray[n8++] = (byte)(by >> 2 & 3);
                        byArray[n8++] = (byte)(by & 3);
                        by = byArray2[n9++];
                        byArray[n8++] = (byte)(by >> 6 & 3);
                        byArray[n8++] = (byte)(by >> 4 & 3);
                        byArray[n8++] = (byte)(by >> 2 & 3);
                        byArray[n8++] = (byte)(by & 3);
                        n11 += 16;
                        n10 += 8;
                    }
                    break;
                }
                case 4: {
                    byte by;
                    while (n10 < n3 - 7) {
                        by = byArray2[n9++];
                        byArray[n8++] = (byte)(by >> 4 & 0xF);
                        byArray[n8++] = (byte)(by & 0xF);
                        by = byArray2[n9++];
                        byArray[n8++] = (byte)(by >> 4 & 0xF);
                        byArray[n8++] = (byte)(by & 0xF);
                        by = byArray2[n9++];
                        byArray[n8++] = (byte)(by >> 4 & 0xF);
                        byArray[n8++] = (byte)(by & 0xF);
                        by = byArray2[n9++];
                        byArray[n8++] = (byte)(by >> 4 & 0xF);
                        byArray[n8++] = (byte)(by & 0xF);
                        n11 += 32;
                        n10 += 8;
                    }
                    break;
                }
            }
            while (n10 < n3) {
                int n12 = this.shiftOffset - (n11 & 7);
                byArray[n8++] = (byte)(this.bitMask & byArray2[n7 + (n11 >> 3)] >> n12);
                n11 += n5;
                ++n10;
            }
            n7 += this.scanlineStride;
        }
        return byArray;
    }

    public void setDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = (byte[])object;
        int n3 = this.dataBitOffset + (n - this.minX) * this.pixelBitStride;
        int n4 = (n2 - this.minY) * this.scanlineStride + (n3 >> 3);
        int n5 = this.shiftOffset - (n3 & 7);
        byte by = this.data[n4];
        by = (byte)(by & ~(this.bitMask << n5));
        this.data[n4] = by = (byte)(by | (byArray[0] & this.bitMask) << n5);
        this.notifyChanged();
    }

    public void setDataElements(int n, int n2, Raster raster) {
        if (!(raster instanceof BytePackedRaster) || ((BytePackedRaster)raster).pixelBitStride != this.pixelBitStride) {
            super.setDataElements(n, n2, raster);
            return;
        }
        int n3 = raster.getMinX();
        int n4 = raster.getMinY();
        int n5 = n3 + n;
        int n6 = n4 + n2;
        int n7 = raster.getWidth();
        int n8 = raster.getHeight();
        if (n5 < this.minX || n6 < this.minY || n5 + n7 > this.maxX || n6 + n8 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n5, n6, n3, n4, n7, n8, (BytePackedRaster)raster);
    }

    private void setDataElements(int n, int n2, int n3, int n4, int n5, int n6, BytePackedRaster bytePackedRaster) {
        block20: {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            byte[] byArray;
            byte[] byArray2;
            block19: {
                int n23;
                int n24;
                int n25;
                int n26;
                int n27;
                if (n5 <= 0 || n6 <= 0) {
                    return;
                }
                byArray2 = bytePackedRaster.data;
                byArray = this.data;
                n22 = bytePackedRaster.scanlineStride;
                n21 = this.scanlineStride;
                n20 = bytePackedRaster.dataBitOffset + 8 * (n4 - bytePackedRaster.minY) * n22 + (n3 - bytePackedRaster.minX) * bytePackedRaster.pixelBitStride;
                n19 = this.dataBitOffset + 8 * (n2 - this.minY) * n21 + (n - this.minX) * this.pixelBitStride;
                n18 = n5 * this.pixelBitStride;
                if ((n20 & 7) != (n19 & 7)) break block19;
                int n28 = n19 & 7;
                if (n28 != 0) {
                    n27 = 8 - n28;
                    n26 = n20 >> 3;
                    n25 = n19 >> 3;
                    n24 = 255 >> n28;
                    if (n18 < n27) {
                        n24 &= 255 << n27 - n18;
                        n27 = n18;
                    }
                    for (n23 = 0; n23 < n6; ++n23) {
                        int n29 = byArray[n25];
                        n29 &= ~n24;
                        byArray[n25] = (byte)(n29 |= byArray2[n26] & n24);
                        n26 += n22;
                        n25 += n21;
                    }
                    n20 += n27;
                    n19 += n27;
                    n18 -= n27;
                }
                if (n18 >= 8) {
                    n27 = n20 >> 3;
                    n26 = n19 >> 3;
                    n25 = n18 >> 3;
                    if (n25 == n22 && n22 == n21) {
                        System.arraycopy(byArray2, n27, byArray, n26, n22 * n6);
                    } else {
                        for (n24 = 0; n24 < n6; ++n24) {
                            System.arraycopy(byArray2, n27, byArray, n26, n25);
                            n27 += n22;
                            n26 += n21;
                        }
                    }
                    n24 = n25 * 8;
                    n20 += n24;
                    n19 += n24;
                    n18 -= n24;
                }
                if (n18 <= 0) break block20;
                n27 = n20 >> 3;
                n26 = n19 >> 3;
                n25 = 65280 >> n18 & 0xFF;
                for (n24 = 0; n24 < n6; ++n24) {
                    n23 = byArray[n26];
                    n23 &= ~n25;
                    byArray[n26] = (byte)(n23 |= byArray2[n27] & n25);
                    n27 += n22;
                    n26 += n21;
                }
                break block20;
            }
            int n30 = n19 & 7;
            if (n30 != 0 || n18 < 8) {
                n17 = 8 - n30;
                n16 = n20 >> 3;
                n15 = n19 >> 3;
                n14 = n20 & 7;
                n13 = 8 - n14;
                n12 = 255 >> n30;
                if (n18 < n17) {
                    n12 &= 255 << n17 - n18;
                    n17 = n18;
                }
                n11 = byArray2.length - 1;
                for (n10 = 0; n10 < n6; ++n10) {
                    n9 = byArray2[n16];
                    n8 = 0;
                    if (n16 < n11) {
                        n8 = byArray2[n16 + 1];
                    }
                    n7 = byArray[n15];
                    n7 &= ~n12;
                    byArray[n15] = (byte)(n7 |= (n9 << n14 | (n8 & 0xFF) >> n13) >> n30 & n12);
                    n16 += n22;
                    n15 += n21;
                }
                n20 += n17;
                n19 += n17;
                n18 -= n17;
            }
            if (n18 >= 8) {
                n17 = n20 >> 3;
                n16 = n19 >> 3;
                n15 = n18 >> 3;
                n14 = n20 & 7;
                n13 = 8 - n14;
                for (n12 = 0; n12 < n6; ++n12) {
                    n11 = n17 + n12 * n22;
                    n10 = n16 + n12 * n21;
                    n9 = byArray2[n11];
                    for (n8 = 0; n8 < n15; ++n8) {
                        n7 = byArray2[n11 + 1];
                        int n31 = n9 << n14 | (n7 & 0xFF) >> n13;
                        byArray[n10] = (byte)n31;
                        n9 = n7;
                        ++n11;
                        ++n10;
                    }
                }
                n12 = n15 * 8;
                n20 += n12;
                n19 += n12;
                n18 -= n12;
            }
            if (n18 > 0) {
                n17 = n20 >> 3;
                n16 = n19 >> 3;
                n15 = 65280 >> n18 & 0xFF;
                n14 = n20 & 7;
                n13 = 8 - n14;
                n12 = byArray2.length - 1;
                for (n11 = 0; n11 < n6; ++n11) {
                    n10 = byArray2[n17];
                    n9 = 0;
                    if (n17 < n12) {
                        n9 = byArray2[n17 + 1];
                    }
                    n8 = byArray[n16];
                    n8 &= ~n15;
                    byArray[n16] = (byte)(n8 |= (n10 << n14 | (n9 & 0xFF) >> n13) & n15);
                    n17 += n22;
                    n16 += n21;
                }
            }
        }
    }

    public void setRect(int n, int n2, Raster raster) {
        int n3;
        if (!(raster instanceof BytePackedRaster) || ((BytePackedRaster)raster).pixelBitStride != this.pixelBitStride) {
            super.setRect(n, n2, raster);
            return;
        }
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        int n6 = raster.getMinX();
        int n7 = raster.getMinY();
        int n8 = n + n6;
        int n9 = n2 + n7;
        if (n8 < this.minX) {
            n3 = this.minX - n8;
            n4 -= n3;
            n6 += n3;
            n8 = this.minX;
        }
        if (n9 < this.minY) {
            n3 = this.minY - n9;
            n5 -= n3;
            n7 += n3;
            n9 = this.minY;
        }
        if (n8 + n4 > this.maxX) {
            n4 = this.maxX - n8;
        }
        if (n9 + n5 > this.maxY) {
            n5 = this.maxY - n9;
        }
        this.setDataElements(n8, n9, n6, n7, n4, n5, (BytePackedRaster)raster);
        this.notifyChanged();
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        this.putByteData(n, n2, n3, n4, (byte[])object);
    }

    public void putByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        this.putByteData(n, n2, n3, n4, byArray);
    }

    public void putByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (n3 == 0 || n4 == 0) {
            return;
        }
        int n5 = this.pixelBitStride;
        int n6 = this.dataBitOffset + (n - this.minX) * n5;
        int n7 = (n2 - this.minY) * this.scanlineStride;
        int n8 = 0;
        byte[] byArray2 = this.data;
        for (int i = 0; i < n4; ++i) {
            int n9;
            int n10;
            int n11;
            int n12 = n6;
            for (n11 = 0; n11 < n3 && (n12 & 7) != 0; ++n11) {
                n10 = this.shiftOffset - (n12 & 7);
                n9 = byArray2[n7 + (n12 >> 3)];
                n9 &= ~(this.bitMask << n10);
                byArray2[n7 + (n12 >> 3)] = (byte)(n9 |= (byArray[n8++] & this.bitMask) << n10);
                n12 += n5;
            }
            n10 = n7 + (n12 >> 3);
            switch (n5) {
                case 1: {
                    while (n11 < n3 - 7) {
                        n9 = (byArray[n8++] & 1) << 7;
                        n9 |= (byArray[n8++] & 1) << 6;
                        n9 |= (byArray[n8++] & 1) << 5;
                        n9 |= (byArray[n8++] & 1) << 4;
                        n9 |= (byArray[n8++] & 1) << 3;
                        n9 |= (byArray[n8++] & 1) << 2;
                        n9 |= (byArray[n8++] & 1) << 1;
                        byArray2[n10++] = (byte)(n9 |= byArray[n8++] & 1);
                        n12 += 8;
                        n11 += 8;
                    }
                    break;
                }
                case 2: {
                    while (n11 < n3 - 7) {
                        n9 = (byArray[n8++] & 3) << 6;
                        n9 |= (byArray[n8++] & 3) << 4;
                        n9 |= (byArray[n8++] & 3) << 2;
                        byArray2[n10++] = (byte)(n9 |= byArray[n8++] & 3);
                        n9 = (byArray[n8++] & 3) << 6;
                        n9 |= (byArray[n8++] & 3) << 4;
                        n9 |= (byArray[n8++] & 3) << 2;
                        byArray2[n10++] = (byte)(n9 |= byArray[n8++] & 3);
                        n12 += 16;
                        n11 += 8;
                    }
                    break;
                }
                case 4: {
                    while (n11 < n3 - 7) {
                        n9 = (byArray[n8++] & 0xF) << 4;
                        byArray2[n10++] = (byte)(n9 |= byArray[n8++] & 0xF);
                        n9 = (byArray[n8++] & 0xF) << 4;
                        byArray2[n10++] = (byte)(n9 |= byArray[n8++] & 0xF);
                        n9 = (byArray[n8++] & 0xF) << 4;
                        byArray2[n10++] = (byte)(n9 |= byArray[n8++] & 0xF);
                        n9 = (byArray[n8++] & 0xF) << 4;
                        byArray2[n10++] = (byte)(n9 |= byArray[n8++] & 0xF);
                        n12 += 32;
                        n11 += 8;
                    }
                    break;
                }
            }
            while (n11 < n3) {
                int n13 = this.shiftOffset - (n12 & 7);
                n9 = byArray2[n7 + (n12 >> 3)];
                n9 &= ~(this.bitMask << n13);
                byArray2[n7 + (n12 >> 3)] = (byte)(n9 |= (byArray[n8++] & this.bitMask) << n13);
                n12 += n5;
                ++n11;
            }
            n7 += this.scanlineStride;
        }
        this.notifyChanged();
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (nArray == null) {
            nArray = new int[n3 * n4];
        }
        int n5 = this.pixelBitStride;
        int n6 = this.dataBitOffset + (n - this.minX) * n5;
        int n7 = (n2 - this.minY) * this.scanlineStride;
        int n8 = 0;
        byte[] byArray = this.data;
        for (int i = 0; i < n4; ++i) {
            int n9;
            int n10;
            int n11 = n6;
            for (n10 = 0; n10 < n3 && (n11 & 7) != 0; ++n10) {
                n9 = this.shiftOffset - (n11 & 7);
                nArray[n8++] = this.bitMask & byArray[n7 + (n11 >> 3)] >> n9;
                n11 += n5;
            }
            n9 = n7 + (n11 >> 3);
            switch (n5) {
                case 1: {
                    byte by;
                    while (n10 < n3 - 7) {
                        by = byArray[n9++];
                        nArray[n8++] = by >> 7 & 1;
                        nArray[n8++] = by >> 6 & 1;
                        nArray[n8++] = by >> 5 & 1;
                        nArray[n8++] = by >> 4 & 1;
                        nArray[n8++] = by >> 3 & 1;
                        nArray[n8++] = by >> 2 & 1;
                        nArray[n8++] = by >> 1 & 1;
                        nArray[n8++] = by & 1;
                        n11 += 8;
                        n10 += 8;
                    }
                    break;
                }
                case 2: {
                    byte by;
                    while (n10 < n3 - 7) {
                        by = byArray[n9++];
                        nArray[n8++] = by >> 6 & 3;
                        nArray[n8++] = by >> 4 & 3;
                        nArray[n8++] = by >> 2 & 3;
                        nArray[n8++] = by & 3;
                        by = byArray[n9++];
                        nArray[n8++] = by >> 6 & 3;
                        nArray[n8++] = by >> 4 & 3;
                        nArray[n8++] = by >> 2 & 3;
                        nArray[n8++] = by & 3;
                        n11 += 16;
                        n10 += 8;
                    }
                    break;
                }
                case 4: {
                    byte by;
                    while (n10 < n3 - 7) {
                        by = byArray[n9++];
                        nArray[n8++] = by >> 4 & 0xF;
                        nArray[n8++] = by & 0xF;
                        by = byArray[n9++];
                        nArray[n8++] = by >> 4 & 0xF;
                        nArray[n8++] = by & 0xF;
                        by = byArray[n9++];
                        nArray[n8++] = by >> 4 & 0xF;
                        nArray[n8++] = by & 0xF;
                        by = byArray[n9++];
                        nArray[n8++] = by >> 4 & 0xF;
                        nArray[n8++] = by & 0xF;
                        n11 += 32;
                        n10 += 8;
                    }
                    break;
                }
            }
            while (n10 < n3) {
                int n12 = this.shiftOffset - (n11 & 7);
                nArray[n8++] = this.bitMask & byArray[n7 + (n11 >> 3)] >> n12;
                n11 += n5;
                ++n10;
            }
            n7 += this.scanlineStride;
        }
        return nArray;
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = this.pixelBitStride;
        int n6 = this.dataBitOffset + (n - this.minX) * n5;
        int n7 = (n2 - this.minY) * this.scanlineStride;
        int n8 = 0;
        byte[] byArray = this.data;
        for (int i = 0; i < n4; ++i) {
            int n9;
            int n10;
            int n11;
            int n12 = n6;
            for (n11 = 0; n11 < n3 && (n12 & 7) != 0; ++n11) {
                n10 = this.shiftOffset - (n12 & 7);
                n9 = byArray[n7 + (n12 >> 3)];
                n9 &= ~(this.bitMask << n10);
                byArray[n7 + (n12 >> 3)] = (byte)(n9 |= (nArray[n8++] & this.bitMask) << n10);
                n12 += n5;
            }
            n10 = n7 + (n12 >> 3);
            switch (n5) {
                case 1: {
                    while (n11 < n3 - 7) {
                        n9 = (nArray[n8++] & 1) << 7;
                        n9 |= (nArray[n8++] & 1) << 6;
                        n9 |= (nArray[n8++] & 1) << 5;
                        n9 |= (nArray[n8++] & 1) << 4;
                        n9 |= (nArray[n8++] & 1) << 3;
                        n9 |= (nArray[n8++] & 1) << 2;
                        n9 |= (nArray[n8++] & 1) << 1;
                        byArray[n10++] = (byte)(n9 |= nArray[n8++] & 1);
                        n12 += 8;
                        n11 += 8;
                    }
                    break;
                }
                case 2: {
                    while (n11 < n3 - 7) {
                        n9 = (nArray[n8++] & 3) << 6;
                        n9 |= (nArray[n8++] & 3) << 4;
                        n9 |= (nArray[n8++] & 3) << 2;
                        byArray[n10++] = (byte)(n9 |= nArray[n8++] & 3);
                        n9 = (nArray[n8++] & 3) << 6;
                        n9 |= (nArray[n8++] & 3) << 4;
                        n9 |= (nArray[n8++] & 3) << 2;
                        byArray[n10++] = (byte)(n9 |= nArray[n8++] & 3);
                        n12 += 16;
                        n11 += 8;
                    }
                    break;
                }
                case 4: {
                    while (n11 < n3 - 7) {
                        n9 = (nArray[n8++] & 0xF) << 4;
                        byArray[n10++] = (byte)(n9 |= nArray[n8++] & 0xF);
                        n9 = (nArray[n8++] & 0xF) << 4;
                        byArray[n10++] = (byte)(n9 |= nArray[n8++] & 0xF);
                        n9 = (nArray[n8++] & 0xF) << 4;
                        byArray[n10++] = (byte)(n9 |= nArray[n8++] & 0xF);
                        n9 = (nArray[n8++] & 0xF) << 4;
                        byArray[n10++] = (byte)(n9 |= nArray[n8++] & 0xF);
                        n12 += 32;
                        n11 += 8;
                    }
                    break;
                }
            }
            while (n11 < n3) {
                int n13 = this.shiftOffset - (n12 & 7);
                n9 = byArray[n7 + (n12 >> 3)];
                n9 &= ~(this.bitMask << n13);
                byArray[n7 + (n12 >> 3)] = (byte)(n9 |= (nArray[n8++] & this.bitMask) << n13);
                n12 += n5;
                ++n11;
            }
            n7 += this.scanlineStride;
        }
    }

    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        WritableRaster writableRaster = this.createWritableChild(n, n2, n3, n4, n5, n6, nArray);
        return writableRaster;
    }

    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("x lies outside the raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("y lies outside the raster");
        }
        if (n + n3 < n || n + n3 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n7 = n5 - n;
        int n8 = n6 - n2;
        this.notifyStolen();
        return new BytePackedRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RasterFormatException("negative " + (n <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n, n2);
        return new BytePackedRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    private void verify(boolean bl) {
        if (this.dataBitOffset < 0) {
            throw new RasterFormatException("Data offsets must be >= 0");
        }
        if (this.width <= 0 || this.height <= 0 || this.height > Integer.MAX_VALUE / this.width) {
            throw new RasterFormatException("Invalid raster dimension");
        }
        if (this.width - 1 > Integer.MAX_VALUE / this.pixelBitStride) {
            throw new RasterFormatException("Invalid raster dimension");
        }
        if (this.scanlineStride < 0 || this.scanlineStride > Integer.MAX_VALUE / this.height) {
            throw new RasterFormatException("Invalid scanline stride");
        }
        int n = this.dataBitOffset + (this.height - 1) * this.scanlineStride * 8 + (this.width - 1) * this.pixelBitStride + this.pixelBitStride - 1;
        if (n < 0 || n / 8 >= this.data.length) {
            throw new RasterFormatException("raster dimensions overflow array bounds");
        }
        if (bl && this.height > 1 && (n = this.width * this.pixelBitStride - 1) / 8 >= this.scanlineStride) {
            throw new RasterFormatException("data for adjacent scanlines overlaps");
        }
    }

    public String toString() {
        return new String("BytePackedRaster: width = " + this.width + " height = " + this.height + " #channels " + this.numBands + " xOff = " + this.sampleModelTranslateX + " yOff = " + this.sampleModelTranslateY);
    }

    static {
        NativeLibLoader.loadLibraries();
        BytePackedRaster.initIDs();
    }
}

