/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Point;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDnDConstants;
import sun.awt.X11.XDragSourceContextPeer;
import sun.awt.X11.XDropTargetEventProcessor;
import sun.awt.X11.XDropTargetProtocol;
import sun.awt.X11.XDropTargetProtocolListener;
import sun.awt.X11.XDropTargetRegistry;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XException;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class XDnDDropTargetProtocol
extends XDropTargetProtocol {
    private static final Logger logger = Logger.getLogger("sun.awt.X11.xembed.xdnd.XDnDDropTargetProtocol");
    private static final Unsafe unsafe = XlibWrapper.unsafe;
    private long sourceWindow = 0L;
    private long sourceWindowMask = 0L;
    private int sourceProtocolVersion = 0;
    private int sourceActions = 0;
    private long[] sourceFormats = null;
    private boolean trackSourceActions = false;
    private int userAction = 0;
    private int sourceX = 0;
    private int sourceY = 0;
    private XWindow targetXWindow = null;
    private long prevCtxt = 0L;
    private boolean overXEmbedClient = false;

    protected XDnDDropTargetProtocol(XDropTargetProtocolListener xDropTargetProtocolListener) {
        super(xDropTargetProtocolListener);
    }

    static XDropTargetProtocol createInstance(XDropTargetProtocolListener xDropTargetProtocolListener) {
        return new XDnDDropTargetProtocol(xDropTargetProtocolListener);
    }

    public String getProtocolName() {
        return "XDnD";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDropTarget(long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        long l2 = Native.allocateLongArray(1);
        try {
            Native.putLong(l2, 0, 5L);
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XDnDConstants.XA_XdndAware.setAtomData(l, 4L, l2, 1);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write XdndAware property");
            }
            Object var6_3 = null;
            unsafe.freeMemory(l2);
            l2 = 0L;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            unsafe.freeMemory(l2);
            l2 = 0L;
            throw throwable;
        }
    }

    public void unregisterDropTarget(long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        XDnDConstants.XA_XdndAware.DeleteProperty(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEmbedderDropSite(long l) {
        WindowPropertyGetter windowPropertyGetter;
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        boolean bl = false;
        int n = 0;
        long l2 = 0L;
        long l3 = XDropTargetRegistry.getDnDProxyWindow();
        int n2 = 0;
        WindowPropertyGetter windowPropertyGetter2 = new WindowPropertyGetter(l, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
        try {
            n2 = windowPropertyGetter2.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
            if (n2 == 0 && windowPropertyGetter2.getData() != 0L && windowPropertyGetter2.getActualType() == 4L) {
                bl = true;
                n = (int)Native.getLong(windowPropertyGetter2.getData());
            }
            windowPropertyGetter = null;
            windowPropertyGetter2.dispose();
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            windowPropertyGetter2.dispose();
            throw throwable;
        }
        if (bl && n >= 4) {
            WindowPropertyGetter windowPropertyGetter3 = new WindowPropertyGetter(l, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
            try {
                n2 = windowPropertyGetter3.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (n2 == 0 && windowPropertyGetter3.getData() != 0L && windowPropertyGetter3.getActualType() == 33L) {
                    l2 = Native.getLong(windowPropertyGetter3.getData());
                }
                Object var14_13 = null;
                windowPropertyGetter3.dispose();
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                windowPropertyGetter3.dispose();
                throw throwable;
            }
            if (l2 != 0L) {
                windowPropertyGetter = new WindowPropertyGetter(l2, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
                try {
                    n2 = windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                    if (n2 != 0 || windowPropertyGetter.getData() == 0L || windowPropertyGetter.getActualType() != 33L || Native.getLong(windowPropertyGetter.getData()) != l2) {
                        l2 = 0L;
                    } else {
                        WindowPropertyGetter windowPropertyGetter4 = new WindowPropertyGetter(l2, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
                        try {
                            n2 = windowPropertyGetter4.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                            if (n2 != 0 || windowPropertyGetter4.getData() == 0L || windowPropertyGetter4.getActualType() != 4L) {
                                l2 = 0L;
                            }
                            Object var16_17 = null;
                            windowPropertyGetter4.dispose();
                        }
                        catch (Throwable throwable) {
                            Object var16_18 = null;
                            windowPropertyGetter4.dispose();
                            throw throwable;
                        }
                    }
                    Object var18_20 = null;
                    windowPropertyGetter.dispose();
                }
                catch (Throwable throwable) {
                    Object var18_21 = null;
                    windowPropertyGetter.dispose();
                    throw throwable;
                }
            }
        }
        if (l2 == l3) {
            return;
        }
        long l4 = Native.allocateLongArray(1);
        try {
            Native.putLong(l4, 0, 5L);
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XDnDConstants.XA_XdndAware.setAtomData(l3, 4L, l4, 1);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write XdndAware property");
            }
            Native.putLong(l4, 0, l3);
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XDnDConstants.XA_XdndProxy.setAtomData(l3, 33L, l4, 1);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write XdndProxy property");
            }
            Native.putLong(l4, 0, 5L);
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XDnDConstants.XA_XdndAware.setAtomData(l, 4L, l4, 1);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write XdndAware property");
            }
            Native.putLong(l4, 0, l3);
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XDnDConstants.XA_XdndProxy.setAtomData(l, 33L, l4, 1);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write XdndProxy property");
            }
            Object var20_23 = null;
            unsafe.freeMemory(l4);
            l4 = 0L;
        }
        catch (Throwable throwable) {
            Object var20_24 = null;
            unsafe.freeMemory(l4);
            l4 = 0L;
            throw throwable;
        }
        this.putEmbedderRegistryEntry(l, bl, n, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEmbedderDropSite(long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        XDropTargetProtocol.EmbedderRegistryEntry embedderRegistryEntry = this.getEmbedderRegistryEntry(l);
        if (embedderRegistryEntry == null) {
            return;
        }
        if (embedderRegistryEntry.isOverriden()) {
            long l2 = Native.allocateLongArray(1);
            try {
                Native.putLong(l2, 0, embedderRegistryEntry.getVersion());
                XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
                XDnDConstants.XA_XdndAware.setAtomData(l, 4L, l2, 1);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                    throw new XException("Cannot write XdndAware property");
                }
                Native.putLong(l2, 0, (int)embedderRegistryEntry.getProxy());
                XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
                XDnDConstants.XA_XdndProxy.setAtomData(l, 33L, l2, 1);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                    throw new XException("Cannot write XdndProxy property");
                }
                Object var7_4 = null;
                unsafe.freeMemory(l2);
                l2 = 0L;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                unsafe.freeMemory(l2);
                l2 = 0L;
                throw throwable;
            }
        } else {
            XDnDConstants.XA_XdndAware.DeleteProperty(l);
            XDnDConstants.XA_XdndProxy.DeleteProperty(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEmbeddedDropSite(long l) {
        WindowPropertyGetter windowPropertyGetter;
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        boolean bl = false;
        int n = 0;
        long l2 = 0L;
        long l3 = XDropTargetRegistry.getDnDProxyWindow();
        int n2 = 0;
        WindowPropertyGetter windowPropertyGetter2 = new WindowPropertyGetter(l, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
        try {
            n2 = windowPropertyGetter2.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
            if (n2 == 0 && windowPropertyGetter2.getData() != 0L && windowPropertyGetter2.getActualType() == 4L) {
                bl = true;
                n = (int)Native.getLong(windowPropertyGetter2.getData());
            }
            windowPropertyGetter = null;
            windowPropertyGetter2.dispose();
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            windowPropertyGetter2.dispose();
            throw throwable;
        }
        if (bl && n >= 4) {
            WindowPropertyGetter windowPropertyGetter3 = new WindowPropertyGetter(l, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
            try {
                n2 = windowPropertyGetter3.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (n2 == 0 && windowPropertyGetter3.getData() != 0L && windowPropertyGetter3.getActualType() == 33L) {
                    l2 = Native.getLong(windowPropertyGetter3.getData());
                }
                Object var14_12 = null;
                windowPropertyGetter3.dispose();
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                windowPropertyGetter3.dispose();
                throw throwable;
            }
            if (l2 != 0L) {
                windowPropertyGetter = new WindowPropertyGetter(l2, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
                try {
                    n2 = windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                    if (n2 != 0 || windowPropertyGetter.getData() == 0L || windowPropertyGetter.getActualType() != 33L || Native.getLong(windowPropertyGetter.getData()) != l2) {
                        l2 = 0L;
                    } else {
                        WindowPropertyGetter windowPropertyGetter4 = new WindowPropertyGetter(l2, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
                        try {
                            n2 = windowPropertyGetter4.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                            if (n2 != 0 || windowPropertyGetter4.getData() == 0L || windowPropertyGetter4.getActualType() != 4L) {
                                l2 = 0L;
                            }
                            Object var16_16 = null;
                            windowPropertyGetter4.dispose();
                        }
                        catch (Throwable throwable) {
                            Object var16_17 = null;
                            windowPropertyGetter4.dispose();
                            throw throwable;
                        }
                    }
                    Object var18_19 = null;
                    windowPropertyGetter.dispose();
                }
                catch (Throwable throwable) {
                    Object var18_20 = null;
                    windowPropertyGetter.dispose();
                    throw throwable;
                }
            }
        }
        this.putEmbedderRegistryEntry(l, bl, n, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProtocolSupported(long l) {
        WindowPropertyGetter windowPropertyGetter;
        block4: {
            assert (XToolkit.isAWTLockHeldByCurrentThread());
            windowPropertyGetter = new WindowPropertyGetter(l, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
            try {
                int n = windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (n != 0 || windowPropertyGetter.getData() == 0L || windowPropertyGetter.getActualType() != 4L) break block4;
                boolean bl = true;
                Object var7_6 = null;
                windowPropertyGetter.dispose();
                return bl;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                windowPropertyGetter.dispose();
                throw throwable;
            }
        }
        boolean bl = false;
        Object var7_7 = null;
        windowPropertyGetter.dispose();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processXdndEnter(XClientMessageEvent xClientMessageEvent) {
        WindowPropertyGetter windowPropertyGetter;
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        long[] lArray = null;
        if (this.getSourceWindow() != 0L) {
            return false;
        }
        if (!(XToolkit.windowToXWindow(xClientMessageEvent.get_window()) instanceof XWindow) && this.getEmbedderRegistryEntry(xClientMessageEvent.get_window()) == null) {
            return false;
        }
        if (xClientMessageEvent.get_message_type() != XDnDConstants.XA_XdndEnter.getAtom()) {
            return false;
        }
        n = (int)((xClientMessageEvent.get_data(1) & 0xFFFFFFFFFF000000L) >> 24);
        if (n < 3) {
            return false;
        }
        if (n > 5) {
            return false;
        }
        l = xClientMessageEvent.get_data(0);
        if (n < 2) {
            n2 = 1;
        } else {
            windowPropertyGetter = new WindowPropertyGetter(l, XDnDConstants.XA_XdndActionList, 0L, 65535L, false, 4L);
            try {
                windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (windowPropertyGetter.getActualType() == 4L && windowPropertyGetter.getActualFormat() == 32) {
                    long l3 = windowPropertyGetter.getData();
                    for (int i = 0; i < windowPropertyGetter.getNumberOfItems(); ++i) {
                        n2 |= XDnDConstants.getJavaActionForXDnDAction(Native.getLong(l3, i));
                    }
                } else {
                    n2 = 1;
                    bl = true;
                }
                Object var15_16 = null;
                windowPropertyGetter.dispose();
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                windowPropertyGetter.dispose();
                throw throwable;
            }
        }
        if ((xClientMessageEvent.get_data(1) & 1L) != 0L) {
            windowPropertyGetter = new WindowPropertyGetter(l, XDnDConstants.XA_XdndTypeList, 0L, 65535L, false, 4L);
            try {
                windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                lArray = windowPropertyGetter.getActualType() == 4L && windowPropertyGetter.getActualFormat() == 32 ? Native.toLongs(windowPropertyGetter.getData(), windowPropertyGetter.getNumberOfItems()) : new long[]{};
                Object var17_19 = null;
                windowPropertyGetter.dispose();
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                windowPropertyGetter.dispose();
                throw throwable;
            }
        } else {
            int n3 = 0;
            long[] lArray2 = new long[3];
            for (int i = 0; i < 3; ++i) {
                long l4 = xClientMessageEvent.get_data(2 + i);
                if (l4 == 0L) continue;
                lArray2[n3++] = l4;
            }
            lArray = new long[n3];
            System.arraycopy(lArray2, 0, lArray, 0, n3);
        }
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        XWindowAttributes xWindowAttributes = new XWindowAttributes();
        try {
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
            int n4 = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes.pData);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (n4 == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("XGetWindowAttributes failed");
            }
            l2 = xWindowAttributes.get_your_event_mask();
            Object var19_23 = null;
            xWindowAttributes.dispose();
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            xWindowAttributes.dispose();
            throw throwable;
        }
        XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
        XlibWrapper.XSelectInput(XToolkit.getDisplay(), l, l2 | 0x20000L);
        XToolkit.RESTORE_XERROR_HANDLER();
        if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
            throw new XException("XSelectInput failed");
        }
        this.sourceWindow = l;
        this.sourceWindowMask = l2;
        this.sourceProtocolVersion = n;
        this.sourceActions = n2;
        this.sourceFormats = lArray;
        this.trackSourceActions = bl;
        return true;
    }

    private boolean processXdndPosition(XClientMessageEvent xClientMessageEvent) {
        XBaseWindow xBaseWindow;
        long l;
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.sourceWindow != xClientMessageEvent.get_data(0)) {
            return false;
        }
        XWindow xWindow = null;
        Object object = XToolkit.windowToXWindow(xClientMessageEvent.get_window());
        if (object instanceof XWindow) {
            xWindow = (XWindow)object;
        }
        n2 = (int)(xClientMessageEvent.get_data(2) >> 16);
        n3 = (int)(xClientMessageEvent.get_data(2) & 0xFFFFL);
        if (xWindow == null && (l = XDropTargetRegistry.getRegistry().getEmbeddedDropSite(xClientMessageEvent.get_window(), n2, n3)) != 0L && (xBaseWindow = XToolkit.windowToXWindow(l)) instanceof XWindow) {
            xWindow = (XWindow)xBaseWindow;
        }
        if (xWindow != null) {
            object = xWindow.toLocal(n2, n3);
            n2 = ((Point)object).x;
            n3 = ((Point)object).y;
        }
        if (this.sourceProtocolVersion > 0) {
            l2 = xClientMessageEvent.get_data(3);
        }
        l3 = this.sourceProtocolVersion > 1 ? xClientMessageEvent.get_data(4) : XDnDConstants.XA_XdndActionCopy.getAtom();
        n = XDnDConstants.getJavaActionForXDnDAction(l3);
        if (this.trackSourceActions) {
            this.sourceActions |= n;
        }
        if (xWindow == null) {
            if (this.targetXWindow != null) {
                this.notifyProtocolListener(this.targetXWindow, n2, n3, 0, xClientMessageEvent, 505);
            }
        } else {
            int n4 = 0;
            n4 = this.targetXWindow == null ? 504 : 506;
            this.notifyProtocolListener(xWindow, n2, n3, n, xClientMessageEvent, n4);
        }
        this.userAction = n;
        this.sourceX = n2;
        this.sourceY = n3;
        this.targetXWindow = xWindow;
        return true;
    }

    private boolean processXdndLeave(XClientMessageEvent xClientMessageEvent) {
        if (this.sourceWindow != xClientMessageEvent.get_data(0)) {
            return false;
        }
        this.cleanup();
        return true;
    }

    private boolean processXdndDrop(XClientMessageEvent xClientMessageEvent) {
        if (this.sourceWindow != xClientMessageEvent.get_data(0)) {
            return false;
        }
        if (this.targetXWindow != null) {
            this.notifyProtocolListener(this.targetXWindow, this.sourceX, this.sourceY, this.userAction, xClientMessageEvent, 502);
        }
        return true;
    }

    public int getMessageType(XClientMessageEvent xClientMessageEvent) {
        long l = xClientMessageEvent.get_message_type();
        if (l == XDnDConstants.XA_XdndEnter.getAtom()) {
            return 1;
        }
        if (l == XDnDConstants.XA_XdndPosition.getAtom()) {
            return 2;
        }
        if (l == XDnDConstants.XA_XdndLeave.getAtom()) {
            return 3;
        }
        if (l == XDnDConstants.XA_XdndDrop.getAtom()) {
            return 4;
        }
        return 0;
    }

    protected boolean processClientMessageImpl(XClientMessageEvent xClientMessageEvent) {
        long l = xClientMessageEvent.get_message_type();
        if (l == XDnDConstants.XA_XdndEnter.getAtom()) {
            return this.processXdndEnter(xClientMessageEvent);
        }
        if (l == XDnDConstants.XA_XdndPosition.getAtom()) {
            return this.processXdndPosition(xClientMessageEvent);
        }
        if (l == XDnDConstants.XA_XdndLeave.getAtom()) {
            return this.processXdndLeave(xClientMessageEvent);
        }
        if (l == XDnDConstants.XA_XdndDrop.getAtom()) {
            return this.processXdndDrop(xClientMessageEvent);
        }
        return false;
    }

    protected void sendEnterMessageToToplevel(long l, XClientMessageEvent xClientMessageEvent) {
        long l2 = this.sourceProtocolVersion << 24;
        if (this.sourceFormats != null && this.sourceFormats.length > 3) {
            l2 |= 1L;
        }
        long l3 = this.sourceFormats.length > 0 ? this.sourceFormats[0] : 0L;
        long l4 = this.sourceFormats.length > 1 ? this.sourceFormats[1] : 0L;
        long l5 = this.sourceFormats.length > 2 ? this.sourceFormats[2] : 0L;
        this.sendEnterMessageToToplevelImpl(l, xClientMessageEvent.get_data(0), l2, l3, l4, l5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEnterMessageToToplevelImpl(long l, long l2, long l3, long l4, long l5, long l6) {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(l);
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_message_type(XDnDConstants.XA_XdndEnter.getAtom());
            xClientMessageEvent.set_data(0, l2);
            xClientMessageEvent.set_data(1, l3);
            xClientMessageEvent.set_data(2, l4);
            xClientMessageEvent.set_data(3, l5);
            xClientMessageEvent.set_data(4, l6);
            this.forwardClientMessageToToplevel(l, xClientMessageEvent);
            Object var15_8 = null;
            xClientMessageEvent.dispose();
        }
        catch (Throwable throwable) {
            Object var15_9 = null;
            xClientMessageEvent.dispose();
            throw throwable;
        }
    }

    protected void sendLeaveMessageToToplevel(long l, XClientMessageEvent xClientMessageEvent) {
        this.sendLeaveMessageToToplevelImpl(l, xClientMessageEvent.get_data(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendLeaveMessageToToplevelImpl(long l, long l2) {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(l);
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_message_type(XDnDConstants.XA_XdndLeave.getAtom());
            xClientMessageEvent.set_data(0, l2);
            xClientMessageEvent.set_data(1, 0L);
            this.forwardClientMessageToToplevel(l, xClientMessageEvent);
            Object var7_4 = null;
            xClientMessageEvent.dispose();
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            xClientMessageEvent.dispose();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendResponse(long l, int n, int n2) {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(l);
        if (xClientMessageEvent.get_message_type() != XDnDConstants.XA_XdndPosition.getAtom()) {
            return false;
        }
        if (n == 505) {
            n2 = 0;
        }
        XClientMessageEvent xClientMessageEvent2 = new XClientMessageEvent();
        try {
            xClientMessageEvent2.set_type(33);
            xClientMessageEvent2.set_window(xClientMessageEvent.get_data(0));
            xClientMessageEvent2.set_format(32);
            xClientMessageEvent2.set_message_type(XDnDConstants.XA_XdndStatus.getAtom());
            xClientMessageEvent2.set_data(0, xClientMessageEvent.get_window());
            long l2 = 0L;
            if (n2 != 0) {
                l2 |= 1L;
            }
            xClientMessageEvent2.set_data(1, l2);
            xClientMessageEvent2.set_data(2, 0L);
            xClientMessageEvent2.set_data(3, 0L);
            xClientMessageEvent2.set_data(4, XDnDConstants.getXDnDActionForJavaAction(n2));
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), xClientMessageEvent.get_data(0), false, 0L, xClientMessageEvent2.pData);
                Object var10_7 = null;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            Object var12_10 = null;
            xClientMessageEvent2.dispose();
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            xClientMessageEvent2.dispose();
            throw throwable;
        }
        return true;
    }

    public Object getData(long l, long l2) throws IllegalArgumentException, IOException {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(l);
        long l3 = xClientMessageEvent.get_message_type();
        long l4 = 0L;
        if (l3 == XDnDConstants.XA_XdndPosition.getAtom()) {
            l4 = xClientMessageEvent.get_data(3) & 0xFFFFFFFFL;
        } else if (l3 == XDnDConstants.XA_XdndDrop.getAtom()) {
            l4 = xClientMessageEvent.get_data(2) & 0xFFFFFFFFL;
        } else {
            throw new IllegalArgumentException();
        }
        return XDnDConstants.XDnDSelection.getData(l2, l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendDropDone(long l, boolean bl, int n) {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(l);
        if (xClientMessageEvent.get_message_type() != XDnDConstants.XA_XdndDrop.getAtom()) {
            return false;
        }
        if (n == 2 && bl) {
            long l2 = xClientMessageEvent.get_data(2);
            long l3 = XDnDConstants.XDnDSelection.getSelectionAtom().getAtom();
            XToolkit.awtLock();
            try {
                XlibWrapper.XConvertSelection(XToolkit.getDisplay(), l3, XAtom.get("DELETE").getAtom(), XAtom.get("XAWT_SELECTION").getAtom(), XWindow.getXAWTRootWindow().getWindow(), l2);
                Object var11_8 = null;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            {
            }
        }
        XClientMessageEvent xClientMessageEvent2 = new XClientMessageEvent();
        try {
            xClientMessageEvent2.set_type(33);
            xClientMessageEvent2.set_window(xClientMessageEvent.get_data(0));
            xClientMessageEvent2.set_format(32);
            xClientMessageEvent2.set_message_type(XDnDConstants.XA_XdndFinished.getAtom());
            xClientMessageEvent2.set_data(0, xClientMessageEvent.get_window());
            xClientMessageEvent2.set_data(1, 0L);
            xClientMessageEvent2.set_data(2, 0L);
            if (this.sourceProtocolVersion >= 5) {
                if (bl) {
                    xClientMessageEvent2.set_data(1, 1L);
                }
                xClientMessageEvent2.set_data(2, XDnDConstants.getXDnDActionForJavaAction(n));
            }
            xClientMessageEvent2.set_data(3, 0L);
            xClientMessageEvent2.set_data(4, 0L);
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), xClientMessageEvent.get_data(0), false, 0L, xClientMessageEvent2.pData);
                Object var13_11 = null;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            Object var15_14 = null;
            xClientMessageEvent2.dispose();
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            xClientMessageEvent2.dispose();
            throw throwable;
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XFlush(XToolkit.getDisplay());
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        this.targetXWindow = null;
        this.cleanup();
        return true;
    }

    public final long getSourceWindow() {
        return this.sourceWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        XDropTargetEventProcessor.reset();
        if (this.targetXWindow != null) {
            this.notifyProtocolListener(this.targetXWindow, 0, 0, 0, null, 505);
        }
        if (this.sourceWindow != 0L) {
            XToolkit.awtLock();
            try {
                XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.sourceWindow, this.sourceWindowMask);
                XToolkit.RESTORE_XERROR_HANDLER();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            {
            }
        }
        this.sourceWindow = 0L;
        this.sourceWindowMask = 0L;
        this.sourceProtocolVersion = 0;
        this.sourceActions = 0;
        this.sourceFormats = null;
        this.trackSourceActions = false;
        this.userAction = 0;
        this.sourceX = 0;
        this.sourceY = 0;
        this.targetXWindow = null;
    }

    public boolean isDragOverComponent() {
        return this.targetXWindow != null;
    }

    public void adjustEventForForwarding(XClientMessageEvent xClientMessageEvent, XDropTargetProtocol.EmbedderRegistryEntry embedderRegistryEntry) {
        int n = embedderRegistryEntry.getVersion();
        if (xClientMessageEvent.get_message_type() == XDnDConstants.XA_XdndEnter.getAtom()) {
            int n2 = this.sourceProtocolVersion < n ? this.sourceProtocolVersion : n;
            long l = n2 << 24;
            if (this.sourceFormats != null && this.sourceFormats.length > 3) {
                l |= 1L;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("          entryVersion=" + n + " sourceProtocolVersion=" + this.sourceProtocolVersion + " sourceFormats.length=" + (this.sourceFormats != null ? this.sourceFormats.length : 0));
            }
            xClientMessageEvent.set_data(1, l);
        }
    }

    private void notifyProtocolListener(XWindow xWindow, int n, int n2, int n3, XClientMessageEvent xClientMessageEvent, int n4) {
        long l = 0L;
        if (xClientMessageEvent != null) {
            new XClientMessageEvent(l);
            int n5 = XClientMessageEvent.getSize();
            l = unsafe.allocateMemory(n5 + 4 * Native.getLongSize());
            unsafe.copyMemory(xClientMessageEvent.pData, l, n5);
            long l2 = this.sourceProtocolVersion << 24;
            if (this.sourceFormats != null && this.sourceFormats.length > 3) {
                l2 |= 1L;
            }
            Native.putLong(l + (long)n5, l2);
            Native.putLong(l + (long)n5 + (long)Native.getLongSize(), this.sourceFormats.length > 0 ? this.sourceFormats[0] : 0L);
            Native.putLong(l + (long)n5 + (long)(2 * Native.getLongSize()), this.sourceFormats.length > 1 ? this.sourceFormats[1] : 0L);
            Native.putLong(l + (long)n5 + (long)(3 * Native.getLongSize()), this.sourceFormats.length > 2 ? this.sourceFormats[2] : 0L);
        }
        this.getProtocolListener().handleDropTargetNotification(xWindow, n, n2, n3, this.sourceActions, this.sourceFormats, l, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forwardEventToEmbedded(long l, long l2, int n) {
        XClientMessageEvent xClientMessageEvent;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("        ctxt=" + l2 + " type=" + (l2 != 0L ? this.getMessageType(new XClientMessageEvent(l2)) : 0) + " prevCtxt=" + this.prevCtxt + " prevType=" + (this.prevCtxt != 0L ? this.getMessageType(new XClientMessageEvent(this.prevCtxt)) : 0));
        }
        if (!(l2 != 0L && this.getMessageType(new XClientMessageEvent(l2)) != 0 || this.prevCtxt != 0L && this.getMessageType(new XClientMessageEvent(this.prevCtxt)) != 0)) {
            return false;
        }
        int n2 = XClientMessageEvent.getSize();
        if (l2 != 0L) {
            xClientMessageEvent = new XClientMessageEvent(l2);
            if (!this.overXEmbedClient) {
                long l3 = Native.getLong(l2 + (long)n2);
                long l4 = Native.getLong(l2 + (long)n2 + (long)Native.getLongSize());
                long l5 = Native.getLong(l2 + (long)n2 + (long)(2 * Native.getLongSize()));
                long l6 = Native.getLong(l2 + (long)n2 + (long)(3 * Native.getLongSize()));
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("         1  embedded=" + l + " source=" + xClientMessageEvent.get_data(0) + " data1=" + l3 + " data2=" + l4 + " data3=" + l5 + " data4=" + l6);
                }
                if ((l3 & 1L) != 0L) {
                    WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(xClientMessageEvent.get_data(0), XDnDConstants.XA_XdndTypeList, 0L, 65535L, false, 4L);
                    try {
                        block19: {
                            windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                            if (windowPropertyGetter.getActualType() == 4L && windowPropertyGetter.getActualFormat() == 32) {
                                XToolkit.awtLock();
                                try {
                                    XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
                                    XDnDConstants.XA_XdndTypeList.setAtomData(xClientMessageEvent.get_window(), 4L, windowPropertyGetter.getData(), windowPropertyGetter.getNumberOfItems());
                                    XToolkit.RESTORE_XERROR_HANDLER();
                                    if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0 && logger.isLoggable(Level.WARNING)) {
                                        logger.warning("Cannot set XdndTypeList on the proxy window");
                                    }
                                    Object var18_12 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var18_13 = null;
                                    XToolkit.awtUnlock();
                                    throw throwable;
                                }
                                XToolkit.awtUnlock();
                                {
                                    break block19;
                                }
                            }
                            if (logger.isLoggable(Level.WARNING)) {
                                logger.warning("Cannot read XdndTypeList from the source window");
                            }
                        }
                        Object var20_15 = null;
                        windowPropertyGetter.dispose();
                    }
                    catch (Throwable throwable) {
                        Object var20_16 = null;
                        windowPropertyGetter.dispose();
                        throw throwable;
                    }
                }
                XDragSourceContextPeer.setProxyModeSourceWindow(xClientMessageEvent.get_data(0));
                this.sendEnterMessageToToplevelImpl(l, xClientMessageEvent.get_window(), l3, l4, l5, l6);
                this.overXEmbedClient = true;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("         2  embedded=" + l + " xclient=" + xClientMessageEvent);
            }
            XClientMessageEvent xClientMessageEvent2 = new XClientMessageEvent();
            unsafe.copyMemory(xClientMessageEvent.pData, xClientMessageEvent2.pData, xClientMessageEvent2.getSize());
            xClientMessageEvent2.set_data(0, xClientMessageEvent.get_window());
            this.forwardClientMessageToToplevel(l, xClientMessageEvent2);
        }
        if (n == 505 && this.overXEmbedClient) {
            if (l2 != 0L || this.prevCtxt != 0L) {
                xClientMessageEvent = l2 != 0L ? new XClientMessageEvent(l2) : new XClientMessageEvent(this.prevCtxt);
                this.sendLeaveMessageToToplevelImpl(l, xClientMessageEvent.get_window());
            }
            this.overXEmbedClient = false;
            XDragSourceContextPeer.setProxyModeSourceWindow(0L);
        }
        if (n == 502) {
            this.overXEmbedClient = false;
            this.cleanup();
        }
        if (this.prevCtxt != 0L) {
            unsafe.freeMemory(this.prevCtxt);
            this.prevCtxt = 0L;
        }
        if (l2 != 0L && this.overXEmbedClient) {
            this.prevCtxt = unsafe.allocateMemory(n2 + 4 * Native.getLongSize());
            unsafe.copyMemory(l2, this.prevCtxt, n2 + 4 * Native.getLongSize());
        }
        return true;
    }

    public boolean isXEmbedSupported() {
        return true;
    }
}

