/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.DefaultLookup;
import sun.swing.plaf.synth.SynthUI;

class SynthOptionPaneUI
extends BasicOptionPaneUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    SynthOptionPaneUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthOptionPaneUI();
    }

    protected void installDefaults() {
        this.updateStyle(this.optionPane);
    }

    protected void installListeners() {
        super.installListeners();
        this.optionPane.addPropertyChangeListener(this);
    }

    private void updateStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.minimumSize = (Dimension)this.style.get(synthContext, "OptionPane.minimumSize");
            if (this.minimumSize == null) {
                this.minimumSize = new Dimension(262, 90);
            }
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.optionPane, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.optionPane.removePropertyChangeListener(this);
    }

    protected void installComponents() {
        this.optionPane.add(this.createMessageArea());
        Container container = this.createSeparator();
        if (container != null) {
            this.optionPane.add(container);
            SynthContext synthContext = this.getContext(this.optionPane, 1);
            this.optionPane.add(Box.createVerticalStrut(synthContext.getStyle().getInt(synthContext, "OptionPane.separatorPadding", 6)));
            synthContext.dispose();
        }
        this.optionPane.add(this.createButtonArea());
        this.optionPane.applyComponentOrientation(this.optionPane.getComponentOrientation());
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintOptionPaneBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintOptionPaneBorder(synthContext, graphics, n, n2, n3, n4);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JOptionPane)propertyChangeEvent.getSource());
        }
    }

    protected boolean getSizeButtonsToSameWidth() {
        return DefaultLookup.getBoolean(this.optionPane, this, "OptionPane.sameSizeButtons", true);
    }

    protected Container createMessageArea() {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        jPanel.setName("OptionPane.messageArea");
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.setName("OptionPane.body");
        jPanel3.setName("OptionPane.realBody");
        if (this.getIcon() != null) {
            serializable = new JPanel();
            serializable.setName("OptionPane.separator");
            serializable.setPreferredSize(new Dimension(15, 1));
            jPanel3.add((Component)serializable, "Before");
        }
        jPanel3.add((Component)jPanel2, "Center");
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).gridheight = 1;
        SynthContext synthContext = this.getContext(this.optionPane, 1);
        ((GridBagConstraints)serializable).anchor = synthContext.getStyle().getInt(synthContext, "OptionPane.messageAnchor", 10);
        synthContext.dispose();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 3, 0);
        this.addMessageComponents(jPanel2, (GridBagConstraints)serializable, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        jPanel.add((Component)jPanel3, "Center");
        this.addIcon(jPanel);
        return jPanel;
    }

    protected Container createSeparator() {
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setName("OptionPane.separator");
        return jSeparator;
    }
}

